/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.util;

final class MathPow {
    MathPow() {
    }

    static final double pow(double x, double y) {
        return MathPow.powTaylor(x, y);
    }

    private static final double powSqrt(double x, double y) {
        int i;
        int den = 1024;
        int num = (int)(y * (double)den);
        int iterations = 10;
        double n = Double.MAX_VALUE;
        while (n >= Double.MAX_VALUE && iterations > 1) {
            n = x;
            for (i = 1; i < num; ++i) {
                n *= x;
            }
            if (!(n >= Double.MAX_VALUE)) continue;
            --iterations;
            num = (int)(y * (double)(den /= 2));
        }
        for (i = 0; i < iterations; ++i) {
            n = Math.sqrt(n);
        }
        return n;
    }

    private static final double powDecay(double x, double y) {
        int i;
        int den = 1001;
        int s = 0;
        double n = x;
        double z = Double.MAX_VALUE;
        for (i = 1; i < s; ++i) {
            n *= x;
        }
        while (z >= Double.MAX_VALUE) {
            int num = (int)(y * (double)(--den));
            s = num / den + 1;
            z = x;
            for (i = 1; i < num; ++i) {
                z *= x;
            }
        }
        while (n > 0.0) {
            double a = n;
            for (int i2 = 1; i2 < den; ++i2) {
                a *= n;
            }
            if (a - z < 1.0E-5 || z - a > 1.0E-5) {
                return n;
            }
            n *= 0.9999;
        }
        return -1.0;
    }

    private static final double powTaylor(double a, double b) {
        int i;
        boolean gt1 = !(Math.sqrt((a - 1.0) * (a - 1.0)) <= 1.0);
        int oc = -1;
        int iter = 30;
        double p = a;
        if (b - Math.floor(b) == 0.0) {
            int i2 = 1;
            while ((double)i2 < b) {
                p *= a;
                ++i2;
            }
            return p;
        }
        double x = gt1 ? a / (a - 1.0) : a - 1.0;
        double sumX = gt1 ? 1.0 / x : x;
        for (i = 2; i < iter; ++i) {
            p = x;
            for (int j = 1; j < i; ++j) {
                p *= x;
            }
            double xTemp = gt1 ? 1.0 / ((double)i * p) : p / (double)i;
            sumX = gt1 ? sumX + xTemp : sumX + xTemp * (double)oc;
            oc *= -1;
        }
        double x2 = b * sumX;
        double sumY = 1.0 + x2;
        for (i = 2; i <= iter; ++i) {
            p = x2;
            for (int j = 1; j < i; ++j) {
                p *= x2;
            }
            int yTemp = 2;
            for (int j = i; j > 2; --j) {
                yTemp *= j;
            }
            sumY += p / (double)yTemp;
        }
        return sumY;
    }
}

