/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.function;

import javax.measure.UnitConverter;
import tec.units.ri.AbstractConverter;
import tec.units.ri.function.MathHelper;
import tec.units.ri.function.ValueSupplier;

public final class RationalConverter
extends AbstractConverter
implements ValueSupplier<Double> {
    private final double dividend;
    private final double divisor;

    public RationalConverter(double dividend, double divisor) {
        this.dividend = dividend;
        this.divisor = divisor;
    }

    public static final RationalConverter of(long dividend, long divisor) {
        return new RationalConverter(dividend, divisor);
    }

    public static final RationalConverter of(double dividend, double divisor) {
        return new RationalConverter(dividend, divisor);
    }

    public double getDividend() {
        return this.dividend;
    }

    public double getDivisor() {
        return this.divisor;
    }

    @Override
    public double convert(double value) {
        return value * (this.dividend / this.divisor);
    }

    @Override
    public UnitConverter concatenate(UnitConverter converter) {
        if (!(converter instanceof RationalConverter)) {
            return super.concatenate(converter);
        }
        RationalConverter that = (RationalConverter)converter;
        double newDividend = this.getDividend() * that.getDividend();
        double newDivisor = this.getDivisor() * that.getDivisor();
        double gcd = MathHelper.gcd(newDividend, newDivisor);
        return (newDividend /= gcd) == 1.0 && newDivisor == 1.0 ? IDENTITY : new RationalConverter(newDividend, newDivisor /= gcd);
    }

    @Override
    public RationalConverter inverse() {
        return Math.signum(this.dividend) == -1.0 ? new RationalConverter(MathHelper.negateExact(this.getDivisor()), MathHelper.negateExact(this.getDividend())) : new RationalConverter(this.getDivisor(), this.getDividend());
    }

    public final String toString() {
        return "RationalConverter(" + this.dividend + "," + this.divisor + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RationalConverter)) {
            return false;
        }
        RationalConverter that = (RationalConverter)obj;
        return this.dividend == that.dividend && this.divisor == that.divisor;
    }

    @Override
    public int hashCode() {
        return Double.valueOf(this.dividend).hashCode() + Double.valueOf(this.dividend).hashCode();
    }

    public boolean isLinear() {
        return true;
    }

    public double getAsDouble() {
        return this.dividend / this.divisor;
    }

    @Override
    public Double getValue() {
        return this.getAsDouble();
    }
}

