/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.format;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.UnitConverter;
import tec.units.ri.AbstractUnit;
import tec.units.ri.util.SIPrefix;

public final class SymbolMap {
    private static final Logger logger = Logger.getLogger(SymbolMap.class.getName());
    private final Map<String, AbstractUnit<?>> symbolToUnit = new HashMap();
    private final Map<AbstractUnit<?>, String> unitToSymbol = new HashMap();
    private final Map<String, Object> symbolToPrefix = new HashMap<String, Object>();
    private final Map<Object, String> prefixToSymbol = new HashMap<Object, String>();
    private final Map<UnitConverter, SIPrefix> converterToPrefix = new HashMap<UnitConverter, SIPrefix>();

    private SymbolMap() {
    }

    private SymbolMap(Map<String, String> map) {
        this();
        for (String fqn : map.keySet()) {
            String symbol = map.get(fqn);
            boolean isAlias = false;
            int lastDot = fqn.lastIndexOf(46);
            String className = fqn.substring(0, lastDot);
            String fieldName = fqn.substring(lastDot + 1, fqn.length());
            if (Character.isDigit(fieldName.charAt(0))) {
                isAlias = true;
                fqn = className;
                lastDot = fqn.lastIndexOf(46);
                className = fqn.substring(0, lastDot);
                fieldName = fqn.substring(lastDot + 1, fqn.length());
            }
            try {
                Class<?> c = Class.forName(className);
                Field field = c.getField(fieldName);
                Object value = field.get(null);
                if (value instanceof AbstractUnit) {
                    if (isAlias) {
                        this.alias((AbstractUnit)value, symbol);
                        continue;
                    }
                    this.label((AbstractUnit)value, symbol);
                    continue;
                }
                if (value instanceof SIPrefix) {
                    this.label((SIPrefix)value, symbol);
                    continue;
                }
                throw new ClassCastException("unable to cast " + value + " to Unit or Prefix");
            }
            catch (Exception error) {
                logger.log(Level.SEVERE, "Error", error);
            }
        }
    }

    public static SymbolMap of(Map<String, String> rm) {
        return new SymbolMap(rm);
    }

    public void label(AbstractUnit<?> unit, String symbol) {
        this.symbolToUnit.put(symbol, unit);
        this.unitToSymbol.put(unit, symbol);
    }

    public void alias(AbstractUnit<?> unit, String symbol) {
        this.symbolToUnit.put(symbol, unit);
    }

    public void label(SIPrefix prefix, String symbol) {
        this.symbolToPrefix.put(symbol, prefix);
        this.prefixToSymbol.put(prefix, symbol);
        this.converterToPrefix.put(prefix.getConverter(), prefix);
    }

    public AbstractUnit<?> getUnit(String symbol) {
        return this.symbolToUnit.get(symbol);
    }

    public String getSymbol(AbstractUnit<?> unit) {
        return this.unitToSymbol.get(unit);
    }

    public SIPrefix getPrefix(String symbol) {
        for (String pfSymbol : this.symbolToPrefix.keySet()) {
            if (!symbol.startsWith(pfSymbol)) continue;
            return (SIPrefix)this.symbolToPrefix.get(pfSymbol);
        }
        return null;
    }

    public SIPrefix getPrefix(UnitConverter converter) {
        return this.converterToPrefix.get(converter);
    }

    public String getSymbol(SIPrefix prefix) {
        return this.prefixToSymbol.get(prefix);
    }
}

