/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Acceleration;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.CatalyticActivity;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCapacitance;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.ElectricConductance;
import javax.measure.quantity.ElectricCurrent;
import javax.measure.quantity.ElectricInductance;
import javax.measure.quantity.ElectricPotential;
import javax.measure.quantity.ElectricResistance;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Force;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Illuminance;
import javax.measure.quantity.Information;
import javax.measure.quantity.Length;
import javax.measure.quantity.LuminousFlux;
import javax.measure.quantity.LuminousIntensity;
import javax.measure.quantity.MagneticFlux;
import javax.measure.quantity.MagneticFluxDensity;
import javax.measure.quantity.MagnetomotiveForce;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Power;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseAbsorbed;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import javax.measure.spi.QuantityFactory;
import tec.units.ri.AbstractQuantity;
import tec.units.ri.AbstractUnit;
import tec.units.ri.quantity.NumberQuantity;
import tec.units.ri.util.SI;

public abstract class AbstractQuantityFactory<Q extends Quantity<Q>>
implements QuantityFactory<Q> {
    private static final Map<Class, AbstractQuantityFactory> INSTANCES = new HashMap<Class, AbstractQuantityFactory>();
    private static final Logger logger = Logger.getLogger(AbstractQuantityFactory.class.getName());
    private static final Level LOG_LEVEL = Level.FINE;

    public static <Q extends Quantity<Q>> AbstractQuantityFactory<Q> getInstance(Class<Q> type) {
        AbstractQuantityFactory factory;
        logger.log(LOG_LEVEL, "Type: " + type + ": " + type.isInterface());
        if (!type.isInterface()) {
            if (type != null && type.getInterfaces() != null & type.getInterfaces().length > 0) {
                logger.log(LOG_LEVEL, "Type0: " + type.getInterfaces()[0]);
                Class<?> type2 = type.getInterfaces()[0];
                factory = INSTANCES.get(type2);
                if (factory != null) {
                    return factory;
                }
                if (!AbstractQuantity.class.isAssignableFrom(type2)) {
                    throw new ClassCastException();
                }
                factory = new Default(type2);
                INSTANCES.put(type2, factory);
            } else {
                factory = INSTANCES.get(type);
                if (factory != null) {
                    return factory;
                }
                if (!AbstractQuantity.class.isAssignableFrom(type)) {
                    throw new ClassCastException();
                }
                factory = new Default<Q>(type);
                INSTANCES.put(type, factory);
            }
        } else {
            factory = INSTANCES.get(type);
            if (factory != null) {
                return factory;
            }
            if (!Quantity.class.isAssignableFrom(type)) {
                throw new ClassCastException();
            }
            factory = new Default<Q>(type);
            INSTANCES.put(type, factory);
        }
        return factory;
    }

    protected static <Q extends Quantity<Q>> void setInstance(Class<Q> type, AbstractQuantityFactory<Q> factory) {
        if (!AbstractQuantity.class.isAssignableFrom(type)) {
            throw new ClassCastException();
        }
        INSTANCES.put(type, factory);
    }

    public abstract <N extends Number, U extends Unit<Q>> Q create(N var1, U var2);

    public abstract Unit<Q> getMetricUnit();

    private static final class Default<Q extends Quantity<Q>>
    extends AbstractQuantityFactory<Q> {
        private final Class<Q> type;
        private final Unit<Q> metricUnit;
        static final Map<Class, Unit> CLASS_TO_METRIC_UNIT = new HashMap<Class, Unit>();

        Default(Class<Q> type) {
            this.type = type;
            this.metricUnit = CLASS_TO_METRIC_UNIT.get(type);
        }

        @Override
        public <N extends Number, U extends Unit<Q>> Q create(N value, U unit) {
            return (Q)new NumberQuantity(value, unit);
        }

        @Override
        public Unit<Q> getMetricUnit() {
            return this.metricUnit;
        }

        static {
            CLASS_TO_METRIC_UNIT.put(Dimensionless.class, AbstractUnit.ONE);
            CLASS_TO_METRIC_UNIT.put(ElectricCurrent.class, SI.AMPERE);
            CLASS_TO_METRIC_UNIT.put(LuminousIntensity.class, SI.CANDELA);
            CLASS_TO_METRIC_UNIT.put(Temperature.class, SI.KELVIN);
            CLASS_TO_METRIC_UNIT.put(Mass.class, SI.KILOGRAM);
            CLASS_TO_METRIC_UNIT.put(Length.class, SI.METRE);
            CLASS_TO_METRIC_UNIT.put(AmountOfSubstance.class, SI.MOLE);
            CLASS_TO_METRIC_UNIT.put(Time.class, SI.SECOND);
            CLASS_TO_METRIC_UNIT.put(MagnetomotiveForce.class, SI.AMPERE_TURN);
            CLASS_TO_METRIC_UNIT.put(Angle.class, SI.RADIAN);
            CLASS_TO_METRIC_UNIT.put(SolidAngle.class, SI.STERADIAN);
            CLASS_TO_METRIC_UNIT.put(Information.class, SI.BIT);
            CLASS_TO_METRIC_UNIT.put(Frequency.class, SI.HERTZ);
            CLASS_TO_METRIC_UNIT.put(Force.class, SI.NEWTON);
            CLASS_TO_METRIC_UNIT.put(Pressure.class, SI.PASCAL);
            CLASS_TO_METRIC_UNIT.put(Energy.class, SI.JOULE);
            CLASS_TO_METRIC_UNIT.put(Power.class, SI.WATT);
            CLASS_TO_METRIC_UNIT.put(ElectricCharge.class, SI.COULOMB);
            CLASS_TO_METRIC_UNIT.put(ElectricPotential.class, SI.VOLT);
            CLASS_TO_METRIC_UNIT.put(ElectricCapacitance.class, SI.FARAD);
            CLASS_TO_METRIC_UNIT.put(ElectricResistance.class, SI.OHM);
            CLASS_TO_METRIC_UNIT.put(ElectricConductance.class, SI.SIEMENS);
            CLASS_TO_METRIC_UNIT.put(MagneticFlux.class, SI.WEBER);
            CLASS_TO_METRIC_UNIT.put(MagneticFluxDensity.class, SI.TESLA);
            CLASS_TO_METRIC_UNIT.put(ElectricInductance.class, SI.HENRY);
            CLASS_TO_METRIC_UNIT.put(LuminousFlux.class, SI.LUMEN);
            CLASS_TO_METRIC_UNIT.put(Illuminance.class, SI.LUX);
            CLASS_TO_METRIC_UNIT.put(Radioactivity.class, SI.BECQUEREL);
            CLASS_TO_METRIC_UNIT.put(RadiationDoseAbsorbed.class, SI.GRAY);
            CLASS_TO_METRIC_UNIT.put(RadiationDoseEffective.class, SI.SIEVERT);
            CLASS_TO_METRIC_UNIT.put(CatalyticActivity.class, SI.KATAL);
            CLASS_TO_METRIC_UNIT.put(Speed.class, SI.METRES_PER_SECOND);
            CLASS_TO_METRIC_UNIT.put(Acceleration.class, SI.METRES_PER_SQUARE_SECOND);
            CLASS_TO_METRIC_UNIT.put(Area.class, SI.SQUARE_METRE);
            CLASS_TO_METRIC_UNIT.put(Volume.class, SI.CUBIC_METRE);
        }
    }
}

