/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri;

import javax.measure.Quantity;
import tec.units.ri.Measurement;

public abstract class AbstractMeasurement<Q extends Quantity<Q>>
implements Measurement<Q> {
    private final Quantity<Q> quantity;
    private final long timestamp;

    protected AbstractMeasurement(Quantity<Q> q, long t) {
        this.quantity = q;
        this.timestamp = t;
    }

    protected AbstractMeasurement(Quantity<Q> q) {
        this(q, System.currentTimeMillis());
    }

    @Override
    public final Quantity<Q> getQuantity() {
        return this.quantity;
    }

    @Override
    public final long getTimestamp() {
        return this.timestamp;
    }

    static final <Q extends Quantity<Q>> Measurement<Q> of(Quantity<Q> q) {
        return new Default(q);
    }

    static final <Q extends Quantity<Q>> Measurement<Q> of(Quantity<Q> q, long t) {
        return new Default(q, t);
    }

    private static final class Default<Q>
    extends AbstractMeasurement {
        protected <R extends Quantity<R>> Default(Quantity<R> q, long t) {
            super(q, t);
        }

        protected <R extends Quantity<R>> Default(Quantity<R> q) {
            super(q);
        }

        @Override
        public int compareTo(Object o) {
            return 0;
        }
    }
}

