/*
 * Decompiled with CFR 0.152.
 */
package teamdapsr.loaders.lib;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AnticipateOvershootInterpolator;
import teamdapsr.loaders.lib.R;
import teamdapsr.loaders.lib.utils.MeasureUtils;

public class HeartDrawView
extends View {
    private String LOG_TAG = ((Object)((Object)this)).getClass().getSimpleName();
    protected int mTValue;
    protected Paint mHeartPaint;
    protected int mAngle = 0;
    protected Path mHeartOutline;
    protected int mX;
    protected int mY;
    protected int centerX;
    protected int centerY;
    protected ValueAnimator mSizeAnimator;
    protected Path mEmptyPath = new Path();

    public HeartDrawView(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeartDrawView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray styledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.HeartDrawView, 0, 0);
        try {
            this.mTValue = styledAttributes.getInt(R.styleable.HeartDrawView_tValue, 10);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            styledAttributes.recycle();
        }
        this.init();
    }

    protected void init() {
        this.mHeartPaint = new Paint(1);
        this.mHeartPaint.setStyle(Paint.Style.STROKE);
        this.mHeartPaint.setColor(-65536);
        this.mHeartOutline = new Path();
        this.mSizeAnimator = ValueAnimator.ofFloat((float[])new float[]{(float)(0.5 * (double)this.mTValue), this.mTValue});
        this.mSizeAnimator.setDuration(3000L);
        this.mSizeAnimator.setInterpolator((TimeInterpolator)new AnticipateOvershootInterpolator());
        this.mSizeAnimator.setRepeatMode(2);
        this.mSizeAnimator.setRepeatCount(-1);
        this.mSizeAnimator.start();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mHeartOutline.reset();
        this.mAngle = 360;
        Log.i((String)this.LOG_TAG, (String)"Angle reset.");
        float size = ((Float)this.mSizeAnimator.getAnimatedValue()).floatValue();
        Log.i((String)this.LOG_TAG, (String)("TValue animated value: " + this.mTValue));
        while (this.mAngle != 0) {
            this.mHeartOutline.moveTo((float)this.mX, (float)this.mY);
            this.mX = this.centerX + (int)((double)(size * 16.0f) * Math.pow(Math.sin(Math.toRadians(this.mAngle)), 3.0));
            this.mY = this.centerY + (int)((double)size * (13.0 * Math.cos(Math.toRadians(this.mAngle)) - 5.0 * Math.cos(2.0 * Math.toRadians(this.mAngle)) - 2.0 * Math.cos(3.0 * Math.toRadians(this.mAngle)) - Math.cos(4.0 * Math.toRadians(this.mAngle))));
            this.mY *= -1;
            this.mY += this.getMeasuredHeight();
            this.mHeartOutline.lineTo((float)this.mX, (float)this.mY);
            this.mAngle -= 2;
        }
        canvas.drawPath(this.mHeartOutline, this.mHeartPaint);
        Log.i((String)this.LOG_TAG, (String)"Shape drawn.");
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.invalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.centerX = (int)event.getX();
        this.centerY = (int)event.getY();
        this.postInvalidate();
        return true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = MeasureUtils.getMeasurement(widthMeasureSpec, this.getDesiredWidth());
        int heightSize = MeasureUtils.getMeasurement(heightMeasureSpec, this.getDesiredHeight());
        this.setMeasuredDimension(widthSize + 10, heightSize + 10);
        this.centerX = this.getMeasuredWidth() / 2;
        this.centerY = this.getMeasuredHeight() / 2;
    }

    private int getDesiredWidth() {
        return 2 * this.mTValue + 300;
    }

    private int getDesiredHeight() {
        return 2 * this.mTValue + 300;
    }
}

