/*
 * Decompiled with CFR 0.152.
 */
package teamdapsr.loaders.lib;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;

public class HeartBeatView
extends View {
    private static Paint paint;
    private int screenW;
    private int screenH;
    private float X;
    private float Y;
    private Path path;
    private float initialScreenW;
    private float initialX;
    private float plusX;
    private float TX;
    private boolean translate;
    private int flash;
    private Context context;

    public HeartBeatView(Context context, AttributeSet attrs) {
        super(context);
        this.context = context;
        paint = new Paint();
        paint.setColor(Color.argb((int)17, (int)17, (int)221, (int)34));
        paint.setStrokeWidth(10.0f);
        paint.setAntiAlias(true);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStyle(Paint.Style.STROKE);
        paint.setShadowLayer(7.0f, 0.0f, 0.0f, -65536);
        this.path = new Path();
        this.TX = 0.0f;
        this.translate = false;
        this.flash = 0;
    }

    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.screenW = w;
        this.screenH = h;
        this.X = 0.0f;
        this.Y = this.screenH / 2 + this.screenH / 4 + this.screenH / 10;
        this.initialScreenW = this.screenW;
        this.initialX = this.screenW / 2 + this.screenW / 4;
        this.plusX = this.screenW / 24;
        this.path.moveTo(this.X, this.Y);
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        ++this.flash;
        if (this.flash < 10 || this.flash > 20 && this.flash < 30) {
            paint.setStrokeWidth(16.0f);
            paint.setColor(-65536);
            paint.setShadowLayer(12.0f, 0.0f, 0.0f, -65536);
        } else {
            paint.setStrokeWidth(10.0f);
            paint.setColor(Color.argb((int)255, (int)153, (int)0, (int)0));
            paint.setShadowLayer(7.0f, 0.0f, 0.0f, -65536);
        }
        if (this.flash == 100) {
            this.flash = 0;
        }
        this.path.lineTo(this.X, this.Y);
        canvas.translate(-this.TX, 0.0f);
        if (this.translate) {
            this.TX += 4.0f;
        }
        if (this.X < this.initialX) {
            this.X += 8.0f;
        } else if (this.X < this.initialX + this.plusX) {
            this.X += 2.0f;
            this.Y -= 8.0f;
        } else if (this.X < this.initialX + this.plusX * 2.0f) {
            this.X += 2.0f;
            this.Y += 14.0f;
        } else if (this.X < this.initialX + this.plusX * 3.0f) {
            this.X += 2.0f;
            this.Y -= 12.0f;
        } else if (this.X < this.initialX + this.plusX * 4.0f) {
            this.X += 2.0f;
            this.Y += 6.0f;
        } else if (this.X < this.initialScreenW) {
            this.X += 8.0f;
        } else {
            this.translate = true;
            this.initialX += this.initialScreenW;
        }
        canvas.drawPath(this.path, paint);
        this.invalidate();
    }
}

