/*
 * Decompiled with CFR 0.152.
 */
package teamdapsr.loaders.lib;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import teamdapsr.loaders.lib.R;
import teamdapsr.loaders.lib.utils.MeasureUtils;
import teamdapsr.loaders.lib.utils.Utils;

public class ConcentricCircleView
extends View {
    private String LOG_TAG = ((Object)((Object)this)).getClass().getSimpleName();
    protected int mMinRadius;
    protected int mMaxRadius;
    protected int mCirclesCount;
    protected boolean mAnimateColor;
    protected int mStartColor;
    protected int mEndColor;
    protected int mDuration;
    protected ValueAnimator[] mAnim;
    protected Paint[] mPaint;
    protected Paint mAnimatePaint;
    protected ValueAnimator mColorAnim;

    public ConcentricCircleView(Context context) {
        super(context);
        this.mMaxRadius = 0;
        this.mMaxRadius = 100;
        this.mCirclesCount = 3;
        this.mAnimateColor = false;
        this.mDuration = 3000;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcentricCircleView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray styledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ConcentricCircleView, 0, 0);
        try {
            this.mMinRadius = styledAttributes.getInt(R.styleable.ConcentricCircleView_min_radius, 0);
            this.mMaxRadius = styledAttributes.getInt(R.styleable.ConcentricCircleView_max_radius, 100);
            this.mCirclesCount = styledAttributes.getInt(R.styleable.ConcentricCircleView_circles_count, 3);
            this.mAnimateColor = styledAttributes.getBoolean(R.styleable.ConcentricCircleView_animate_color, true);
            if (this.mAnimateColor) {
                this.mStartColor = styledAttributes.getColor(R.styleable.ConcentricCircleView_start_color, Color.parseColor((String)"#00000000"));
                this.mEndColor = styledAttributes.getColor(R.styleable.ConcentricCircleView_end_color, Color.parseColor((String)"#ffffffff"));
            }
            this.mDuration = styledAttributes.getInt(R.styleable.ConcentricCircleView_duration, 1500);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            styledAttributes.recycle();
        }
        this.init();
    }

    protected void init() {
        if (this.mAnimateColor) {
            this.mAnimatePaint = new Paint(1);
            this.mAnimatePaint.setStyle(Paint.Style.FILL);
            this.mAnimatePaint.setColor(this.mStartColor);
        } else {
            this.mPaint = new Paint[this.mCirclesCount];
            for (int i = 0; i < this.mPaint.length; ++i) {
                this.mPaint[i] = new Paint(1);
                this.mPaint[i].setStyle(Paint.Style.FILL);
                this.mPaint[i].setColor(Utils.randomColor());
            }
        }
    }

    protected void setupAnimations() {
        if (this.mAnimateColor) {
            this.mColorAnim = this.mStartColor <= this.mEndColor ? ValueAnimator.ofInt((int[])new int[]{this.mStartColor, this.mEndColor}) : ValueAnimator.ofInt((int[])new int[]{this.mEndColor, this.mStartColor});
            this.mColorAnim.setDuration((long)(this.mDuration * 10));
            this.mColorAnim.setRepeatMode(2);
            this.mColorAnim.setRepeatCount(-1);
            this.mColorAnim.start();
        }
        this.mAnim = new ValueAnimator[this.mCirclesCount];
        for (int i = 0; i < this.mAnim.length; ++i) {
            this.mAnim[i] = ValueAnimator.ofInt((int[])new int[]{this.mMinRadius, this.mMaxRadius});
            this.mAnim[i].setDuration((long)this.mDuration);
            this.mAnim[i].setRepeatMode(2);
            this.mAnim[i].setRepeatCount(-1);
            this.mAnim[i].setInterpolator((TimeInterpolator)Utils.randomInterpolator());
            this.mAnim[i].start();
        }
    }

    public void onDraw(Canvas canvas) {
        int i;
        super.onDraw(canvas);
        if (!this.mAnimateColor) {
            for (i = 0; i < this.mCirclesCount; ++i) {
                Log.i((String)this.LOG_TAG, (String)("Radius " + i + " : " + (Integer)this.mAnim[i].getAnimatedValue()));
                canvas.drawCircle((float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredHeight() / 2), (float)((Integer)this.mAnim[i].getAnimatedValue()).intValue(), this.mPaint[i]);
            }
        } else {
            this.mAnimatePaint.setColor(((Integer)this.mColorAnim.getAnimatedValue()).intValue());
            for (i = 0; i < this.mCirclesCount; ++i) {
                Log.i((String)this.LOG_TAG, (String)("Radius " + i + " : " + (Integer)this.mAnim[i].getAnimatedValue()));
                canvas.drawCircle((float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredHeight() / 2), (float)((Integer)this.mAnim[i].getAnimatedValue()).intValue(), this.mAnimatePaint);
            }
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = MeasureUtils.getMeasurement(widthMeasureSpec, this.getDesiredWidth());
        int heightSize = MeasureUtils.getMeasurement(heightMeasureSpec, this.getDesiredHeight());
        this.setMeasuredDimension(widthSize + 10, heightSize + 10);
        this.setupAnimations();
    }

    private int getDesiredWidth() {
        return 2 * this.mMaxRadius + 100;
    }

    private int getDesiredHeight() {
        return 2 * this.mMaxRadius + 100;
    }

    public int getMinRadius() {
        return this.mMinRadius;
    }

    public void setMinRadius(int mMinRadius) {
        this.mMinRadius = mMinRadius;
        this.setupAnimations();
        this.invalidate();
    }

    public int getMaxRadius() {
        return this.mMaxRadius;
    }

    public void setMaxRadius(int mMaxRadius) {
        this.mMaxRadius = mMaxRadius;
        this.setupAnimations();
        this.invalidate();
    }

    public int getCirclesCount() {
        return this.mCirclesCount;
    }

    public void setCirclesCount(int mCirclesCount) {
        this.mCirclesCount = mCirclesCount;
        this.init();
        this.setupAnimations();
        this.invalidate();
    }

    public int getDuration() {
        return this.mDuration;
    }

    public void setDuration(int mDuration) {
        this.mDuration = mDuration;
        this.setupAnimations();
        this.invalidate();
    }
}

