package teamdapsr.loaders.lib.utils;

import android.view.View;

/**
 * Created by Devesh on 08-Jun-15.
 */
public class MeasureUtils
{
	/**
	 * Utility to return a view's standard measurement. Uses the
	 * supplied size when constraints are given. Attempts to
	 * hold to the desired size unless it conflicts with provided
	 * constraints.
	 *
	 * @param measureSpec Constraints imposed by the parent
	 * @param contentSize Desired size for the view
	 * @return The size the view should be.
	 */
	public static int getMeasurement(int measureSpec, int contentSize) {
		int specMode = View.MeasureSpec.getMode(measureSpec);
		int specSize = View.MeasureSpec.getSize(measureSpec);
		int resultSize = 0;
		switch (specMode) {
			case View.MeasureSpec.UNSPECIFIED:
				//Big as we want to be
				resultSize = contentSize;
				break;
			case View.MeasureSpec.AT_MOST:
				//Big as we want to be, up to the spec
				resultSize = Math.min(contentSize, specSize);
				break;
			case View.MeasureSpec.EXACTLY:
				//Must be the spec size
				resultSize = specSize;
				break;
		}

		return resultSize;
	}
}
