package teamdapsr.loaders.lib.utils;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;

/**
 * Created by deveshkhandelwal on 10/08/15.
 */
public class DeviceDimensionsHelper {
	// DeviceDimensionsHelper.getDisplayWidth(context) => (display width in pixels)
	public static int getDisplayWidth(Context context) {
		DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
		return displayMetrics.widthPixels;
	}

	// DeviceDimensionsHelper.getDisplayHeight(context) => (display height in pixels)
	public static int getDisplayHeight(Context context) {
		DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
		return displayMetrics.heightPixels;
	}

	// DeviceDimensionsHelper.convertDpToPixel(25f, context) => (25dp converted to pixels)
	public static float convertDpToPixel(float dp, Context context){
		Resources r = context.getResources();
		return TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dp, r.getDisplayMetrics());
	}

	// DeviceDimensionsHelper.convertPixelsToDp(25f, context) => (25px converted to dp)
	public static float convertPixelsToDp(float px, Context context){
		Resources r = context.getResources();
		DisplayMetrics metrics = r.getDisplayMetrics();
		float dp = px / (metrics.densityDpi / 160f);
		return dp;
	}
}
