/*
 * Decompiled with CFR 0.152.
 */
package team.yi.rsql.querydsl.util;

import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.yi.rsql.querydsl.util.DateUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0005J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u0005J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0005R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lteam/yi/rsql/querydsl/util/DateUtil;", "", "()V", "DATE_FORMATS", "", "", "Lkotlin/text/Regex;", "getDATE_FORMATS", "()Ljava/util/Map;", "formatters", "", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getFormatters", "()Ljava/util/List;", "regexOptions", "", "Lkotlin/text/RegexOption;", "determineDateFormat", "dateString", "parse", "Ljava/util/Date;", "dateFormat", "parseOffsetDateTime", "Ljava/time/OffsetDateTime;", "dateStr", "rsql-querydsl"})
public final class DateUtil {
    @NotNull
    public static final DateUtil INSTANCE = new DateUtil();
    @NotNull
    private static final Set<RegexOption> regexOptions = SetsKt.setOf((Object)RegexOption.IGNORE_CASE);
    @NotNull
    private static final Map<String, Regex> DATE_FORMATS;
    @NotNull
    private static final List<DateTimeFormatter> formatters;

    private DateUtil() {
    }

    @NotNull
    public final Map<String, Regex> getDATE_FORMATS() {
        return DATE_FORMATS;
    }

    @NotNull
    public final List<DateTimeFormatter> getFormatters() {
        return formatters;
    }

    @Nullable
    public final Date parse(@NotNull String dateString) {
        Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
        return this.parse(dateString, this.determineDateFormat(dateString));
    }

    @Nullable
    public final Date parse(@NotNull String dateString, @Nullable String dateFormat) {
        Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
        CharSequence charSequence = dateString;
        if (StringsKt.isBlank((CharSequence)charSequence)) {
            boolean bl = false;
            return null;
        }
        String dateStr = ((Object)StringsKt.trim((CharSequence)((String)charSequence))).toString();
        try {
            OffsetDateTime offsetDateTime = this.parseOffsetDateTime(dateStr);
            if (offsetDateTime == null) {
                CharSequence bl = dateFormat;
                if (bl == null || bl.length() == 0) {
                    return null;
                }
                CharSequence charSequence2 = dateFormat;
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl2 = false;
                    return null;
                }
                String format = ((Object)StringsKt.trim((CharSequence)((String)charSequence2))).toString();
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                sdf.setLenient(false);
                if (StringsKt.endsWith$default((CharSequence)dateStr, (char)'Z', (boolean)false, (int)2, null)) {
                    sdf.setTimeZone(TimeZone.getTimeZone("+00:00:00"));
                }
                return sdf.parse(dateStr);
            }
            return Date.from(offsetDateTime.toInstant());
        }
        catch (Exception exception) {
            OffsetDateTime offsetDateTime = this.parseOffsetDateTime(dateStr);
            if (offsetDateTime == null) {
                return null;
            }
            OffsetDateTime offsetDateTime2 = offsetDateTime;
            return Date.from(offsetDateTime2.toInstant());
        }
    }

    @Nullable
    public final String determineDateFormat(@NotNull String dateString) {
        Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(DATE_FORMATS), (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends Regex>, Boolean>(dateString){
            final /* synthetic */ String $dateString;
            {
                this.$dateString = $dateString;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<String, Regex> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.getValue().matches((CharSequence)this.$dateString);
            }
        })), (Function1)determineDateFormat.2.INSTANCE));
    }

    @Nullable
    public final OffsetDateTime parseOffsetDateTime(@NotNull String dateStr) {
        Intrinsics.checkNotNullParameter((Object)dateStr, (String)"dateStr");
        for (DateTimeFormatter formatter : formatters) {
            try {
                return OffsetDateTime.parse(dateStr, formatter);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"dd MMMM yyyy HH:mm:ss", (Object)new Regex("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"dd MMM yyyy HH:mm:ss", (Object)new Regex("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"yyyy/MM/dd HH:mm:ss", (Object)new Regex("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"MM/dd/yyyy HH:mm:ss", (Object)new Regex("^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"yyyy-MM-dd'T'HH:mm:ss", (Object)new Regex("^\\d{4}-\\d{1,2}-\\d{1,2}'?T'?\\d{1,2}:\\d{1,2}:\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"yyyy-MM-dd'T'HH:mm:ss'Z'", (Object)new Regex("^\\d{4}-\\d{1,2}-\\d{1,2}'?T'?\\d{1,2}:\\d{1,2}:\\d{1,2}'?Z'?$", regexOptions)), TuplesKt.to((Object)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", (Object)new Regex("^\\d{4}-\\d{1,2}-\\d{1,2}'?T'?\\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{3}'?Z'?$", regexOptions)), TuplesKt.to((Object)"yyyy-MM-dd'T'HH:mm:ss.SSS", (Object)new Regex("^\\d{4}-\\d{1,2}-\\d{1,2}'?T'?\\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{3}$", regexOptions)), TuplesKt.to((Object)"yyyy-MM-dd HH:mm:ss.SSS", (Object)new Regex("^\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{3}$", regexOptions)), TuplesKt.to((Object)"yyyy-MM-dd HH:mm:ss", (Object)new Regex("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"dd-MM-yyyy HH:mm:ss", (Object)new Regex("^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{1,2}:\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"yyyyMMdd HHmmss", (Object)new Regex("^\\d{8}\\s\\d{6}$", regexOptions)), TuplesKt.to((Object)"dd MMMM yyyy HH:mm", (Object)new Regex("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"dd MMM yyyy HH:mm", (Object)new Regex("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"yyyy/MM/dd HH:mm", (Object)new Regex("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"MM/dd/yyyy HH:mm", (Object)new Regex("^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"yyyy-MM-dd HH:mm", (Object)new Regex("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"yyyy.MM.dd HH:mm", (Object)new Regex("^\\d{4}.\\d{1,2}.\\d{1,2}\\s\\d{1,2}:\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"dd-MM-yyyy HH:mm", (Object)new Regex("^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"yyyyMMdd HHmm", (Object)new Regex("^\\d{8}\\s\\d{4}$", regexOptions)), TuplesKt.to((Object)"dd MMMM yyyy", (Object)new Regex("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}$", regexOptions)), TuplesKt.to((Object)"dd MMM yyyy", (Object)new Regex("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}$", regexOptions)), TuplesKt.to((Object)"yyyy/MM/dd", (Object)new Regex("^\\d{4}/\\d{1,2}/\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"MM/dd/yyyy", (Object)new Regex("^\\d{1,2}/\\d{1,2}/\\d{4}$", regexOptions)), TuplesKt.to((Object)"yyyy.MM.dd", (Object)new Regex("^\\d{4}\\.\\d{1,2}\\.\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"yyyy-MM-dd", (Object)new Regex("^\\d{4}-\\d{1,2}-\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"dd.MM.yyyy", (Object)new Regex("^\\d{1,2}\\.\\d{1,2}\\.\\d{4}$", regexOptions)), TuplesKt.to((Object)"dd-MM-yyyy", (Object)new Regex("^\\d{1,2}-\\d{1,2}-\\d{4}$", regexOptions)), TuplesKt.to((Object)"yyyy", (Object)new Regex("^\\d{4}$", regexOptions)), TuplesKt.to((Object)"yy-MM-dd HH:mm", (Object)new Regex("^\\d{2}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"yy.MM.dd", (Object)new Regex("^\\d{2}\\.\\d{1,2}\\.\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"yy-MM-dd", (Object)new Regex("^\\d{2}-\\d{1,2}-\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"yy-MM", (Object)new Regex("^\\d{2}-\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"yyyy.MM", (Object)new Regex("^\\d{4}\\.\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"yyyy-MM", (Object)new Regex("^\\d{4}-\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"MM.yyyy", (Object)new Regex("^\\d{1,2}\\.\\d{4}$", regexOptions)), TuplesKt.to((Object)"MM-yyyy", (Object)new Regex("^\\d{1,2}-\\d{4}$", regexOptions)), TuplesKt.to((Object)"HH:mm:ss.SSS'Z'", (Object)new Regex("^\\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{3}'?Z'?$", regexOptions)), TuplesKt.to((Object)"HH:mm:ss'Z'", (Object)new Regex("^\\d{1,2}:\\d{1,2}:\\d{1,2}'?Z'?$", regexOptions)), TuplesKt.to((Object)"HH:mm:ss.SSS", (Object)new Regex("^\\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{3}$", regexOptions)), TuplesKt.to((Object)"HH:mm:ss", (Object)new Regex("^\\d{1,2}:\\d{1,2}:\\d{1,2}$", regexOptions)), TuplesKt.to((Object)"HH:mm", (Object)new Regex("^\\d{1,2}:\\d{1,2}$", regexOptions))};
        DATE_FORMATS = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new DateTimeFormatter[]{DateTimeFormatter.ISO_LOCAL_DATE_TIME, DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ISO_INSTANT, DateTimeFormatter.ISO_OFFSET_DATE_TIME, DateTimeFormatter.ISO_ZONED_DATE_TIME, DateTimeFormatter.ISO_LOCAL_DATE, DateTimeFormatter.ISO_DATE, DateTimeFormatter.ISO_OFFSET_DATE, DateTimeFormatter.ISO_LOCAL_TIME, DateTimeFormatter.ISO_TIME, DateTimeFormatter.ISO_OFFSET_TIME, DateTimeFormatter.ISO_ORDINAL_DATE, DateTimeFormatter.ISO_WEEK_DATE, DateTimeFormatter.BASIC_ISO_DATE, DateTimeFormatter.RFC_1123_DATE_TIME};
        formatters = CollectionsKt.listOf((Object[])objectArray);
    }
}

