/*
 * Decompiled with CFR 0.152.
 */
package com.razz.eva.uow;

import com.razz.eva.domain.Model;
import com.razz.eva.domain.ModelEvent;
import com.razz.eva.domain.ModelId;
import com.razz.eva.domain.Version;
import com.razz.eva.uow.Add;
import com.razz.eva.uow.Change;
import com.razz.eva.uow.ChangeKt;
import com.razz.eva.uow.ModelPersisting;
import com.razz.eva.uow.Noop;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000*\u0014\b\u0000\u0010\u0001*\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002*\u0012\b\u0001\u0010\u0004*\f\u0012\u0004\u0012\u0002H\u0001\u0012\u0002\b\u00030\u0005*\u000e\b\u0002\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00010\u00072\u00020\bB\u001b\u0012\u0006\u0010\t\u001a\u00028\u0001\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0013\u001a\u00028\u0001H\u00c2\u0003\u00a2\u0006\u0002\u0010\u0014J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00020\u000bH\u00c6\u0003J:\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00002\b\b\u0002\u0010\t\u001a\u00028\u00012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00020\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0016\u0010$\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005J\t\u0010%\u001a\u00020&H\u00d6\u0001J\u0006\u0010'\u001a\u00020\bR \u0010\r\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\t\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lcom/razz/eva/uow/Update;", "MID", "Lcom/razz/eva/domain/ModelId;", "", "M", "Lcom/razz/eva/domain/Model;", "E", "Lcom/razz/eva/domain/ModelEvent;", "Lcom/razz/eva/uow/Change;", "model", "modelEvents", "", "(Lcom/razz/eva/domain/Model;Ljava/util/List;)V", "id", "getId", "()Lcom/razz/eva/domain/ModelId;", "Lcom/razz/eva/domain/Model;", "getModelEvents", "()Ljava/util/List;", "component1", "()Lcom/razz/eva/domain/Model;", "component2", "copy", "(Lcom/razz/eva/domain/Model;Ljava/util/List;)Lcom/razz/eva/uow/Update;", "equals", "", "other", "", "hashCode", "", "merge", "succ", "persist", "", "persisting", "Lcom/razz/eva/uow/ModelPersisting;", "sameVersion", "toString", "", "unwrap", "eva-uow"})
public final class Update<MID extends ModelId<? extends Comparable<?>>, M extends Model<MID, ?>, E extends ModelEvent<MID>>
implements Change {
    @NotNull
    private final M model;
    @NotNull
    private final List<E> modelEvents;
    @NotNull
    private final ModelId<? extends Comparable<?>> id;

    public Update(@NotNull M model2, @NotNull List<? extends E> modelEvents) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(modelEvents, (String)"modelEvents");
        this.model = model2;
        this.modelEvents = modelEvents;
        this.id = this.model.id();
    }

    @NotNull
    public List<E> getModelEvents() {
        return this.modelEvents;
    }

    @Override
    @NotNull
    public ModelId<? extends Comparable<?>> getId() {
        return this.id;
    }

    @Override
    public void persist(@NotNull ModelPersisting persisting) {
        Intrinsics.checkNotNullParameter((Object)persisting, (String)"persisting");
        if (!this.model.isDirty()) {
            boolean bl = false;
            String string = "Attempted to register " + (this.model.isNew() ? "new" : "unchanged") + " model [" + this.model.id() + "] as changed";
            throw new IllegalArgumentException(string.toString());
        }
        persisting.update(this.model);
    }

    @NotNull
    public final Change unwrap() {
        return this.model.isNew() ? (Change)new Add(this.model, this.getModelEvents()) : (Change)new Update<MID, M, E>(this.model, this.getModelEvents());
    }

    public final boolean sameVersion(@NotNull Model<?, ?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Intrinsics.areEqual((Object)this.model.id(), (Object)other.id()) && Version.equals-impl0((long)this.model.version-dAuNB9I(), (long)other.version-dAuNB9I());
    }

    @Override
    @Nullable
    public Change merge(@NotNull Change succ) {
        Change change;
        Intrinsics.checkNotNullParameter((Object)succ, (String)"succ");
        Change change2 = succ;
        if (change2 instanceof Add) {
            change = null;
        } else if (change2 instanceof Update) {
            change = !((Update)succ).sameVersion((Model<?, ?>)this.model) ? null : (ChangeKt.access$isSuccessorOf(succ.getModelEvents(), this.getModelEvents()) ? (Update)succ : null);
        } else if (change2 instanceof Noop) {
            change = this;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return change;
    }

    private final M component1() {
        return this.model;
    }

    @NotNull
    public final List<E> component2() {
        return this.modelEvents;
    }

    @NotNull
    public final Update<MID, M, E> copy(@NotNull M model2, @NotNull List<? extends E> modelEvents) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(modelEvents, (String)"modelEvents");
        return new Update<MID, M, E>(model2, modelEvents);
    }

    public static /* synthetic */ Update copy$default(Update update2, Model object, List list, int n, Object object2) {
        if ((n & 1) != 0) {
            object = update2.model;
        }
        if ((n & 2) != 0) {
            list = update2.modelEvents;
        }
        return update2.copy(object, list);
    }

    @NotNull
    public String toString() {
        return "Update(model=" + this.model + ", modelEvents=" + this.modelEvents + ")";
    }

    public int hashCode() {
        int result2 = this.model.hashCode();
        result2 = result2 * 31 + ((Object)this.modelEvents).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Update)) {
            return false;
        }
        Update update2 = (Update)other;
        if (!Intrinsics.areEqual(this.model, update2.model)) {
            return false;
        }
        return Intrinsics.areEqual(this.modelEvents, update2.modelEvents);
    }
}

