/*
 * Decompiled with CFR 0.152.
 */
package com.razz.eva.test.db;

import com.razz.eva.test.db.DatabaseContainer;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.PostgreSQLContainer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\u00030\u0003J\u0013\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0003J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0003J\u0010\u0010\u0013\u001a\n \f*\u0004\u0018\u00010\u00140\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/razz/eva/test/db/DatabaseContainerHelper;", "Ljava/io/Closeable;", "dbPrefix", "", "db", "Lcom/razz/eva/test/db/DatabaseContainer;", "<init>", "(Ljava/lang/String;Lcom/razz/eva/test/db/DatabaseContainer;)V", "logger", "Lmu/KLogger;", "dbName", "dbHost", "kotlin.jvm.PlatformType", "dbPort", "", "()Ljava/lang/Integer;", "jdbcUrl", "username", "password", "localConn", "Ljava/sql/Connection;", "createDb", "", "createSchemas", "", "createPartman", "", "close", "Companion", "eva-test"})
public final class DatabaseContainerHelper
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseContainer db;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final String dbName;
    @NotNull
    private static final Regex DB_NAME_FORMAT = new Regex("[a-z0-9_]+");

    private DatabaseContainerHelper(String dbPrefix, DatabaseContainer db) {
        this.db = db;
        this.logger = KotlinLogging.INSTANCE.logger(DatabaseContainerHelper::logger$lambda$0);
        ZonedDateTime now = ZonedDateTime.now();
        Duration sinceMonth = Duration.between(now.truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1), now);
        long seconds = sinceMonth.toSeconds();
        Object object = System.getenv("RAZZ_TEST_DB_CONTAINER_DB_SUFFIX");
        if (object == null) {
            object = seconds / (long)60 + "_" + seconds % (long)60;
        }
        String sortableSuffix = object;
        this.dbName = dbPrefix + "_" + sortableSuffix;
    }

    @NotNull
    public final String dbName() {
        return this.dbName;
    }

    public final String dbHost() {
        return this.db.getPgContainer().getHost();
    }

    public final Integer dbPort() {
        DatabaseContainer.PostgreDockerContainer postgreDockerContainer = this.db.getPgContainer();
        Integer n = PostgreSQLContainer.POSTGRESQL_PORT;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"POSTGRESQL_PORT");
        return postgreDockerContainer.getMappedPort(((Number)n).intValue());
    }

    @NotNull
    public final String jdbcUrl() {
        return this.jdbcUrl(this.dbName);
    }

    private final String jdbcUrl(String dbName) {
        return this.db.jdbcUrl(dbName);
    }

    @NotNull
    public final String username() {
        String string = this.db.getPgContainer().getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUsername(...)");
        return string;
    }

    @NotNull
    public final String password() {
        String string = this.db.getPgContainer().getPassword();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPassword(...)");
        return string;
    }

    private final Connection localConn() {
        return this.db.localPool(this.dbName, 4).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object createDb() {
        Object object;
        try {
            Boolean bl;
            object = this.db.getManagementPool().getConnection();
            Throwable throwable = null;
            try {
                boolean bl2;
                Connection conn = (Connection)object;
                boolean bl3 = false;
                AutoCloseable autoCloseable = conn.createStatement();
                Throwable throwable2 = null;
                try {
                    Statement stmt = (Statement)autoCloseable;
                    boolean bl4 = false;
                    bl2 = stmt.execute(StringsKt.trimIndent((String)("\n                        CREATE DATABASE " + this.dbName + ";\n                    ")));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
                bl = bl2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            object = bl;
        }
        catch (SQLException e) {
            if (Intrinsics.areEqual((Object)e.getSQLState(), (Object)"42P04")) {
                this.logger.debug((Throwable)e, DatabaseContainerHelper::createDb$lambda$3);
            } else {
                this.logger.error((Throwable)e, DatabaseContainerHelper::createDb$lambda$4);
            }
            object = Unit.INSTANCE;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createSchemas(boolean createPartman) {
        String statement = (createPartman ? "CREATE SCHEMA IF NOT EXISTS partman;\nCREATE EXTENSION IF NOT EXISTS pg_partman WITH SCHEMA partman;" : "") + "CREATE EXTENSION IF NOT EXISTS btree_gist;\nCREATE EXTENSION IF NOT EXISTS intarray;\nCREATE EXTENSION IF NOT EXISTS timescaledb;\nCREATE EXTENSION IF NOT EXISTS pg_trgm;\nCREATE EXTENSION IF NOT EXISTS unaccent;\nCREATE EXTENSION IF NOT EXISTS hstore;\nCREATE EXTENSION IF NOT EXISTS fuzzystrmatch;";
        if (!(!StringsKt.isBlank((CharSequence)statement))) {
            throw new IllegalStateException("Check failed.");
        }
        AutoCloseable autoCloseable = this.localConn();
        Throwable throwable = null;
        try {
            boolean bl;
            Connection conn = (Connection)autoCloseable;
            boolean bl2 = false;
            AutoCloseable autoCloseable2 = conn.createStatement();
            Throwable throwable2 = null;
            try {
                Statement stmt = (Statement)autoCloseable2;
                boolean bl3 = false;
                bl = stmt.execute(statement);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            boolean bl4 = bl;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void createSchemas$default(DatabaseContainerHelper databaseContainerHelper, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        databaseContainerHelper.createSchemas(bl);
    }

    @Override
    public void close() {
        this.db.getPgContainer().close();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object createDb$lambda$3() {
        return "42P04";
    }

    private static final Object createDb$lambda$4() {
        return "Most likely pg_database_datname_index";
    }

    public /* synthetic */ DatabaseContainerHelper(String dbPrefix, DatabaseContainer db, DefaultConstructorMarker $constructor_marker) {
        this(dbPrefix, db);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/razz/eva/test/db/DatabaseContainerHelper$Companion;", "", "<init>", "()V", "DB_NAME_FORMAT", "Lkotlin/text/Regex;", "create", "Lcom/razz/eva/test/db/DatabaseContainerHelper;", "dbName", "", "databaseContainer", "Lcom/razz/eva/test/db/DatabaseContainer;", "eva-test"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DatabaseContainerHelper create(@NotNull String dbName, @NotNull DatabaseContainer databaseContainer) {
            DatabaseContainerHelper databaseContainerHelper;
            Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
            Intrinsics.checkNotNullParameter((Object)databaseContainer, (String)"databaseContainer");
            if (!DB_NAME_FORMAT.matches((CharSequence)dbName)) {
                boolean $i$a$-require-DatabaseContainerHelper$Companion$create$22 = false;
                String $i$a$-require-DatabaseContainerHelper$Companion$create$22 = "Wrong DB name: " + dbName + ". DB name should have only lowercase chars and numbers.";
                throw new IllegalArgumentException($i$a$-require-DatabaseContainerHelper$Companion$create$22.toString());
            }
            DatabaseContainerHelper $this$create_u24lambda_u241 = databaseContainerHelper = new DatabaseContainerHelper(dbName, databaseContainer, null);
            boolean bl = false;
            $this$create_u24lambda_u241.createDb();
            DatabaseContainerHelper.createSchemas$default($this$create_u24lambda_u241, false, 1, null);
            return databaseContainerHelper;
        }

        public static /* synthetic */ DatabaseContainerHelper create$default(Companion companion, String string, DatabaseContainer databaseContainer, int n, Object object) {
            if ((n & 2) != 0) {
                databaseContainer = DatabaseContainer.Companion.getBASIC();
            }
            return companion.create(string, databaseContainer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

