/*
 * Decompiled with CFR 0.152.
 */
package com.razz.eva.test.db;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.HostConfig;
import com.razz.eva.test.db.DockerImageName;
import com.razz.eva.test.db.Startable;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.PostgreSQLContainer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u0003J\u0013\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\n \f*\u0004\u0018\u00010\u000f0\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0003J\u0015\u0010\u0014\u001a\n \f*\u0004\u0018\u00010\u00150\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/razz/eva/test/db/DatabaseContainerHelper;", "Ljava/io/Closeable;", "dbPrefix", "", "db", "Lcom/razz/eva/test/db/DatabaseContainerHelper$PostgreDockerContainer;", "<init>", "(Ljava/lang/String;Lcom/razz/eva/test/db/DatabaseContainerHelper$PostgreDockerContainer;)V", "logger", "Lmu/KLogger;", "dbName", "dbHost", "kotlin.jvm.PlatformType", "()Ljava/lang/String;", "dbPort", "", "()Ljava/lang/Integer;", "jdbcUrl", "username", "password", "localConn", "Ljava/sql/Connection;", "()Ljava/sql/Connection;", "createDb", "", "createSchemas", "", "createPartman", "", "close", "PostgreDockerContainer", "Companion", "eva-test"})
@SourceDebugExtension(value={"SMAP\nDatabaseContainerHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseContainerHelper.kt\ncom/razz/eva/test/db/DatabaseContainerHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1#2:196\n*E\n"})
public final class DatabaseContainerHelper
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PostgreDockerContainer db;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final String dbName;
    @NotNull
    private static final Regex DB_NAME_FORMAT = new Regex("[a-z0-9_]+");
    private static final long memoryInBytes = 0x80000000L;
    private static final long cpuCount = (long)Math.ceil((double)Runtime.getRuntime().availableProcessors() / 4.0);
    private static final PostgreDockerContainer pgContainer;
    @NotNull
    private static final HikariDataSource managementPool;
    @NotNull
    private static final Map<String, HikariDataSource> localPools;

    private DatabaseContainerHelper(String dbPrefix, PostgreDockerContainer db) {
        this.db = db;
        this.logger = KotlinLogging.INSTANCE.logger(DatabaseContainerHelper::logger$lambda$0);
        ZonedDateTime now = ZonedDateTime.now();
        Duration sinceMonth = Duration.between(now.truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1), now);
        long seconds = sinceMonth.toSeconds();
        Object object = System.getenv("RAZZ_TEST_DB_CONTAINER_DB_SUFFIX");
        if (object == null) {
            object = seconds / (long)60 + "_" + seconds % (long)60;
        }
        String sortableSuffix = object;
        this.dbName = dbPrefix + "_" + sortableSuffix;
    }

    @NotNull
    public final String dbName() {
        return this.dbName;
    }

    public final String dbHost() {
        return this.db.getHost();
    }

    public final Integer dbPort() {
        Integer n = PostgreSQLContainer.POSTGRESQL_PORT;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"POSTGRESQL_PORT");
        return this.db.getMappedPort(((Number)n).intValue());
    }

    @NotNull
    public final String jdbcUrl() {
        return this.jdbcUrl(this.dbName);
    }

    @NotNull
    public final String jdbcUrl(@NotNull String dbName) {
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        return DatabaseContainerHelper.Companion.jdbcUrl(dbName, this.db);
    }

    @NotNull
    public final String username() {
        String string = this.db.getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUsername(...)");
        return string;
    }

    @NotNull
    public final String password() {
        String string = this.db.getPassword();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPassword(...)");
        return string;
    }

    private final Connection localConn() {
        return Companion.localPool(this.dbName, 4).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object createDb() {
        Object object;
        try {
            Boolean bl;
            object = managementPool.getConnection();
            Throwable throwable = null;
            try {
                boolean bl2;
                Connection conn = (Connection)object;
                boolean bl3 = false;
                AutoCloseable autoCloseable = conn.createStatement();
                Throwable throwable2 = null;
                try {
                    Statement stmt = (Statement)autoCloseable;
                    boolean bl4 = false;
                    bl2 = stmt.execute(StringsKt.trimIndent((String)("\n                        CREATE DATABASE " + this.dbName + ";\n                    ")));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
                bl = bl2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            object = bl;
        }
        catch (SQLException e) {
            if (Intrinsics.areEqual((Object)e.getSQLState(), (Object)"42P04")) {
                this.logger.debug((Throwable)e, DatabaseContainerHelper::createDb$lambda$3);
            } else {
                this.logger.error((Throwable)e, DatabaseContainerHelper::createDb$lambda$4);
            }
            object = Unit.INSTANCE;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createSchemas(boolean createPartman) {
        String statement = (createPartman ? "CREATE SCHEMA IF NOT EXISTS partman;\nCREATE EXTENSION IF NOT EXISTS pg_partman WITH SCHEMA partman;" : "") + "CREATE EXTENSION IF NOT EXISTS btree_gist;\nCREATE EXTENSION IF NOT EXISTS intarray;\nCREATE EXTENSION IF NOT EXISTS timescaledb;\nCREATE EXTENSION IF NOT EXISTS pg_trgm;\nCREATE EXTENSION IF NOT EXISTS unaccent;\nCREATE EXTENSION IF NOT EXISTS hstore;\nCREATE EXTENSION IF NOT EXISTS fuzzystrmatch;";
        if (!(!StringsKt.isBlank((CharSequence)statement))) {
            throw new IllegalStateException("Check failed.");
        }
        AutoCloseable autoCloseable = this.localConn();
        Throwable throwable = null;
        try {
            boolean bl;
            Connection conn = (Connection)autoCloseable;
            boolean bl2 = false;
            AutoCloseable autoCloseable2 = conn.createStatement();
            Throwable throwable2 = null;
            try {
                Statement stmt = (Statement)autoCloseable2;
                boolean bl3 = false;
                bl = stmt.execute(statement);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            boolean bl4 = bl;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void createSchemas$default(DatabaseContainerHelper databaseContainerHelper, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        databaseContainerHelper.createSchemas(bl);
    }

    @Override
    public void close() {
        this.db.close();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object createDb$lambda$3() {
        return "42P04";
    }

    private static final Object createDb$lambda$4() {
        return "Most likely pg_database_datname_index";
    }

    private static final void pgContainer$lambda$7(CreateContainerCmd cmd) {
        block0: {
            HostConfig hostConfig;
            HostConfig hostConfig2 = cmd.getHostConfig();
            if (hostConfig2 == null || (hostConfig = hostConfig2.withMemory(Long.valueOf(0x80000000L))) == null) break block0;
            hostConfig.withCpuCount(Long.valueOf(cpuCount));
        }
    }

    public /* synthetic */ DatabaseContainerHelper(String dbPrefix, PostgreDockerContainer db, DefaultConstructorMarker $constructor_marker) {
        this(dbPrefix, db);
    }

    static {
        GenericContainer genericContainer = ((PostgreDockerContainer)((PostgreDockerContainer)((PostgreDockerContainer)((PostgreDockerContainer)((PostgreDockerContainer)((PostgreDockerContainer)new PostgreDockerContainer(DockerImageName.PostgrePartmanImage16.INSTANCE).withDatabaseName("test")).withUsername("test")).withPassword("test")).withCommand("-c fsync=off -c full_page_writes=off -c synchronous_commit=off -c wal_level=minimal -c checkpoint_timeout=1d -c wal_init_zero=off -c max_wal_senders=0 -c max_connections=200 -c shared_buffers=512MB -c wal_buffers=16MB -c effective_cache_size=1536MB -c effective_io_concurrency=200 -c maintenance_work_mem=128MB -c work_mem=1310kB -c max_worker_processes=2 -c max_parallel_workers_per_gather=1 -c max_parallel_workers=2 -c max_parallel_maintenance_workers=1")).withTmpFs(MapsKt.mapOf((Pair)TuplesKt.to((Object)"/var/lib/postgresql/data", (Object)"rw")))).withReuse(true)).withCreateContainerCmdModifier(DatabaseContainerHelper::pgContainer$lambda$7);
        PostgreDockerContainer $this$pgContainer_u24lambda_u248 = (PostgreDockerContainer)genericContainer;
        boolean bl = false;
        $this$pgContainer_u24lambda_u248.start();
        pgContainer = (PostgreDockerContainer)genericContainer;
        HikariConfig $this$managementPool_u24lambda_u249 = new HikariConfig();
        boolean bl2 = false;
        $this$managementPool_u24lambda_u249.setJdbcUrl(pgContainer.getJdbcUrl());
        $this$managementPool_u24lambda_u249.setUsername("test");
        $this$managementPool_u24lambda_u249.setPassword("test");
        $this$managementPool_u24lambda_u249.setMaximumPoolSize(2);
        managementPool = new HikariDataSource($this$managementPool_u24lambda_u249);
        localPools = new LinkedHashMap();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u0016\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/razz/eva/test/db/DatabaseContainerHelper$Companion;", "", "<init>", "()V", "DB_NAME_FORMAT", "Lkotlin/text/Regex;", "memoryInBytes", "", "cpuCount", "pgContainer", "Lcom/razz/eva/test/db/DatabaseContainerHelper$PostgreDockerContainer;", "kotlin.jvm.PlatformType", "Lcom/razz/eva/test/db/DatabaseContainerHelper$PostgreDockerContainer;", "managementPool", "Lcom/zaxxer/hikari/HikariDataSource;", "localPools", "", "", "jdbcUrl", "dbName", "db", "localPool", "size", "", "create", "Lcom/razz/eva/test/db/DatabaseContainerHelper;", "eva-test"})
    @SourceDebugExtension(value={"SMAP\nDatabaseContainerHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseContainerHelper.kt\ncom/razz/eva/test/db/DatabaseContainerHelper$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,195:1\n381#2,7:196\n*S KotlinDebug\n*F\n+ 1 DatabaseContainerHelper.kt\ncom/razz/eva/test/db/DatabaseContainerHelper$Companion\n*L\n165#1:196,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String jdbcUrl(String dbName, PostgreDockerContainer db) {
            String string = db.getHost();
            Integer n = PostgreSQLContainer.POSTGRESQL_PORT;
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"POSTGRESQL_PORT");
            return "jdbc:postgresql://" + string + ":" + db.getMappedPort(((Number)n).intValue()) + "/" + dbName + db.getAdditionalUrlParams();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final HikariDataSource localPool(@NotNull String dbName, int size) {
            HikariDataSource hikariDataSource;
            Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
            Companion companion = this;
            synchronized (companion) {
                Object object;
                boolean bl = false;
                Map $this$getOrPut$iv = localPools;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(dbName);
                if (value$iv == null) {
                    boolean bl2 = false;
                    HikariConfig $this$localPool_u24lambda_u242_u24lambda_u241_u24lambda_u240 = new HikariConfig();
                    boolean bl3 = false;
                    PostgreDockerContainer postgreDockerContainer = pgContainer;
                    Intrinsics.checkNotNullExpressionValue((Object)postgreDockerContainer, (String)"access$getPgContainer$cp(...)");
                    $this$localPool_u24lambda_u242_u24lambda_u241_u24lambda_u240.setJdbcUrl(Companion.jdbcUrl(dbName, postgreDockerContainer));
                    $this$localPool_u24lambda_u242_u24lambda_u241_u24lambda_u240.setUsername("test");
                    $this$localPool_u24lambda_u242_u24lambda_u241_u24lambda_u240.setPassword("test");
                    $this$localPool_u24lambda_u242_u24lambda_u241_u24lambda_u240.setMaximumPoolSize(size);
                    $this$localPool_u24lambda_u242_u24lambda_u241_u24lambda_u240.setInitializationFailTimeout(-1L);
                    HikariDataSource answer$iv = new HikariDataSource($this$localPool_u24lambda_u242_u24lambda_u241_u24lambda_u240);
                    $this$getOrPut$iv.put(dbName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                hikariDataSource = (HikariDataSource)object;
            }
            return hikariDataSource;
        }

        @NotNull
        public final DatabaseContainerHelper create(@NotNull String dbName) {
            DatabaseContainerHelper databaseContainerHelper;
            Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
            if (!DB_NAME_FORMAT.matches((CharSequence)dbName)) {
                boolean $i$a$-require-DatabaseContainerHelper$Companion$create$22 = false;
                String $i$a$-require-DatabaseContainerHelper$Companion$create$22 = "Wrong DB name: " + dbName + ". DB name should have only lowercase chars and numbers.";
                throw new IllegalArgumentException($i$a$-require-DatabaseContainerHelper$Companion$create$22.toString());
            }
            PostgreDockerContainer postgreDockerContainer = pgContainer;
            Intrinsics.checkNotNullExpressionValue((Object)postgreDockerContainer, (String)"access$getPgContainer$cp(...)");
            DatabaseContainerHelper $this$create_u24lambda_u244 = databaseContainerHelper = new DatabaseContainerHelper(dbName, postgreDockerContainer, null);
            boolean bl = false;
            $this$create_u24lambda_u244.createDb();
            DatabaseContainerHelper.createSchemas$default($this$create_u24lambda_u244, false, 1, null);
            return databaseContainerHelper;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/razz/eva/test/db/DatabaseContainerHelper$PostgreDockerContainer;", "Lorg/testcontainers/containers/PostgreSQLContainer;", "Lcom/razz/eva/test/db/Startable;", "imageName", "Lcom/razz/eva/test/db/DockerImageName;", "<init>", "(Lcom/razz/eva/test/db/DockerImageName;)V", "additionalUrlParams", "", "getAdditionalUrlParams", "()Ljava/lang/String;", "eva-test"})
    private static final class PostgreDockerContainer
    extends PostgreSQLContainer<PostgreDockerContainer>
    implements Startable {
        @NotNull
        private final String additionalUrlParams;

        public PostgreDockerContainer(@NotNull DockerImageName imageName) {
            Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
            super(imageName.toTestcontainers());
            String string = this.constructUrlParameters("?", "&");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructUrlParameters(...)");
            this.additionalUrlParams = string;
        }

        @NotNull
        public final String getAdditionalUrlParams() {
            return this.additionalUrlParams;
        }
    }
}

