/*
 * Decompiled with CFR 0.152.
 */
package com.razz.eva.test.repository;

import com.razz.eva.migrations.DbSchema;
import com.razz.eva.migrations.Migration;
import com.razz.eva.persistence.ConnectionProvider;
import com.razz.eva.persistence.TransactionManager;
import com.razz.eva.persistence.config.ExecutorType;
import com.razz.eva.persistence.executor.QueryExecutor;
import com.razz.eva.persistence.jdbc.DataSourceConnectionProvider;
import com.razz.eva.persistence.jdbc.JdbcTransactionManager;
import com.razz.eva.persistence.jdbc.executor.JdbcQueryExecutor;
import com.razz.eva.persistence.vertx.PgPoolConnectionProvider;
import com.razz.eva.persistence.vertx.VertxTransactionManager;
import com.razz.eva.persistence.vertx.executor.VertxQueryExecutor;
import com.razz.eva.test.db.DatabaseContainer;
import com.razz.eva.test.db.DatabaseContainerHelper;
import com.zaxxer.hikari.HikariDataSource;
import io.opentelemetry.api.OpenTelemetry;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.conf.ParamType;
import org.jooq.conf.Settings;
import org.jooq.impl.DSL;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0001,BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\"\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\u0004\u0012\u00020\u001d0#H\u0002J \u0010$\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\u0004\u0012\u00020\u001d0#2\u0006\u0010%\u001a\u00020\u0003H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020\u0003H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/razz/eva/test/repository/RepositoryHelper;", "", "migrationPath", "", "additionalMigrationPaths", "", "createPartman", "", "trimmedPackagePrefix", "schema", "Lcom/razz/eva/migrations/DbSchema;", "databaseContainer", "Lcom/razz/eva/test/db/DatabaseContainer;", "<init>", "(Ljava/lang/String;Ljava/util/List;ZLjava/lang/String;Lcom/razz/eva/migrations/DbSchema;Lcom/razz/eva/test/db/DatabaseContainer;)V", "hikariPoolSize", "", "getHikariPoolSize", "()I", "dslContext", "Lorg/jooq/DSLContext;", "Lorg/jetbrains/annotations/NotNull;", "getDslContext", "()Lorg/jooq/DSLContext;", "txnManager", "Lcom/razz/eva/persistence/TransactionManager;", "getTxnManager", "()Lcom/razz/eva/persistence/TransactionManager;", "queryExecutor", "Lcom/razz/eva/persistence/executor/QueryExecutor;", "getQueryExecutor", "()Lcom/razz/eva/persistence/executor/QueryExecutor;", "db", "Lcom/razz/eva/test/db/DatabaseContainerHelper;", "jdbcEngine", "Lkotlin/Pair;", "vertxEngine", "dbName", "vertxPool", "Lio/vertx/sqlclient/Pool;", "flywayProvider", "Lorg/flywaydb/core/Flyway;", "migration", "Lcom/razz/eva/migrations/Migration;", "Companion", "eva-test"})
@SourceDebugExtension(value={"SMAP\nRepositoryHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryHelper.kt\ncom/razz/eva/test/repository/RepositoryHelper\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,111:1\n37#2:112\n36#2,3:113\n*S KotlinDebug\n*F\n+ 1 RepositoryHelper.kt\ncom/razz/eva/test/repository/RepositoryHelper\n*L\n107#1:112\n107#1:113,3\n*E\n"})
public class RepositoryHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseContainer databaseContainer;
    private final int hikariPoolSize;
    @NotNull
    private final DSLContext dslContext;
    @NotNull
    private final TransactionManager<?> txnManager;
    @NotNull
    private final QueryExecutor queryExecutor;
    @NotNull
    private final DatabaseContainerHelper db;

    public RepositoryHelper(@NotNull String migrationPath, @NotNull List<String> additionalMigrationPaths, boolean createPartman, @NotNull String trimmedPackagePrefix, @NotNull DbSchema schema, @NotNull DatabaseContainer databaseContainer) {
        Intrinsics.checkNotNullParameter((Object)migrationPath, (String)"migrationPath");
        Intrinsics.checkNotNullParameter(additionalMigrationPaths, (String)"additionalMigrationPaths");
        Intrinsics.checkNotNullParameter((Object)trimmedPackagePrefix, (String)"trimmedPackagePrefix");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)databaseContainer, (String)"databaseContainer");
        this.databaseContainer = databaseContainer;
        this.hikariPoolSize = 4;
        DSLContext dSLContext = DSL.using((SQLDialect)SQLDialect.POSTGRES, (Settings)new Settings().withRenderNamedParamPrefix("$").withParamType(ParamType.NAMED));
        Intrinsics.checkNotNullExpressionValue((Object)dSLContext, (String)"using(...)");
        this.dslContext = dSLContext;
        this.db = DatabaseContainerHelper.Companion.create(StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)migrationPath, (String)trimmedPackagePrefix, (String)"", (boolean)false, (int)4, null), (String)"/db", (String)"", (boolean)false, (int)4, null), (String)"/", (String)"", (boolean)false, (int)4, null) + "_repo_test", this.databaseContainer);
        Migration modelsMigration = new Migration(migrationPath, schema, additionalMigrationPaths);
        this.db.createSchemas(createPartman);
        this.flywayProvider(this.db.dbName(), modelsMigration).migrate();
        Pair<TransactionManager<?>, QueryExecutor> pair = switch (WhenMappings.$EnumSwitchMapping$0[Companion.getExecutorType().ordinal()]) {
            case 1 -> this.jdbcEngine();
            case 2 -> this.vertxEngine(this.db.dbName());
            default -> throw new NoWhenBranchMatchedException();
        };
        TransactionManager txnManager = (TransactionManager)pair.component1();
        QueryExecutor queryExecutor = (QueryExecutor)pair.component2();
        this.txnManager = txnManager;
        this.queryExecutor = queryExecutor;
    }

    public /* synthetic */ RepositoryHelper(String string, List list, boolean bl, String string2, DbSchema dbSchema, DatabaseContainer databaseContainer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            string2 = "com/razz/";
        }
        if ((n & 0x10) != 0) {
            dbSchema = DbSchema.Factory.getModelsSchema();
        }
        if ((n & 0x20) != 0) {
            databaseContainer = DatabaseContainer.Companion.getBASIC();
        }
        this(string, list, bl, string2, dbSchema, databaseContainer);
    }

    public int getHikariPoolSize() {
        return this.hikariPoolSize;
    }

    @NotNull
    public final DSLContext getDslContext() {
        return this.dslContext;
    }

    @NotNull
    public final TransactionManager<?> getTxnManager() {
        return this.txnManager;
    }

    @NotNull
    public final QueryExecutor getQueryExecutor() {
        return this.queryExecutor;
    }

    private final Pair<TransactionManager<?>, QueryExecutor> jdbcEngine() {
        HikariDataSource pool = this.databaseContainer.localPool(this.db.dbName(), this.getHikariPoolSize());
        DataSourceConnectionProvider provider = new DataSourceConnectionProvider((DataSource)pool, null, 2, null);
        JdbcTransactionManager jdbcManager = new JdbcTransactionManager((ConnectionProvider)provider, (ConnectionProvider)provider, null, 4, null);
        TransactionManager transactionManager = (TransactionManager)jdbcManager;
        OpenTelemetry openTelemetry = OpenTelemetry.noop();
        Intrinsics.checkNotNullExpressionValue((Object)openTelemetry, (String)"noop(...)");
        return TuplesKt.to((Object)jdbcManager, (Object)new JdbcQueryExecutor(transactionManager, openTelemetry));
    }

    private final Pair<TransactionManager<?>, QueryExecutor> vertxEngine(String dbName) {
        Pool pool = this.vertxPool(this.db, dbName);
        PgPoolConnectionProvider provider = new PgPoolConnectionProvider(pool);
        VertxTransactionManager vertxManager = new VertxTransactionManager((ConnectionProvider)provider, (ConnectionProvider)provider);
        return TuplesKt.to((Object)vertxManager, (Object)new VertxQueryExecutor((TransactionManager)vertxManager));
    }

    private final Pool vertxPool(DatabaseContainerHelper db, String dbName) {
        PgConnectOptions pgConnectOptions;
        PgConnectOptions $this$vertxPool_u24lambda_u241 = pgConnectOptions = new PgConnectOptions();
        boolean bl = false;
        $this$vertxPool_u24lambda_u241.setCachePreparedStatements(true);
        $this$vertxPool_u24lambda_u241.setPreparedStatementCacheMaxSize(2048);
        $this$vertxPool_u24lambda_u241.setPreparedStatementCacheSqlFilter(RepositoryHelper::vertxPool$lambda$1$lambda$0);
        $this$vertxPool_u24lambda_u241.setPipeliningLimit(256);
        $this$vertxPool_u24lambda_u241.setUser(db.username());
        $this$vertxPool_u24lambda_u241.setPassword(db.password());
        $this$vertxPool_u24lambda_u241.setHost(db.dbHost());
        $this$vertxPool_u24lambda_u241.setDatabase(dbName);
        Integer n = db.dbPort();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"dbPort(...)");
        $this$vertxPool_u24lambda_u241.setPort(((Number)n).intValue());
        PgConnectOptions options = pgConnectOptions;
        Pool pool = Pool.pool((SqlConnectOptions)((SqlConnectOptions)options), (PoolOptions)new PoolOptions());
        Intrinsics.checkNotNullExpressionValue((Object)pool, (String)"pool(...)");
        return pool;
    }

    private final Flyway flywayProvider(String dbName, Migration migration) {
        String[] stringArray = new String[]{migration.getSchema().stringValue()};
        FluentConfiguration fluentConfiguration = Flyway.configure().dataSource((DataSource)this.databaseContainer.localPool(dbName, 4)).schemas(stringArray);
        Collection $this$toTypedArray$iv = migration.classpathLocations();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray = thisCollection$iv.toArray(new String[0]);
        Flyway flyway = fluentConfiguration.locations(Arrays.copyOf(stringArray, stringArray.length)).load();
        Intrinsics.checkNotNullExpressionValue((Object)flyway, (String)"load(...)");
        return flyway;
    }

    private static final boolean vertxPool$lambda$1$lambda$0(String sql) {
        return sql.length() < 10000;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/razz/eva/test/repository/RepositoryHelper$Companion;", "", "<init>", "()V", "executorType", "Lcom/razz/eva/persistence/config/ExecutorType;", "getExecutorType", "()Lcom/razz/eva/persistence/config/ExecutorType;", "eva-test"})
    @SourceDebugExtension(value={"SMAP\nRepositoryHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositoryHelper.kt\ncom/razz/eva/test/repository/RepositoryHelper$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        public final ExecutorType getExecutorType() {
            Object object;
            String string = System.getenv("PRIMARY_EXECUTOR_TYPE");
            if (string != null) {
                Object object2;
                String string2 = string;
                try {
                    String p0 = string2;
                    boolean bl = false;
                    object2 = Result.constructor-impl((Object)ExecutorType.valueOf((String)p0));
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Object object3 = object2;
                string2 = (ExecutorType)(Result.isFailure-impl((Object)object3) ? null : object3);
                if (string2 != null) {
                    object = string2;
                    return object;
                }
            }
            object = ExecutorType.JDBC;
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExecutorType.values().length];
            try {
                nArray[ExecutorType.JDBC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutorType.VERTX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

