/*
 * Decompiled with CFR 0.152.
 */
package com.razz.eva.test.db;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.HostConfig;
import com.razz.eva.test.db.DockerImageName;
import com.razz.eva.test.db.Startable;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.PostgreSQLContainer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u000bH\u00d6\u0001R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\b\b\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/razz/eva/test/db/DatabaseContainer;", "", "pgContainer", "Lcom/razz/eva/test/db/DatabaseContainer$PostgreDockerContainer;", "<init>", "(Lcom/razz/eva/test/db/DatabaseContainer$PostgreDockerContainer;)V", "getPgContainer", "()Lcom/razz/eva/test/db/DatabaseContainer$PostgreDockerContainer;", "pgContainer$1", "localPools", "", "", "Lcom/zaxxer/hikari/HikariDataSource;", "managementPool", "getManagementPool", "()Lcom/zaxxer/hikari/HikariDataSource;", "localPool", "dbName", "size", "", "jdbcUrl", "component1", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "PostgreDockerContainer", "eva-test"})
@SourceDebugExtension(value={"SMAP\nDatabaseContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseContainer.kt\ncom/razz/eva/test/db/DatabaseContainer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n382#2,7:100\n1#3:107\n*S KotlinDebug\n*F\n+ 1 DatabaseContainer.kt\ncom/razz/eva/test/db/DatabaseContainer\n*L\n27#1:100,7\n*E\n"})
public final class DatabaseContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PostgreDockerContainer pgContainer$1;
    @NotNull
    private final Map<String, HikariDataSource> localPools;
    @NotNull
    private final HikariDataSource managementPool;
    private static final long MEMORY_IN_BYTES = 0x80000000L;
    private static final long cpuCount = (long)Math.ceil((double)Runtime.getRuntime().availableProcessors() / 4.0);
    private static final PostgreDockerContainer pgContainer;
    @NotNull
    private static final DatabaseContainer BASIC;

    /*
     * WARNING - void declaration
     */
    public DatabaseContainer(@NotNull PostgreDockerContainer pgContainer) {
        void $this$managementPool_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)pgContainer, (String)"pgContainer");
        this.pgContainer$1 = pgContainer;
        this.localPools = new LinkedHashMap();
        HikariConfig hikariConfig = new HikariConfig();
        DatabaseContainer databaseContainer = this;
        boolean bl = false;
        $this$managementPool_u24lambda_u240.setJdbcUrl(this.pgContainer$1.getJdbcUrl());
        $this$managementPool_u24lambda_u240.setUsername("test");
        $this$managementPool_u24lambda_u240.setPassword("test");
        $this$managementPool_u24lambda_u240.setMaximumPoolSize(2);
        databaseContainer.managementPool = new HikariDataSource((HikariConfig)$this$managementPool_u24lambda_u240);
    }

    @NotNull
    public final PostgreDockerContainer getPgContainer() {
        return this.pgContainer$1;
    }

    @NotNull
    public final HikariDataSource getManagementPool() {
        return this.managementPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final HikariDataSource localPool(@NotNull String dbName, int size) {
        HikariDataSource hikariDataSource;
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        PostgreDockerContainer postgreDockerContainer = this.pgContainer$1;
        synchronized (postgreDockerContainer) {
            Object object;
            void $this$getOrPut$iv;
            boolean bl = false;
            Map<String, HikariDataSource> map = this.localPools;
            String key$iv = dbName;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                HikariConfig $this$localPool_u24lambda_u243_u24lambda_u242_u24lambda_u241 = new HikariConfig();
                boolean bl3 = false;
                $this$localPool_u24lambda_u243_u24lambda_u242_u24lambda_u241.setJdbcUrl(this.jdbcUrl(dbName));
                $this$localPool_u24lambda_u243_u24lambda_u242_u24lambda_u241.setUsername("test");
                $this$localPool_u24lambda_u243_u24lambda_u242_u24lambda_u241.setPassword("test");
                $this$localPool_u24lambda_u243_u24lambda_u242_u24lambda_u241.setMaximumPoolSize(size);
                $this$localPool_u24lambda_u243_u24lambda_u242_u24lambda_u241.setInitializationFailTimeout(-1L);
                HikariDataSource answer$iv = new HikariDataSource($this$localPool_u24lambda_u243_u24lambda_u242_u24lambda_u241);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            hikariDataSource = (HikariDataSource)object;
        }
        return hikariDataSource;
    }

    @NotNull
    public final String jdbcUrl(@NotNull String dbName) {
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        String string = this.pgContainer$1.getHost();
        Integer n = PostgreSQLContainer.POSTGRESQL_PORT;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"POSTGRESQL_PORT");
        return "jdbc:postgresql://" + string + ":" + this.pgContainer$1.getMappedPort(((Number)n).intValue()) + "/" + dbName + this.pgContainer$1.getAdditionalUrlParams();
    }

    @NotNull
    public final PostgreDockerContainer component1() {
        return this.pgContainer$1;
    }

    @NotNull
    public final DatabaseContainer copy(@NotNull PostgreDockerContainer pgContainer) {
        Intrinsics.checkNotNullParameter((Object)pgContainer, (String)"pgContainer");
        return new DatabaseContainer(pgContainer);
    }

    public static /* synthetic */ DatabaseContainer copy$default(DatabaseContainer databaseContainer, PostgreDockerContainer postgreDockerContainer, int n, Object object) {
        if ((n & 1) != 0) {
            postgreDockerContainer = databaseContainer.pgContainer$1;
        }
        return databaseContainer.copy(postgreDockerContainer);
    }

    @NotNull
    public String toString() {
        return "DatabaseContainer(pgContainer=" + this.pgContainer$1 + ")";
    }

    public int hashCode() {
        return this.pgContainer$1.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DatabaseContainer)) {
            return false;
        }
        DatabaseContainer databaseContainer = (DatabaseContainer)other;
        return Intrinsics.areEqual((Object)this.pgContainer$1, (Object)databaseContainer.pgContainer$1);
    }

    private static final void pgContainer$lambda$4(CreateContainerCmd cmd) {
        block0: {
            HostConfig hostConfig;
            HostConfig hostConfig2 = cmd.getHostConfig();
            if (hostConfig2 == null || (hostConfig = hostConfig2.withMemory(Long.valueOf(0x80000000L))) == null) break block0;
            hostConfig.withCpuCount(Long.valueOf(cpuCount));
        }
    }

    static {
        GenericContainer genericContainer = ((PostgreDockerContainer)((PostgreDockerContainer)((PostgreDockerContainer)((PostgreDockerContainer)((PostgreDockerContainer)((PostgreDockerContainer)new PostgreDockerContainer(DockerImageName.PostgrePartmanImage16.INSTANCE).withDatabaseName("test")).withUsername("test")).withPassword("test")).withCommand("-c fsync=off -c full_page_writes=off -c synchronous_commit=off -c wal_level=minimal -c checkpoint_timeout=1d -c wal_init_zero=off -c max_wal_senders=0 -c max_connections=200 -c shared_buffers=512MB -c wal_buffers=16MB -c effective_cache_size=1536MB -c effective_io_concurrency=200 -c maintenance_work_mem=128MB -c work_mem=1310kB -c max_worker_processes=2 -c max_parallel_workers_per_gather=1 -c max_parallel_workers=2 -c max_parallel_maintenance_workers=1")).withTmpFs(MapsKt.mapOf((Pair)TuplesKt.to((Object)"/var/lib/postgresql/data", (Object)"rw")))).withReuse(true)).withCreateContainerCmdModifier(DatabaseContainer::pgContainer$lambda$4);
        PostgreDockerContainer $this$pgContainer_u24lambda_u245 = (PostgreDockerContainer)genericContainer;
        boolean bl = false;
        $this$pgContainer_u24lambda_u245.start();
        PostgreDockerContainer postgreDockerContainer = pgContainer = (PostgreDockerContainer)genericContainer;
        Intrinsics.checkNotNullExpressionValue((Object)postgreDockerContainer, (String)"pgContainer");
        BASIC = new DatabaseContainer(postgreDockerContainer);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/razz/eva/test/db/DatabaseContainer$Companion;", "", "<init>", "()V", "MEMORY_IN_BYTES", "", "cpuCount", "pgContainer", "Lcom/razz/eva/test/db/DatabaseContainer$PostgreDockerContainer;", "kotlin.jvm.PlatformType", "BASIC", "Lcom/razz/eva/test/db/DatabaseContainer;", "getBASIC", "()Lcom/razz/eva/test/db/DatabaseContainer;", "eva-test"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DatabaseContainer getBASIC() {
            return BASIC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/razz/eva/test/db/DatabaseContainer$PostgreDockerContainer;", "Lorg/testcontainers/containers/PostgreSQLContainer;", "Lcom/razz/eva/test/db/Startable;", "imageName", "Lcom/razz/eva/test/db/DockerImageName;", "<init>", "(Lcom/razz/eva/test/db/DockerImageName;)V", "additionalUrlParams", "", "getAdditionalUrlParams", "()Ljava/lang/String;", "eva-test"})
    public static final class PostgreDockerContainer
    extends PostgreSQLContainer<PostgreDockerContainer>
    implements Startable {
        @NotNull
        private final String additionalUrlParams;

        public PostgreDockerContainer(@NotNull DockerImageName imageName) {
            Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
            super(imageName.toTestcontainers());
            String string = this.constructUrlParameters("?", "&");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructUrlParameters(...)");
            this.additionalUrlParams = string;
        }

        @NotNull
        public final String getAdditionalUrlParams() {
            return this.additionalUrlParams;
        }
    }
}

