/*
 * Decompiled with CFR 0.152.
 */
package com.razz.eva.test.repository;

import com.razz.eva.persistence.ConnectionMode;
import com.razz.eva.persistence.TransactionManager;
import com.razz.eva.persistence.executor.QueryExecutor;
import com.razz.eva.repository.TransactionalContext;
import com.razz.eva.test.repository.RepositoryHelper;
import io.kotest.core.config.AbstractProjectConfig;
import io.kotest.core.spec.SpecExecutionOrder;
import io.kotest.core.spec.style.BehaviorSpec;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneOffset;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.DSLContext;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001'B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0019\b\u0002\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\bJJ\u0010\u001c\u001a\u0002H\u001d\"\u0004\b\u0000\u0010\u001d21\u0010\u001e\u001a-\b\u0001\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0$\u0012\u0006\u0012\u0004\u0018\u00010%0\u001fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&R\u001c\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006("}, d2={"Lcom/razz/eva/test/repository/RepositorySpec;", "Lio/kotest/core/spec/style/BehaviorSpec;", "helper", "Lcom/razz/eva/test/repository/RepositoryHelper;", "body", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/razz/eva/test/repository/RepositoryHelper;Lkotlin/jvm/functions/Function1;)V", "clock", "Ljava/time/Clock;", "kotlin.jvm.PlatformType", "getClock", "()Ljava/time/Clock;", "dslContext", "Lorg/jooq/DSLContext;", "getDslContext", "()Lorg/jooq/DSLContext;", "executor", "Lcom/razz/eva/persistence/executor/QueryExecutor;", "getExecutor", "()Lcom/razz/eva/persistence/executor/QueryExecutor;", "now", "Ljava/time/Instant;", "getNow", "()Ljava/time/Instant;", "txnManager", "Lcom/razz/eva/persistence/TransactionManager;", "inTransaction", "R", "block", "Lkotlin/Function2;", "Lcom/razz/eva/repository/TransactionalContext;", "Lkotlin/ParameterName;", "name", "context", "Lkotlin/coroutines/Continuation;", "", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ProjectKotestConfig", "eva-test"})
public abstract class RepositorySpec
extends BehaviorSpec {
    @NotNull
    private final DSLContext dslContext;
    @NotNull
    private final QueryExecutor executor;
    @NotNull
    private final TransactionManager<?> txnManager;
    private final Clock clock;

    public RepositorySpec(@NotNull RepositoryHelper helper, @NotNull Function1<? super RepositorySpec, Unit> body) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        super(null, 1, null);
        this.dslContext = helper.getDslContext$eva_test();
        this.executor = helper.getQueryExecutor$eva_test();
        this.txnManager = helper.getTxnManager$eva_test();
        this.clock = Clock.fixed(Clock.tickMillis(ZoneOffset.UTC).instant(), ZoneOffset.UTC);
        body.invoke((Object)this);
    }

    public /* synthetic */ RepositorySpec(RepositoryHelper repositoryHelper, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(repositoryHelper, (Function1<? super RepositorySpec, Unit>)function1);
    }

    @NotNull
    public final DSLContext getDslContext() {
        return this.dslContext;
    }

    @NotNull
    public final QueryExecutor getExecutor() {
        return this.executor;
    }

    public Clock getClock() {
        return this.clock;
    }

    @NotNull
    public final Instant getNow() {
        Instant instant = this.getClock().instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant()");
        return instant;
    }

    @Nullable
    public final <R> Object inTransaction(@NotNull Function2<? super TransactionalContext, ? super Continuation<? super R>, ? extends Object> block, @NotNull Continuation<? super R> $completion) {
        Instant instant = this.getClock().instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant()");
        TransactionalContext context = TransactionalContext.Companion.transactionalContext(instant);
        Function1 txBlock2 = new Function1<Continuation<? super R>, Object>(block, context, null){
            int label;
            final /* synthetic */ Function2<TransactionalContext, Continuation<? super R>, Object> $block;
            final /* synthetic */ TransactionalContext $context;
            {
                this.$block = $block;
                this.$context = $context;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$block.invoke((Object)this.$context, (Object)((Object)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super R> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        };
        return this.txnManager.inTransaction(ConnectionMode.REQUIRE_NEW, txBlock2, $completion);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/razz/eva/test/repository/RepositorySpec$ProjectKotestConfig;", "Lio/kotest/core/config/AbstractProjectConfig;", "()V", "concurrentSpecs", "", "getConcurrentSpecs$annotations", "getConcurrentSpecs", "()Ljava/lang/Integer;", "parallelism", "getParallelism", "specExecutionOrder", "Lio/kotest/core/spec/SpecExecutionOrder;", "getSpecExecutionOrder", "()Lio/kotest/core/spec/SpecExecutionOrder;", "eva-test"})
    public static final class ProjectKotestConfig
    extends AbstractProjectConfig {
        @NotNull
        public static final ProjectKotestConfig INSTANCE = new ProjectKotestConfig();
        private static final int parallelism = 2;
        private static final int concurrentSpecs = 4;
        @NotNull
        private static final SpecExecutionOrder specExecutionOrder = SpecExecutionOrder.Random;

        private ProjectKotestConfig() {
        }

        @NotNull
        public Integer getParallelism() {
            return parallelism;
        }

        @NotNull
        public Integer getConcurrentSpecs() {
            return concurrentSpecs;
        }

        public static /* synthetic */ void getConcurrentSpecs$annotations() {
        }

        @NotNull
        public SpecExecutionOrder getSpecExecutionOrder() {
            return specExecutionOrder;
        }
    }
}

