/*
 * Decompiled with CFR 0.152.
 */
package com.razz.eva.test.repository;

import com.razz.eva.migrations.Migration;
import com.razz.eva.persistence.ConnectionProvider;
import com.razz.eva.persistence.TransactionManager;
import com.razz.eva.persistence.config.ExecutorType;
import com.razz.eva.persistence.executor.QueryExecutor;
import com.razz.eva.persistence.jdbc.HikariPoolConnectionProvider;
import com.razz.eva.persistence.jdbc.JdbcTransactionManager;
import com.razz.eva.persistence.jdbc.executor.JdbcQueryExecutor;
import com.razz.eva.persistence.vertx.PgPoolConnectionProvider;
import com.razz.eva.persistence.vertx.VertxTransactionManager;
import com.razz.eva.persistence.vertx.executor.VertxQueryExecutor;
import com.razz.eva.test.db.DatabaseContainerHelper;
import com.zaxxer.hikari.HikariDataSource;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgPool;
import io.vertx.sqlclient.PoolOptions;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.conf.ParamType;
import org.jooq.conf.Settings;
import org.jooq.impl.DSL;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000  2\u00020\u0001:\u0001 B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0004\u0012\u00020\u000f0\u001cH\u0002J \u0010\u001d\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0004\u0012\u00020\u000f0\u001c2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/razz/eva/test/repository/RepositoryHelper;", "", "migrationPath", "", "createPartman", "", "(Ljava/lang/String;Z)V", "db", "Lcom/razz/eva/test/db/DatabaseContainerHelper;", "dslContext", "Lorg/jooq/DSLContext;", "Lorg/jetbrains/annotations/NotNull;", "getDslContext$eva_test", "()Lorg/jooq/DSLContext;", "queryExecutor", "Lcom/razz/eva/persistence/executor/QueryExecutor;", "getQueryExecutor$eva_test", "()Lcom/razz/eva/persistence/executor/QueryExecutor;", "txnManager", "Lcom/razz/eva/persistence/TransactionManager;", "getTxnManager$eva_test", "()Lcom/razz/eva/persistence/TransactionManager;", "flywayProvider", "Lorg/flywaydb/core/Flyway;", "dbName", "migration", "Lcom/razz/eva/migrations/Migration;", "jdbcEngine", "Lkotlin/Pair;", "vertxEngine", "vertxPool", "Lio/vertx/pgclient/PgPool;", "Companion", "eva-test"})
public class RepositoryHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DSLContext dslContext;
    @NotNull
    private final TransactionManager<?> txnManager;
    @NotNull
    private final QueryExecutor queryExecutor;
    @NotNull
    private final DatabaseContainerHelper db;

    public RepositoryHelper(@NotNull String migrationPath, boolean createPartman) {
        Intrinsics.checkNotNullParameter((Object)migrationPath, (String)"migrationPath");
        DSLContext dSLContext = DSL.using((SQLDialect)SQLDialect.POSTGRES, (Settings)new Settings().withRenderNamedParamPrefix("$").withParamType(ParamType.NAMED));
        Intrinsics.checkNotNullExpressionValue((Object)dSLContext, (String)"using(\n        SQLDialec\u2026pe(ParamType.NAMED)\n    )");
        this.dslContext = dSLContext;
        this.db = DatabaseContainerHelper.Companion.create(StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)migrationPath, (String)"com/razz/", (String)"", (boolean)false, (int)4, null), (String)"/db", (String)"", (boolean)false, (int)4, null), (String)"/", (String)"", (boolean)false, (int)4, null) + "_repo_test");
        Migration.ModelsMigration modelsMigration = new Migration.ModelsMigration(migrationPath);
        this.db.createSchemas(createPartman);
        this.flywayProvider(this.db.dbName(), (Migration)modelsMigration).migrate();
        Pair<TransactionManager<?>, QueryExecutor> pair = switch (WhenMappings.$EnumSwitchMapping$0[Companion.getExecutorType().ordinal()]) {
            case 1 -> this.jdbcEngine();
            case 2 -> this.vertxEngine(this.db.dbName());
            default -> throw new NoWhenBranchMatchedException();
        };
        TransactionManager txnManager = (TransactionManager)pair.component1();
        QueryExecutor queryExecutor = (QueryExecutor)pair.component2();
        this.txnManager = txnManager;
        this.queryExecutor = queryExecutor;
    }

    public /* synthetic */ RepositoryHelper(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    @NotNull
    public final DSLContext getDslContext$eva_test() {
        return this.dslContext;
    }

    @NotNull
    public final TransactionManager<?> getTxnManager$eva_test() {
        return this.txnManager;
    }

    @NotNull
    public final QueryExecutor getQueryExecutor$eva_test() {
        return this.queryExecutor;
    }

    private final Pair<TransactionManager<?>, QueryExecutor> jdbcEngine() {
        HikariDataSource pool = DatabaseContainerHelper.Companion.localPool(this.db.dbName());
        HikariPoolConnectionProvider provider = new HikariPoolConnectionProvider(pool, null, 2, null);
        JdbcTransactionManager jdbcManager = new JdbcTransactionManager((ConnectionProvider)provider, (ConnectionProvider)provider, null, 4, null);
        return TuplesKt.to((Object)jdbcManager, (Object)new JdbcQueryExecutor(jdbcManager));
    }

    private final Pair<TransactionManager<?>, QueryExecutor> vertxEngine(String dbName) {
        PgPool pool = this.vertxPool(this.db, dbName);
        PgPoolConnectionProvider provider = new PgPoolConnectionProvider(pool);
        VertxTransactionManager vertxnManager = new VertxTransactionManager((ConnectionProvider)provider, (ConnectionProvider)provider);
        return TuplesKt.to((Object)vertxnManager, (Object)new VertxQueryExecutor(vertxnManager));
    }

    private final PgPool vertxPool(DatabaseContainerHelper db, String dbName) {
        PgConnectOptions pgConnectOptions;
        PgConnectOptions $this$vertxPool_u24lambda_u2d1 = pgConnectOptions = new PgConnectOptions();
        boolean bl = false;
        $this$vertxPool_u24lambda_u2d1.setCachePreparedStatements(true);
        $this$vertxPool_u24lambda_u2d1.setPreparedStatementCacheMaxSize(2048);
        $this$vertxPool_u24lambda_u2d1.setPreparedStatementCacheSqlFilter(RepositoryHelper::vertxPool$lambda-1$lambda-0);
        $this$vertxPool_u24lambda_u2d1.setPipeliningLimit(256);
        $this$vertxPool_u24lambda_u2d1.setUser(db.username());
        $this$vertxPool_u24lambda_u2d1.setPassword(db.password());
        $this$vertxPool_u24lambda_u2d1.setHost(db.dbHost());
        $this$vertxPool_u24lambda_u2d1.setDatabase(dbName);
        Integer n = db.dbPort();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"db.dbPort()");
        $this$vertxPool_u24lambda_u2d1.setPort(((Number)n).intValue());
        PgConnectOptions options = pgConnectOptions;
        pgConnectOptions = PgPool.pool((PgConnectOptions)options, (PoolOptions)new PoolOptions());
        Intrinsics.checkNotNullExpressionValue((Object)pgConnectOptions, (String)"pool(options, PoolOptions())");
        return pgConnectOptions;
    }

    private final Flyway flywayProvider(String dbName, Migration migration) {
        String[] stringArray = new String[]{migration.getSchema().toString()};
        FluentConfiguration fluentConfiguration = Flyway.configure().dataSource((DataSource)DatabaseContainerHelper.Companion.localPool(dbName)).schemas(stringArray);
        stringArray = new String[]{migration.classpathLocation()};
        Flyway flyway = fluentConfiguration.locations(stringArray).load();
        Intrinsics.checkNotNullExpressionValue((Object)flyway, (String)"configure()\n            \u2026on())\n            .load()");
        return flyway;
    }

    private static final boolean vertxPool$lambda-1$lambda-0(String sql) {
        return sql.length() < 10000;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/razz/eva/test/repository/RepositoryHelper$Companion;", "", "()V", "executorType", "Lcom/razz/eva/persistence/config/ExecutorType;", "getExecutorType", "()Lcom/razz/eva/persistence/config/ExecutorType;", "eva-test"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExecutorType getExecutorType() {
            ExecutorType executorType;
            String string = System.getenv("PRIMARY_EXECUTOR_TYPE");
            if (string == null) {
                executorType = null;
            } else {
                Object object;
                Object object2;
                Object object3 = string;
                try {
                    String p0 = object3;
                    boolean bl = false;
                    object2 = Result.constructor-impl((Object)ExecutorType.valueOf((String)p0));
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object3 = object = object2;
                executorType = (ExecutorType)(Result.isFailure-impl((Object)object3) ? null : object3);
            }
            ExecutorType executorType2 = executorType;
            return executorType2 == null ? ExecutorType.JDBC : executorType2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExecutorType.values().length];
            nArray[ExecutorType.JDBC.ordinal()] = 1;
            nArray[ExecutorType.VERTX.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

