/*
 * Decompiled with CFR 0.152.
 */
package com.razz.eva.test.db;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.HostConfig;
import com.razz.eva.test.db.DatabaseContainerHelper;
import com.razz.eva.test.db.DockerImageName;
import com.razz.eva.test.db.Startable;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.PostgreSQLContainer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\n \u0012*\u0004\u0018\u00010\u00030\u0003J\u0006\u0010\u0007\u001a\u00020\u0003J\u0013\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00140\u0014\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003J\u0010\u0010\u0017\u001a\n \u0012*\u0004\u0018\u00010\u00180\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/razz/eva/test/db/DatabaseContainerHelper;", "Ljava/io/Closeable;", "dbPrefix", "", "db", "Lcom/razz/eva/test/db/DatabaseContainerHelper$PostgreDockerContainer;", "(Ljava/lang/String;Lcom/razz/eva/test/db/DatabaseContainerHelper$PostgreDockerContainer;)V", "dbName", "logger", "Lmu/KLogger;", "close", "", "createDb", "", "createSchemas", "createPartman", "", "dbHost", "kotlin.jvm.PlatformType", "dbPort", "", "()Ljava/lang/Integer;", "jdbcUrl", "localConn", "Ljava/sql/Connection;", "password", "username", "Companion", "PostgreDockerContainer", "eva-test"})
public final class DatabaseContainerHelper
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PostgreDockerContainer db;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final String dbName;
    @NotNull
    private static final Regex DB_NAME_FORMAT = new Regex("[a-z0-9_]+");
    private static final long memoryInBytes = 0x40000000L;
    private static final long cpuCount = (long)Math.ceil((double)Runtime.getRuntime().availableProcessors() / 4.0);
    private static final PostgreDockerContainer pgContainer;
    @NotNull
    private static final HikariDataSource managementPool;
    @NotNull
    private static final Map<String, HikariDataSource> localPools;

    private DatabaseContainerHelper(String dbPrefix, PostgreDockerContainer db) {
        this.db = db;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        ZonedDateTime now = ZonedDateTime.now();
        Duration sinceMonth = Duration.between(now.truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1), now);
        long seconds = sinceMonth.toSeconds();
        String string = System.getenv("RAZZ_TEST_DB_CONTAINER_DB_SUFFIX");
        String sortableSuffix = string == null ? seconds / (long)60 + "_" + seconds % (long)60 : string;
        this.dbName = dbPrefix + "_" + sortableSuffix;
    }

    @NotNull
    public final String dbName() {
        return this.dbName;
    }

    public final String dbHost() {
        return this.db.getContainerIpAddress();
    }

    public final Integer dbPort() {
        Integer n = PostgreSQLContainer.POSTGRESQL_PORT;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"POSTGRESQL_PORT");
        return this.db.getMappedPort(((Number)n).intValue());
    }

    @NotNull
    public final String jdbcUrl() {
        return this.jdbcUrl(this.dbName);
    }

    @NotNull
    public final String jdbcUrl(@NotNull String dbName) {
        Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
        return DatabaseContainerHelper.Companion.jdbcUrl(dbName, this.db);
    }

    @NotNull
    public final String username() {
        String string = this.db.getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"db.username");
        return string;
    }

    @NotNull
    public final String password() {
        String string = this.db.getPassword();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"db.password");
        return string;
    }

    private final Connection localConn() {
        return Companion.localPool(this.dbName).getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object createDb() {
        Object object;
        try {
            Boolean bl;
            object = managementPool.getConnection();
            Throwable throwable = null;
            try {
                boolean bl2;
                Connection conn = (Connection)object;
                boolean bl3 = false;
                AutoCloseable autoCloseable = conn.createStatement();
                Throwable throwable2 = null;
                try {
                    Statement stmt = (Statement)autoCloseable;
                    boolean bl4 = false;
                    bl2 = stmt.execute(StringsKt.trimIndent((String)("\n                        CREATE DATABASE " + this.dbName + ";\n                    ")));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
                bl = bl2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            object = bl;
        }
        catch (SQLException e) {
            if (Intrinsics.areEqual((Object)e.getSQLState(), (Object)"42P04")) {
                this.logger.debug((Throwable)e, (Function0)createDb.2.INSTANCE);
            } else {
                this.logger.error((Throwable)e, (Function0)createDb.3.INSTANCE);
            }
            object = Unit.INSTANCE;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createSchemas(boolean createPartman) {
        String statement = (createPartman ? "CREATE SCHEMA IF NOT EXISTS partman;\nCREATE EXTENSION IF NOT EXISTS pg_partman WITH SCHEMA partman;" : "") + "CREATE EXTENSION IF NOT EXISTS btree_gist;\nCREATE EXTENSION IF NOT EXISTS intarray;\nCREATE EXTENSION IF NOT EXISTS timescaledb;";
        if (!(!StringsKt.isBlank((CharSequence)statement))) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        AutoCloseable autoCloseable = this.localConn();
        Throwable throwable = null;
        try {
            boolean bl;
            Connection conn = (Connection)autoCloseable;
            boolean bl2 = false;
            AutoCloseable autoCloseable2 = conn.createStatement();
            Throwable throwable2 = null;
            try {
                Statement stmt = (Statement)autoCloseable2;
                boolean bl3 = false;
                bl = stmt.execute(statement);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            boolean bl4 = bl;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void createSchemas$default(DatabaseContainerHelper databaseContainerHelper, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        databaseContainerHelper.createSchemas(bl);
    }

    @Override
    public void close() {
        this.db.close();
    }

    private static final void pgContainer$lambda-4(CreateContainerCmd cmd) {
        HostConfig hostConfig;
        HostConfig hostConfig2 = cmd.getHostConfig();
        if (hostConfig2 != null && (hostConfig = hostConfig2.withMemory(Long.valueOf(0x40000000L))) != null) {
            hostConfig.withCpuCount(Long.valueOf(cpuCount));
        }
    }

    public /* synthetic */ DatabaseContainerHelper(String dbPrefix, PostgreDockerContainer db, DefaultConstructorMarker $constructor_marker) {
        this(dbPrefix, db);
    }

    static {
        GenericContainer genericContainer = ((PostgreDockerContainer)((PostgreDockerContainer)((PostgreDockerContainer)((PostgreDockerContainer)((PostgreDockerContainer)((PostgreDockerContainer)new PostgreDockerContainer(DockerImageName.PostgrePartmanImage13.INSTANCE).withDatabaseName("test")).withUsername("test")).withPassword("test")).withCommand("-c fsync=off -c synchronous_commit=off -c wal_level=minimal -c max_wal_senders=0 -c wal_init_zero=off -c full_page_writes=off -c checkpoint_timeout=1d -c max_wal_size=2GB -c max_connections=300 -c shared_buffers=512MB -c temp_buffers=32MB -c wal_buffers=32MB -c seq_page_cost=0.01 -c random_page_cost=0.01 -c effective_cache_size=64MB -c maintenance_work_mem=512MB -c work_mem=64MB")).withTmpFs(MapsKt.mapOf((Pair)TuplesKt.to((Object)"/var/lib/postgresql/data", (Object)"rw")))).withReuse(true)).withCreateContainerCmdModifier(DatabaseContainerHelper::pgContainer$lambda-4);
        PostgreDockerContainer $this$pgContainer_u24lambda_u2d5 = (PostgreDockerContainer)genericContainer;
        boolean bl = false;
        $this$pgContainer_u24lambda_u2d5.start();
        pgContainer = (PostgreDockerContainer)genericContainer;
        HikariConfig $this$managementPool_u24lambda_u2d6 = new HikariConfig();
        boolean bl2 = false;
        $this$managementPool_u24lambda_u2d6.setJdbcUrl(pgContainer.getJdbcUrl());
        $this$managementPool_u24lambda_u2d6.setUsername("test");
        $this$managementPool_u24lambda_u2d6.setPassword("test");
        $this$managementPool_u24lambda_u2d6.setMaximumPoolSize(2);
        managementPool = new HikariDataSource($this$managementPool_u24lambda_u2d6);
        localPools = new LinkedHashMap();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/razz/eva/test/db/DatabaseContainerHelper$PostgreDockerContainer;", "Lorg/testcontainers/containers/PostgreSQLContainer;", "Lcom/razz/eva/test/db/Startable;", "imageName", "Lcom/razz/eva/test/db/DockerImageName;", "(Lcom/razz/eva/test/db/DockerImageName;)V", "additionalUrlParams", "", "getAdditionalUrlParams", "()Ljava/lang/String;", "eva-test"})
    private static final class PostgreDockerContainer
    extends PostgreSQLContainer<PostgreDockerContainer>
    implements Startable {
        @NotNull
        private final String additionalUrlParams;

        public PostgreDockerContainer(@NotNull DockerImageName imageName) {
            Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
            super(imageName.toTestcontainers());
            String string = this.constructUrlParameters("?", "&");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructUrlParameters(\"?\", \"&\")");
            this.additionalUrlParams = string;
        }

        @NotNull
        public final String getAdditionalUrlParams() {
            return this.additionalUrlParams;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tJ\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/razz/eva/test/db/DatabaseContainerHelper$Companion;", "", "()V", "DB_NAME_FORMAT", "Lkotlin/text/Regex;", "cpuCount", "", "localPools", "", "", "Lcom/zaxxer/hikari/HikariDataSource;", "managementPool", "memoryInBytes", "pgContainer", "Lcom/razz/eva/test/db/DatabaseContainerHelper$PostgreDockerContainer;", "kotlin.jvm.PlatformType", "create", "Lcom/razz/eva/test/db/DatabaseContainerHelper;", "dbName", "jdbcUrl", "db", "localPool", "eva-test"})
    public static final class Companion {
        private Companion() {
        }

        private final String jdbcUrl(String dbName, PostgreDockerContainer db) {
            String string = db.getContainerIpAddress();
            Integer n = PostgreSQLContainer.POSTGRESQL_PORT;
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"POSTGRESQL_PORT");
            return "jdbc:postgresql://" + string + ":" + db.getMappedPort(((Number)n).intValue()) + "/" + dbName + db.getAdditionalUrlParams();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final HikariDataSource localPool(@NotNull String dbName) {
            HikariDataSource hikariDataSource;
            Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
            synchronized (this) {
                Object object;
                boolean bl = false;
                Map $this$getOrPut$iv = localPools;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(dbName);
                if (value$iv == null) {
                    boolean bl2 = false;
                    HikariConfig $this$localPool_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0 = new HikariConfig();
                    boolean bl3 = false;
                    PostgreDockerContainer postgreDockerContainer = pgContainer;
                    Intrinsics.checkNotNullExpressionValue((Object)postgreDockerContainer, (String)"pgContainer");
                    $this$localPool_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.setJdbcUrl(Companion.jdbcUrl(dbName, postgreDockerContainer));
                    $this$localPool_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.setUsername("test");
                    $this$localPool_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.setPassword("test");
                    $this$localPool_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.setMaximumPoolSize(10);
                    $this$localPool_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.setInitializationFailTimeout(-1L);
                    HikariDataSource answer$iv = new HikariDataSource($this$localPool_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0);
                    $this$getOrPut$iv.put(dbName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                hikariDataSource = (HikariDataSource)object;
            }
            return hikariDataSource;
        }

        @NotNull
        public final DatabaseContainerHelper create(@NotNull String dbName) {
            Intrinsics.checkNotNullParameter((Object)dbName, (String)"dbName");
            if (!DB_NAME_FORMAT.matches((CharSequence)dbName)) {
                boolean $i$a$-require-DatabaseContainerHelper$Companion$create$22 = false;
                String $i$a$-require-DatabaseContainerHelper$Companion$create$22 = "Wrong DB name: " + dbName + ". DB name should have only lowercase chars and numbers.";
                throw new IllegalArgumentException($i$a$-require-DatabaseContainerHelper$Companion$create$22.toString());
            }
            Object object = pgContainer;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pgContainer");
            Object $this$create_u24lambda_u2d4 = object = new DatabaseContainerHelper(dbName, (PostgreDockerContainer)object, null);
            boolean bl = false;
            ((DatabaseContainerHelper)$this$create_u24lambda_u2d4).createDb();
            DatabaseContainerHelper.createSchemas$default((DatabaseContainerHelper)$this$create_u24lambda_u2d4, false, 1, null);
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

