/*
 * Decompiled with CFR 0.152.
 */
package com.razz.eva.serialization.json;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/razz/eva/serialization/json/LocalDateSerializer;", "Lkotlinx/serialization/KSerializer;", "Ljava/time/LocalDate;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "formatter", "Ljava/time/format/DateTimeFormatter;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "formatToString", "", "value", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "eva-serialization"})
public final class LocalDateSerializer
implements KSerializer<LocalDate> {
    @NotNull
    public static final LocalDateSerializer INSTANCE = new LocalDateSerializer();
    @NotNull
    private static final DateTimeFormatter formatter;
    @NotNull
    private static final SerialDescriptor descriptor;

    private LocalDateSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public LocalDate deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        LocalDate localDate = LocalDate.parse(decoder.decodeString());
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(decoder.decodeString())");
        return localDate;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull LocalDate value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        encoder.encodeString(this.formatToString(value));
    }

    @NotNull
    public final String formatToString(@NotNull LocalDate value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = formatter.format(value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatter.format(value)");
        return string;
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(\"yyyy-MM-dd\")");
        formatter = dateTimeFormatter;
        descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"LocalDate", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));
    }
}

