/*
 * Decompiled with CFR 0.152.
 */
package com.razz.eva.persistence;

import com.razz.eva.IdempotencyKey;
import com.razz.eva.domain.ModelId;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0007\u0006\u0007\b\t\n\u000b\fB\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u0082\u0001\u0006\r\u000e\u000f\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/razz/eva/persistence/PersistenceException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "(Ljava/lang/String;)V", "ConstraintViolation", "ModelPersistingGenericException", "ModelRecordConstraintViolationException", "PersistingGenericException", "StaleRecordException", "UniqueModelRecordViolationException", "UniqueUowEventRecordViolationException", "Lcom/razz/eva/persistence/PersistenceException$ModelPersistingGenericException;", "Lcom/razz/eva/persistence/PersistenceException$ModelRecordConstraintViolationException;", "Lcom/razz/eva/persistence/PersistenceException$PersistingGenericException;", "Lcom/razz/eva/persistence/PersistenceException$StaleRecordException;", "Lcom/razz/eva/persistence/PersistenceException$UniqueModelRecordViolationException;", "Lcom/razz/eva/persistence/PersistenceException$UniqueUowEventRecordViolationException;", "eva-persistence"})
public abstract sealed class PersistenceException
extends RuntimeException {
    private PersistenceException(String message) {
        super(message);
    }

    public /* synthetic */ PersistenceException(String message, DefaultConstructorMarker $constructor_marker) {
        this(message);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/razz/eva/persistence/PersistenceException$ConstraintViolation;", "", "constraintName", "", "getConstraintName", "()Ljava/lang/String;", "Lcom/razz/eva/persistence/PersistenceException$ModelRecordConstraintViolationException;", "Lcom/razz/eva/persistence/PersistenceException$UniqueModelRecordViolationException;", "eva-persistence"})
    public static sealed interface ConstraintViolation
    permits ModelRecordConstraintViolationException, UniqueModelRecordViolationException {
        @Nullable
        public String getConstraintName();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/razz/eva/persistence/PersistenceException$ModelPersistingGenericException;", "Lcom/razz/eva/persistence/PersistenceException;", "modelId", "Lcom/razz/eva/domain/ModelId;", "cause", "", "(Lcom/razz/eva/domain/ModelId;Ljava/lang/Throwable;)V", "getCause", "()Ljava/lang/Throwable;", "getModelId", "()Lcom/razz/eva/domain/ModelId;", "eva-persistence"})
    public static final class ModelPersistingGenericException
    extends PersistenceException {
        @NotNull
        private final ModelId<?> modelId;
        @NotNull
        private final Throwable cause;

        public ModelPersistingGenericException(@NotNull ModelId<?> modelId, @NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter(modelId, (String)"modelId");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super("Persisting [" + modelId.stringValue() + "] failed", (DefaultConstructorMarker)null);
            this.modelId = modelId;
            this.cause = cause;
        }

        @NotNull
        public final ModelId<?> getModelId() {
            return this.modelId;
        }

        @Override
        @NotNull
        public Throwable getCause() {
            return this.cause;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/razz/eva/persistence/PersistenceException$ModelRecordConstraintViolationException;", "Lcom/razz/eva/persistence/PersistenceException$ConstraintViolation;", "Lcom/razz/eva/persistence/PersistenceException;", "modelId", "Lcom/razz/eva/domain/ModelId;", "tableName", "", "constraintName", "(Lcom/razz/eva/domain/ModelId;Ljava/lang/String;Ljava/lang/String;)V", "getConstraintName", "()Ljava/lang/String;", "getModelId", "()Lcom/razz/eva/domain/ModelId;", "getTableName", "eva-persistence"})
    @SourceDebugExtension(value={"SMAP\nPersistenceException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistenceException.kt\ncom/razz/eva/persistence/PersistenceException$ModelRecordConstraintViolationException\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
    public static non-sealed class ModelRecordConstraintViolationException
    extends PersistenceException
    implements ConstraintViolation {
        @NotNull
        private final ModelId<?> modelId;
        @NotNull
        private final String tableName;
        @Nullable
        private final String constraintName;

        /*
         * WARNING - void declaration
         */
        public ModelRecordConstraintViolationException(@NotNull ModelId<?> modelId, @NotNull String tableName, @Nullable String constraintName) {
            String string;
            Intrinsics.checkNotNullParameter(modelId, (String)"modelId");
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            ModelRecordConstraintViolationException modelRecordConstraintViolationException = this;
            String string2 = tableName;
            String string3 = modelId.stringValue();
            String string4 = constraintName;
            if (string4 != null) {
                void it;
                String string5 = string4;
                String string6 = string3;
                String string7 = string2;
                ModelRecordConstraintViolationException modelRecordConstraintViolationException2 = modelRecordConstraintViolationException;
                boolean bl = false;
                String string8 = ": [" + (String)it + "]";
                modelRecordConstraintViolationException = modelRecordConstraintViolationException2;
                string2 = string7;
                string3 = string6;
                string = string8;
            } else {
                string = null;
            }
            super("Constraint for [" + string2 + "]:[" + string3 + "] violated " + string, (DefaultConstructorMarker)null);
            this.modelId = modelId;
            this.tableName = tableName;
            this.constraintName = constraintName;
        }

        @NotNull
        public final ModelId<?> getModelId() {
            return this.modelId;
        }

        @NotNull
        public final String getTableName() {
            return this.tableName;
        }

        @Override
        @Nullable
        public String getConstraintName() {
            return this.constraintName;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/razz/eva/persistence/PersistenceException$PersistingGenericException;", "Lcom/razz/eva/persistence/PersistenceException;", "cause", "", "(Ljava/lang/Throwable;)V", "getCause", "()Ljava/lang/Throwable;", "eva-persistence"})
    public static final class PersistingGenericException
    extends PersistenceException {
        @NotNull
        private final Throwable cause;

        public PersistingGenericException(@NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super("Persisting failed", (DefaultConstructorMarker)null);
            this.cause = cause;
        }

        @Override
        @NotNull
        public Throwable getCause() {
            return this.cause;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0006\u00a2\u0006\u0002\u0010\u0007R\u001b\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/razz/eva/persistence/PersistenceException$StaleRecordException;", "Lcom/razz/eva/persistence/PersistenceException;", "modelId", "Lcom/razz/eva/domain/ModelId;", "(Lcom/razz/eva/domain/ModelId;)V", "modelIds", "", "(Ljava/util/Set;)V", "getModelIds", "()Ljava/util/Set;", "eva-persistence"})
    public static final class StaleRecordException
    extends PersistenceException {
        @NotNull
        private final Set<ModelId<?>> modelIds;

        public StaleRecordException(@NotNull Set<? extends ModelId<?>> modelIds) {
            Intrinsics.checkNotNullParameter(modelIds, (String)"modelIds");
            super("Rows for " + CollectionsKt.joinToString$default((Iterable)modelIds, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)1.INSTANCE, (int)25, null) + " were concurrently updated", (DefaultConstructorMarker)null);
            this.modelIds = modelIds;
        }

        @NotNull
        public final Set<ModelId<?>> getModelIds() {
            return this.modelIds;
        }

        public StaleRecordException(@NotNull ModelId<?> modelId) {
            Intrinsics.checkNotNullParameter(modelId, (String)"modelId");
            this(SetsKt.setOf(modelId));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/razz/eva/persistence/PersistenceException$UniqueModelRecordViolationException;", "Lcom/razz/eva/persistence/PersistenceException$ConstraintViolation;", "Lcom/razz/eva/persistence/PersistenceException;", "modelId", "Lcom/razz/eva/domain/ModelId;", "tableName", "", "constraintName", "(Lcom/razz/eva/domain/ModelId;Ljava/lang/String;Ljava/lang/String;)V", "getConstraintName", "()Ljava/lang/String;", "getModelId", "()Lcom/razz/eva/domain/ModelId;", "getTableName", "eva-persistence"})
    @SourceDebugExtension(value={"SMAP\nPersistenceException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistenceException.kt\ncom/razz/eva/persistence/PersistenceException$UniqueModelRecordViolationException\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
    public static non-sealed class UniqueModelRecordViolationException
    extends PersistenceException
    implements ConstraintViolation {
        @NotNull
        private final ModelId<?> modelId;
        @NotNull
        private final String tableName;
        @Nullable
        private final String constraintName;

        /*
         * WARNING - void declaration
         */
        public UniqueModelRecordViolationException(@NotNull ModelId<?> modelId, @NotNull String tableName, @Nullable String constraintName) {
            String string;
            Intrinsics.checkNotNullParameter(modelId, (String)"modelId");
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            UniqueModelRecordViolationException uniqueModelRecordViolationException = this;
            String string2 = tableName;
            String string3 = modelId.stringValue();
            String string4 = constraintName;
            if (string4 != null) {
                void it;
                String string5 = string4;
                String string6 = string3;
                String string7 = string2;
                UniqueModelRecordViolationException uniqueModelRecordViolationException2 = uniqueModelRecordViolationException;
                boolean bl = false;
                String string8 = ": [" + (String)it + "]";
                uniqueModelRecordViolationException = uniqueModelRecordViolationException2;
                string2 = string7;
                string3 = string6;
                string = string8;
            } else {
                string = null;
            }
            super("Uniqueness of [" + string2 + "]:[" + string3 + "] violated " + string, (DefaultConstructorMarker)null);
            this.modelId = modelId;
            this.tableName = tableName;
            this.constraintName = constraintName;
        }

        @NotNull
        public final ModelId<?> getModelId() {
            return this.modelId;
        }

        @NotNull
        public final String getTableName() {
            return this.tableName;
        }

        @Override
        @Nullable
        public String getConstraintName() {
            return this.constraintName;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/razz/eva/persistence/PersistenceException$UniqueUowEventRecordViolationException;", "Lcom/razz/eva/persistence/PersistenceException;", "uowId", "Ljava/util/UUID;", "uowName", "", "idempotencyKey", "Lcom/razz/eva/IdempotencyKey;", "constraintName", "(Ljava/util/UUID;Ljava/lang/String;Lcom/razz/eva/IdempotencyKey;Ljava/lang/String;)V", "getConstraintName", "()Ljava/lang/String;", "getIdempotencyKey", "()Lcom/razz/eva/IdempotencyKey;", "getUowId", "()Ljava/util/UUID;", "getUowName", "eva-persistence"})
    @SourceDebugExtension(value={"SMAP\nPersistenceException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistenceException.kt\ncom/razz/eva/persistence/PersistenceException$UniqueUowEventRecordViolationException\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
    public static final class UniqueUowEventRecordViolationException
    extends PersistenceException {
        @NotNull
        private final UUID uowId;
        @NotNull
        private final String uowName;
        @Nullable
        private final IdempotencyKey idempotencyKey;
        @Nullable
        private final String constraintName;

        public UniqueUowEventRecordViolationException(@NotNull UUID uowId, @NotNull String uowName, @Nullable IdempotencyKey idempotencyKey, @Nullable String constraintName) {
            String string;
            String string2;
            String string3;
            String it;
            UniqueUowEventRecordViolationException uniqueUowEventRecordViolationException;
            String string4;
            UUID uUID;
            Intrinsics.checkNotNullParameter((Object)uowId, (String)"uowId");
            Intrinsics.checkNotNullParameter((Object)uowName, (String)"uowName");
            UniqueUowEventRecordViolationException uniqueUowEventRecordViolationException2 = this;
            String string5 = uowName;
            UUID uUID2 = uowId;
            IdempotencyKey idempotencyKey2 = idempotencyKey;
            if (idempotencyKey2 != null) {
                IdempotencyKey idempotencyKey3 = idempotencyKey2;
                uUID = uUID2;
                string4 = string5;
                uniqueUowEventRecordViolationException = uniqueUowEventRecordViolationException2;
                boolean bl = false;
                string3 = ": [" + it.stringValue() + "]";
                uniqueUowEventRecordViolationException2 = uniqueUowEventRecordViolationException;
                string5 = string4;
                uUID2 = uUID;
                string2 = string3;
            } else {
                string2 = null;
            }
            String string6 = constraintName;
            if (string6 != null) {
                it = string6;
                string3 = string2;
                uUID = uUID2;
                string4 = string5;
                uniqueUowEventRecordViolationException = uniqueUowEventRecordViolationException2;
                boolean bl = false;
                String string7 = ": [" + it + "]";
                uniqueUowEventRecordViolationException2 = uniqueUowEventRecordViolationException;
                string5 = string4;
                uUID2 = uUID;
                string2 = string3;
                string = string7;
            } else {
                string = null;
            }
            super("Uniqueness of [" + string5 + "] [" + uUID2 + "] " + string2 + " violated " + string, (DefaultConstructorMarker)null);
            this.uowId = uowId;
            this.uowName = uowName;
            this.idempotencyKey = idempotencyKey;
            this.constraintName = constraintName;
        }

        @NotNull
        public final UUID getUowId() {
            return this.uowId;
        }

        @NotNull
        public final String getUowName() {
            return this.uowName;
        }

        @Nullable
        public final IdempotencyKey getIdempotencyKey() {
            return this.idempotencyKey;
        }

        @Nullable
        public final String getConstraintName() {
            return this.constraintName;
        }
    }
}

