/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.annotations;

import java.lang.reflect.Method;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.tapestry.annotations.AnnotationUtils;
import org.apache.tapestry.annotations.InitialValue;
import org.apache.tapestry.annotations.Persist;
import org.apache.tapestry.annotations.SecondaryAnnotationWorker;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IPropertySpecification;
import org.apache.tapestry.spec.PropertySpecification;

public class InitialValueAnnotationWorker
implements SecondaryAnnotationWorker {
    public boolean canEnhance(Method method) {
        return method.getAnnotation(InitialValue.class) != null;
    }

    public void peformEnhancement(EnhancementOperation op, IComponentSpecification spec, Method method, Resource classResource) {
        InitialValue iv = method.getAnnotation(InitialValue.class);
        if (iv == null) {
            return;
        }
        if (method.getAnnotation(Persist.class) != null) {
            return;
        }
        Location location = AnnotationUtils.buildLocationForAnnotation(method, iv, classResource);
        String propertyName = AnnotationUtils.getPropertyName(method);
        PropertySpecification pspec = new PropertySpecification();
        pspec.setName(propertyName);
        pspec.setLocation(location);
        pspec.setInitialValue(iv.value());
        spec.addPropertySpecification((IPropertySpecification)pspec);
    }
}

