/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.annotations;

import java.lang.reflect.Method;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.MethodSignature;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.annotations.AnnotationMessages;
import org.apache.tapestry.annotations.AnnotationUtils;
import org.apache.tapestry.annotations.Message;
import org.apache.tapestry.annotations.MethodAnnotationEnhancementWorker;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.spec.IComponentSpecification;

public class MessageAnnotationWorker
implements MethodAnnotationEnhancementWorker {
    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec, Method method) {
        if (!method.getReturnType().equals(String.class)) {
            throw new ApplicationRuntimeException(AnnotationMessages.returnStringOnly(method.getReturnType()));
        }
        Message message = method.getAnnotation(Message.class);
        String keyName = message.value();
        if (keyName.equals("")) {
            keyName = this.convertMethodNameToKeyName(method.getName());
        }
        BodyBuilder builder = new BodyBuilder();
        builder.add("return getMessages().");
        Object[] parameterTypes = method.getParameterTypes();
        int paramCount = Tapestry.size((Object[])parameterTypes);
        builder.add(paramCount == 0 ? "getMessage" : "format");
        builder.add("(\"{0}\"", (Object)keyName);
        for (int i = 0; i < paramCount; ++i) {
            if (i == 0) {
                builder.add(", new java.lang.Object[] { ");
            } else {
                builder.add(", ");
            }
            if (((Class)parameterTypes[i]).isPrimitive()) {
                builder.add("($w) ");
            }
            builder.add("$" + (i + 1));
        }
        if (paramCount > 0) {
            builder.add(" }");
        }
        builder.add(");");
        op.addMethod(1, new MethodSignature(method), builder.toString());
        if (this.isGetter(method)) {
            op.claimProperty(AnnotationUtils.getPropertyName(method));
        }
    }

    boolean isGetter(Method method) {
        return method.getName().startsWith("get") && method.getParameterTypes().length == 0;
    }

    String convertMethodNameToKeyName(String methodName) {
        StringBuffer buffer = new StringBuffer();
        int length = methodName.length();
        boolean atStart = true;
        for (int cursorx = methodName.startsWith("get") ? 3 : 0; cursorx < length; ++cursorx) {
            char ch = methodName.charAt(cursorx);
            if (Character.isUpperCase(ch)) {
                if (!atStart) {
                    buffer.append('-');
                }
                buffer.append(Character.toLowerCase(ch));
            } else {
                buffer.append(ch);
            }
            atStart = false;
        }
        return buffer.toString();
    }
}

