/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.hivemind.impl.MessageFormatter;
import org.apache.hivemind.service.ClassFabUtils;

class AnnotationMessages {
    private static final MessageFormatter _formatter = new MessageFormatter(AnnotationMessages.class, "AnnotationStrings");

    AnnotationMessages() {
    }

    public static String noParametersExpected(Method m) {
        return _formatter.format("no-parameters-expected", (Object)m);
    }

    public static String notAccessor(Method method) {
        return _formatter.format("no-accessor", (Object)method);
    }

    public static String voidAccessor(Method method) {
        return _formatter.format("void-accessor", (Object)method);
    }

    public static String nonVoidMutator(Method method) {
        return _formatter.format("non-void-mutator", (Object)method);
    }

    public static String wrongParameterCount(Method method) {
        return _formatter.format("wrong-parameter-count", (Object)method);
    }

    public static String failureProcessingAnnotation(Annotation annotation, Method method, Throwable cause) {
        return _formatter.format("failure-processing-annotation", (Object)annotation, (Object)method, (Object)cause);
    }

    public static String failureProcessingClassAnnotation(Annotation annotation, Class clazz, Throwable cause) {
        return _formatter.format("failure-processing-class-annotation", (Object)annotation, (Object)clazz.getName(), (Object)cause);
    }

    public static String returnStringOnly(Class returnType) {
        return _formatter.format("return-string-only", (Object)ClassFabUtils.getJavaClassName((Class)returnType));
    }

    public static String bindingWrongFormat(String binding) {
        return _formatter.format("binding-wrong-format", (Object)binding);
    }
}

