/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.hivemind.ErrorLog;
import org.apache.tapestry.annotations.AnnotationMessages;
import org.apache.tapestry.annotations.ClassAnnotationEnhancementWorker;
import org.apache.tapestry.annotations.MethodAnnotationEnhancementWorker;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.enhance.EnhancementWorker;
import org.apache.tapestry.spec.IComponentSpecification;

public class AnnotationEnhancementWorker
implements EnhancementWorker {
    private ErrorLog _errorLog;
    private Map _methodWorkers;
    private Map _classWorkers;

    public void setClassWorkers(Map classWorkers) {
        this._classWorkers = classWorkers;
    }

    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec) {
        Class clazz = op.getBaseClass();
        for (Annotation a : clazz.getAnnotations()) {
            this.performClassEnhancement(op, spec, clazz, a);
        }
        for (Method m : clazz.getMethods()) {
            this.performMethodEnhancement(op, spec, m);
        }
    }

    void performClassEnhancement(EnhancementOperation op, IComponentSpecification spec, Class clazz, Annotation annotation) {
        ClassAnnotationEnhancementWorker worker = (ClassAnnotationEnhancementWorker)this._classWorkers.get(annotation.annotationType());
        if (worker == null) {
            return;
        }
        try {
            worker.performEnhancement(op, spec, clazz);
        }
        catch (Exception ex) {
            this._errorLog.error(AnnotationMessages.failureProcessingClassAnnotation(annotation, clazz, ex), null, (Throwable)ex);
        }
    }

    void performMethodEnhancement(EnhancementOperation op, IComponentSpecification spec, Method method) {
        for (Annotation a : method.getAnnotations()) {
            this.performMethodEnhancement(op, spec, method, a);
        }
    }

    void performMethodEnhancement(EnhancementOperation op, IComponentSpecification spec, Method method, Annotation annotation) {
        MethodAnnotationEnhancementWorker worker = (MethodAnnotationEnhancementWorker)this._methodWorkers.get(annotation.annotationType());
        if (worker == null) {
            return;
        }
        try {
            worker.performEnhancement(op, spec, method);
        }
        catch (Exception ex) {
            this._errorLog.error(AnnotationMessages.failureProcessingAnnotation(annotation, method, ex), null, (Throwable)ex);
        }
    }

    public void setMethodWorkers(Map methodWorkers) {
        this._methodWorkers = methodWorkers;
    }

    public void setErrorLog(ErrorLog errorLog) {
        this._errorLog = errorLog;
    }
}

