/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.format;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.measure.MetricPrefix;
import javax.measure.UnitConverter;
import systems.uom.ucum.format.UCUMFormat;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.function.PowerOfIntConverter;
import tech.units.indriya.spi.NumberSystem;
import tech.units.indriya.unit.AnnotatedUnit;

final class UCUMFormatHelper {
    private static Map<String, UnitConverter> prefixConverterByFactor = null;
    private final UCUMFormat ucumFormat;
    private final AbstractUnit unit;
    private final CharSequence annotation;

    static UCUMFormatHelper of(UCUMFormat ucumFormat, AbstractUnit<?> unit) {
        if (unit instanceof AnnotatedUnit) {
            AnnotatedUnit annotatedUnit = (AnnotatedUnit)unit;
            AbstractUnit actualUnit = (AbstractUnit)annotatedUnit.getActualUnit();
            return new UCUMFormatHelper(ucumFormat, actualUnit, annotatedUnit.getAnnotation());
        }
        return new UCUMFormatHelper(ucumFormat, unit, null);
    }

    private UCUMFormatHelper(UCUMFormat ucumFormat, AbstractUnit unit, CharSequence annotation) {
        this.ucumFormat = ucumFormat;
        this.unit = unit;
        this.annotation = annotation;
    }

    private CharSequence getAnnotation() {
        return this.annotation;
    }

    private boolean hasAnnotation() {
        return this.annotation != null && this.annotation.length() > 0;
    }

    void appendAnnotation(CharSequence symbol, Appendable appendable) throws IOException {
        if (!this.hasAnnotation()) {
            return;
        }
        this.ucumFormat.appendAnnotation(symbol, this.getAnnotation(), appendable);
    }

    public CharSequence findSymbolFor(SymbolProvider[] symbolProviders, AbstractUnit<?> unit) throws IOException {
        for (SymbolProvider symbolProvider : symbolProviders) {
            CharSequence symbol = symbolProvider.symbolFor(unit);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    public static UnitConverter toKnownPrefixConverterIfPossible(UnitConverter converter) {
        if (converter instanceof PowerOfIntConverter) {
            return converter;
        }
        if (converter instanceof MultiplyConverter) {
            UCUMFormatHelper.ensurePrefixConverterMapInitialized();
            MultiplyConverter multiplyConverter = (MultiplyConverter)converter;
            NumberSystem ns = Calculus.currentNumberSystem();
            Number factor = ns.narrow(multiplyConverter.getFactor());
            String key = factor.toString();
            return prefixConverterByFactor.getOrDefault(key, converter);
        }
        return converter;
    }

    private static void ensurePrefixConverterMapInitialized() {
        if (prefixConverterByFactor != null) {
            return;
        }
        prefixConverterByFactor = new HashMap<String, UnitConverter>();
        NumberSystem ns = Calculus.currentNumberSystem();
        for (MetricPrefix metricPrefix : MetricPrefix.values()) {
            if (metricPrefix == MetricPrefix.DECA) continue;
            MultiplyConverter prefixConverter = MultiplyConverter.ofExponent((int)10, (int)metricPrefix.getExponent());
            Number factor = ns.narrow(prefixConverter.getFactor());
            String key = factor.toString();
            prefixConverterByFactor.put(key, (UnitConverter)prefixConverter);
        }
    }

    static interface SymbolProvider {
        public CharSequence symbolFor(AbstractUnit<?> var1) throws IOException;
    }
}

