/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.format;

import java.math.BigInteger;
import javax.measure.Prefix;
import javax.measure.UnitConverter;
import tech.units.indriya.format.SymbolMap;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.function.RationalConverter;

class UCUMConverterFormatter {
    UCUMConverterFormatter() {
    }

    static void formatConverter(UnitConverter converter, boolean continued, StringBuilder buffer, SymbolMap symbolMap) {
        boolean unitIsExpression = buffer.indexOf(".") >= 0 || buffer.indexOf("/") >= 0;
        Prefix prefix = symbolMap.getPrefix(converter);
        if (prefix != null && !unitIsExpression) {
            buffer.insert(0, symbolMap.getSymbol(prefix));
        } else if (converter != AbstractConverter.IDENTITY) {
            if (converter instanceof RationalConverter) {
                RationalConverter rationalConverter;
                if (unitIsExpression) {
                    buffer.insert(0, '(');
                    buffer.append(')');
                }
                if (!(rationalConverter = (RationalConverter)converter).getDividend().equals(BigInteger.ONE)) {
                    if (continued) {
                        buffer.append('.');
                    }
                    buffer.append(rationalConverter.getDividend());
                }
                if (!rationalConverter.getDivisor().equals(BigInteger.ONE)) {
                    buffer.append('/');
                    buffer.append(rationalConverter.getDivisor());
                }
            } else if (converter instanceof MultiplyConverter) {
                MultiplyConverter multiplyConverter;
                long lFactor;
                if (unitIsExpression) {
                    buffer.insert(0, '(');
                    buffer.append(')');
                }
                if ((lFactor = (multiplyConverter = (MultiplyConverter)converter).getFactor().longValue()) < Long.MIN_VALUE || lFactor > Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Only integer factors are supported in UCUM");
                }
                if (continued) {
                    buffer.append('.');
                }
                buffer.append(lFactor);
            } else {
                buffer.insert(0, converter.toString() + "(");
                buffer.append(")");
            }
        }
    }
}

