/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.format;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.ParsePosition;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.measure.MetricPrefix;
import javax.measure.Prefix;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.MeasurementParseException;
import si.uom.SI;
import systems.uom.ucum.format.UCUMConverterFormatter;
import systems.uom.ucum.format.UCUMFormatHelper;
import systems.uom.ucum.internal.format.UCUMFormatParser;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.ComparableUnit;
import tech.units.indriya.format.AbstractUnitFormat;
import tech.units.indriya.format.SymbolMap;
import tech.units.indriya.format.TokenException;
import tech.units.indriya.format.TokenMgrError;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.unit.TransformedUnit;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class UCUMFormat
extends AbstractUnitFormat {
    private static final String BUNDLE_BASE = UCUMFormat.class.getName();
    final SymbolMap symbolMap;
    private final UCUMFormatHelper.SymbolProvider[] symbolProviders = new UCUMFormatHelper.SymbolProvider[]{this::symbolFromLookupMap, this::symbolForTransformedUnit, this::symbolForKilogram, this::symbolForProductUnits, this::symbolForNonSystemUnit, this::symbolFromField};

    public static UCUMFormat getInstance(Variant variant) {
        switch (variant) {
            case CASE_INSENSITIVE: {
                return Parsing.DEFAULT_CI;
            }
            case CASE_SENSITIVE: {
                return Parsing.DEFAULT_CS;
            }
            case PRINT: {
                return Print.DEFAULT;
            }
        }
        throw new IllegalArgumentException("Unknown variant: " + variant);
    }

    public static UCUMFormat getInstance(Variant variant, SymbolMap symbolMap) {
        switch (variant) {
            case CASE_INSENSITIVE: {
                return new Parsing(symbolMap, false);
            }
            case CASE_SENSITIVE: {
                return new Parsing(symbolMap, true);
            }
            case PRINT: {
                return new Print(symbolMap);
            }
        }
        throw new IllegalArgumentException("Unknown variant: " + variant);
    }

    protected SymbolMap getSymbols() {
        return this.symbolMap;
    }

    UCUMFormat(SymbolMap symbolMap) {
        this.symbolMap = symbolMap;
    }

    public abstract Unit<? extends Quantity<?>> parse(CharSequence var1, ParsePosition var2) throws MeasurementParseException;

    protected Unit<?> parse(CharSequence csq, int index) throws MeasurementParseException {
        return this.parse(csq, new ParsePosition(index));
    }

    public abstract Unit<? extends Quantity<?>> parse(CharSequence var1) throws MeasurementParseException;

    public Appendable format(Unit<?> unknownUnit, Appendable appendable) throws IOException {
        if (!(unknownUnit instanceof ComparableUnit)) {
            throw new UnsupportedOperationException("The UCUM format supports only known units (Comparable units)");
        }
        ComparableUnit unit = (ComparableUnit)unknownUnit;
        UCUMFormatHelper formatHelper = UCUMFormatHelper.of(this, unit);
        CharSequence symbol = formatHelper.findSymbolFor(this.symbolProviders, unit);
        if (symbol == null) {
            throw new IllegalArgumentException("Cannot format the given Object as UCUM units (unsupported unit " + unit.getClass().getName() + "). Custom units types should override the toString() method as the default implementation uses the UCUM format.");
        }
        appendable.append(symbol);
        formatHelper.appendAnnotation(symbol, appendable);
        return appendable;
    }

    private CharSequence symbolFromLookupMap(ComparableUnit<?> unit) throws IOException {
        return this.symbolMap.getSymbol(unit);
    }

    private CharSequence symbolFromField(ComparableUnit<?> unit) throws IOException {
        return unit.getSymbol();
    }

    private CharSequence symbolForTransformedUnit(ComparableUnit unit) throws IOException {
        boolean printSeparator;
        if (!(unit instanceof TransformedUnit)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Unit parentUnit = ((TransformedUnit)unit).getParentUnit();
        UnitConverter converter = UCUMFormatHelper.toKnownPrefixConverterIfPossible(unit.getConverterTo(parentUnit));
        boolean bl = printSeparator = !parentUnit.equals(AbstractUnit.ONE);
        if (printSeparator && converter instanceof MultiplyConverter) {
            this.format(parentUnit, sb);
        }
        UCUMConverterFormatter.formatConverter(converter, printSeparator, sb, this.symbolMap);
        return sb;
    }

    private CharSequence symbolForProductUnits(ComparableUnit unit) throws IOException {
        Map productUnits = unit.getBaseUnits();
        if (productUnits == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<AbstractUnit, Integer> numeratorUnits = new LinkedHashMap<AbstractUnit, Integer>();
        LinkedHashMap<AbstractUnit, Integer> denominatorUnits = new LinkedHashMap<AbstractUnit, Integer>();
        for (Map.Entry u : productUnits.entrySet()) {
            if ((Integer)u.getValue() > 0) {
                numeratorUnits.put((AbstractUnit)u.getKey(), (Integer)u.getValue());
                continue;
            }
            denominatorUnits.put((AbstractUnit)u.getKey(), (Integer)u.getValue());
        }
        int numeratorCount = 1;
        for (Map.Entry entry : numeratorUnits.entrySet()) {
            if (numeratorCount > 1) {
                sb.append(".");
            }
            this.format((Unit)entry.getKey(), sb);
            if ((Integer)entry.getValue() > 1) {
                sb.append(entry.getValue());
            }
            ++numeratorCount;
        }
        if (numeratorCount == 1) {
            sb.append("1");
        }
        if (denominatorUnits.size() > 0) {
            sb.append("/");
            int denominatorCount = 1;
            for (Map.Entry u : denominatorUnits.entrySet()) {
                if (denominatorCount == 1 && denominatorUnits.size() > 1) {
                    sb.append("(");
                }
                if (denominatorCount > 1) {
                    sb.append(".");
                }
                this.format((Unit)u.getKey(), sb);
                if (Math.abs((Integer)u.getValue()) < -1) {
                    sb.append(-((Integer)u.getValue()).intValue());
                }
                if (denominatorCount == denominatorUnits.size() && denominatorUnits.size() > 1) {
                    sb.append(")");
                }
                ++denominatorCount;
            }
        }
        return sb;
    }

    private CharSequence symbolForKilogram(ComparableUnit unit) throws IOException {
        Unit systemUnit = unit.getSystemUnit();
        if (!systemUnit.equals(SI.KILOGRAM)) {
            return null;
        }
        UnitConverter converter = UCUMFormatHelper.toKnownPrefixConverterIfPossible(unit.getConverterTo(systemUnit).concatenate((UnitConverter)MultiplyConverter.ofPrefix((Prefix)MetricPrefix.KILO)));
        StringBuilder sb = new StringBuilder();
        boolean printSeparator = true;
        this.format(SI.GRAM, sb);
        UCUMConverterFormatter.formatConverter(converter, true, sb, this.symbolMap);
        return sb;
    }

    private CharSequence symbolForNonSystemUnit(ComparableUnit unit) throws IOException {
        if (unit.isSystemUnit()) {
            return null;
        }
        Unit parentUnit = unit.getSystemUnit();
        UnitConverter converter = unit.getConverterTo(parentUnit);
        StringBuilder sb = new StringBuilder();
        boolean printSeparator = !AbstractUnit.ONE.equals(parentUnit);
        this.format(parentUnit, sb);
        UCUMConverterFormatter.formatConverter(converter, printSeparator, sb, this.symbolMap);
        return sb;
    }

    public void label(Unit<?> unit, String label) {
        throw new UnsupportedOperationException("label() not supported by this implementation");
    }

    public boolean isLocaleSensitive() {
        return false;
    }

    void appendAnnotation(CharSequence symbol, CharSequence annotation, Appendable appendable) throws IOException {
        appendable.append('{');
        appendable.append(annotation);
        appendable.append('}');
    }

    static /* synthetic */ String access$300() {
        return BUNDLE_BASE;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Parsing
    extends UCUMFormat {
        private static final SymbolMap CASE_SENSITIVE_SYMBOLS = SymbolMap.of((ResourceBundle)ResourceBundle.getBundle(UCUMFormat.access$300() + "_CS", UCUMFormat.class.getModule()));
        private static final SymbolMap CASE_INSENSITIVE_SYMBOLS = SymbolMap.of((ResourceBundle)ResourceBundle.getBundle(UCUMFormat.access$300() + "_CI", UCUMFormat.class.getModule()));
        private static final Parsing DEFAULT_CS = new Parsing(CASE_SENSITIVE_SYMBOLS, true);
        private static final Parsing DEFAULT_CI = new Parsing(CASE_INSENSITIVE_SYMBOLS, false);
        private final boolean caseSensitive;

        public Parsing(SymbolMap symbols, boolean caseSensitive) {
            super(symbols);
            this.caseSensitive = caseSensitive;
        }

        @Override
        public Unit<? extends Quantity<?>> parse(CharSequence csq, ParsePosition cursor) throws MeasurementParseException {
            int start = cursor.getIndex();
            int end = csq.length();
            if (end <= start) {
                return AbstractUnit.ONE;
            }
            String source = csq.subSequence(start, end).toString().trim();
            if (source.length() == 0) {
                return AbstractUnit.ONE;
            }
            if (!this.caseSensitive) {
                source = source.toUpperCase();
            }
            UCUMFormatParser parser = new UCUMFormatParser(this.symbolMap, new ByteArrayInputStream(source.getBytes()));
            try {
                Unit result = parser.parseUnit();
                cursor.setIndex(end);
                return result;
            }
            catch (TokenException e) {
                if (e.currentToken != null) {
                    cursor.setErrorIndex(start + e.currentToken.endColumn);
                } else {
                    cursor.setErrorIndex(start);
                }
                throw new MeasurementParseException((Throwable)e);
            }
            catch (TokenMgrError e) {
                cursor.setErrorIndex(start);
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        @Override
        public Unit<? extends Quantity<?>> parse(CharSequence csq) throws MeasurementParseException {
            return this.parse(csq, new ParsePosition(0));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Print
    extends UCUMFormat {
        private static final SymbolMap PRINT_SYMBOLS = SymbolMap.of((ResourceBundle)ResourceBundle.getBundle(UCUMFormat.access$300() + "_Print"));
        private static final Print DEFAULT = new Print(PRINT_SYMBOLS);

        public Print(SymbolMap symbols) {
            super(symbols);
        }

        @Override
        public Unit<? extends Quantity<?>> parse(CharSequence csq, ParsePosition pos) throws IllegalArgumentException {
            throw new UnsupportedOperationException("The print format is for pretty-printing of units only. Parsing is not supported.");
        }

        @Override
        void appendAnnotation(CharSequence symbol, CharSequence annotation, Appendable appendable) throws IOException {
            if (symbol != null && symbol.length() > 0) {
                appendable.append('(');
                appendable.append(annotation);
                appendable.append(')');
            } else {
                appendable.append(annotation);
            }
        }

        @Override
        public Unit<? extends Quantity<?>> parse(CharSequence csq) throws IllegalArgumentException {
            return this.parse(csq, new ParsePosition(0));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Variant {
        CASE_SENSITIVE,
        CASE_INSENSITIVE,
        PRINT;

    }
}

