/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.format;

import java.math.BigInteger;
import javax.measure.UnitConverter;
import tec.units.indriya.AbstractConverter;
import tec.units.indriya.format.SymbolMap;
import tec.units.indriya.function.MultiplyConverter;
import tec.units.indriya.function.RationalConverter;
import tec.units.indriya.unit.MetricPrefix;

class UCUMConverterFormatter {
    UCUMConverterFormatter() {
    }

    static void formatConverter(UnitConverter converter, boolean continued, StringBuilder buffer, SymbolMap symbolMap) {
        boolean unitIsExpression = buffer.indexOf(".") >= 0 || buffer.indexOf("/") >= 0;
        MetricPrefix prefix = symbolMap.getPrefix(converter);
        if (prefix != null && !unitIsExpression) {
            buffer.insert(0, symbolMap.getSymbol(prefix));
        } else if (converter != AbstractConverter.IDENTITY) {
            if (converter instanceof MultiplyConverter) {
                MultiplyConverter multiplyConverter;
                double factor;
                long lFactor;
                if (unitIsExpression) {
                    buffer.insert(0, '(');
                    buffer.append(')');
                }
                if ((lFactor = (long)(factor = (multiplyConverter = (MultiplyConverter)converter).getFactor())) < Long.MIN_VALUE || lFactor > Long.MAX_VALUE) {
                    throw new IllegalArgumentException("Only integer factors are supported in UCUM");
                }
                if (continued) {
                    buffer.append('.');
                }
                buffer.append(lFactor);
            } else if (converter instanceof RationalConverter) {
                RationalConverter rationalConverter;
                if (unitIsExpression) {
                    buffer.insert(0, '(');
                    buffer.append(')');
                }
                if (!(rationalConverter = (RationalConverter)converter).getDividend().equals(BigInteger.ONE)) {
                    if (continued) {
                        buffer.append('.');
                    }
                    buffer.append(rationalConverter.getDividend());
                }
                if (!rationalConverter.getDivisor().equals(BigInteger.ONE)) {
                    buffer.append('/');
                    buffer.append(rationalConverter.getDivisor());
                }
            } else {
                buffer.insert(0, converter.toString() + "(");
                buffer.append(")");
            }
        }
    }
}

