/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.common.historic;

import java.util.Set;
import javax.measure.MetricPrefix;
import javax.measure.Unit;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import si.uom.quantity.IonizingRadiation;
import systems.uom.common.USCustomary;
import tech.units.indriya.AbstractSystemOfUnits;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.unit.Units;

public final class ObsoleteUnits
extends AbstractSystemOfUnits {
    private static final String SYSTEM_NAME = "Obsolete Units";
    private static final ObsoleteUnits INSTANCE = new ObsoleteUnits();
    public static final Unit<Dimensionless> PI = ObsoleteUnits.addUnit(AbstractUnit.ONE.multiply(Math.PI), "Pi", "pi");
    public static final Unit<Length> ANGSTROM = ObsoleteUnits.addUnit(Units.METRE.divide(1.0E10), "\u00c5ngstr\u00f6m", "\u00c5");
    public static final Unit<Length> LIGHT_YEAR = ObsoleteUnits.addUnit(Units.METRE.multiply(9.460528405E15), "Light year", "ly");
    public static final Unit<Length> PARSEC = ObsoleteUnits.addUnit(Units.METRE.multiply(3.085677E16), "Parsec", "pc");
    public static final Unit<Length> NAUTICAL_MILE = ObsoleteUnits.addUnit(Units.METRE.multiply(1852.0), "Nautical mile", "nmi");
    public static final Unit<Length> BOHR_RADIUS = ObsoleteUnits.addUnit(Units.METRE.multiply(5.291772106712E-11), "Bohr Radius", "a0");
    public static final Unit<Length> PIED = ObsoleteUnits.addUnit(Units.METRE.multiply(0.3), "Pied", "pied");
    public static final Unit<Length> LIGNE = ObsoleteUnits.addUnit(PIED.divide(144.0), "Ligne", "ligne");
    public static final Unit<Length> TOISE = ObsoleteUnits.addUnit(LIGNE.multiply(864.0), "Toise", "T");
    public static final Unit<Length> ROD = ObsoleteUnits.addUnit(Units.METRE.multiply(5.0292), "Rod", "rod");
    public static final Unit<Length> SPAT = ObsoleteUnits.addUnit(MetricPrefix.KILO((Unit)Units.METRE).multiply(1.0E9), "Spat", "S");
    public static final Unit<Mass> PENNYWEIGHT = ObsoleteUnits.addUnit(Units.GRAM.multiply(1.55517384), "Pennyweight", "dwt");
    public static final Unit<Radioactivity> CURIE = ObsoleteUnits.addUnit(Units.BECQUEREL.multiply(3.7E10), "Curie", "Ci");
    public static final Unit<IonizingRadiation> ROENTGEN = ObsoleteUnits.addUnit(Units.COULOMB.divide(Units.KILOGRAM).multiply(2.58E-4).asType(IonizingRadiation.class), "Roentgen", "R", true);
    public static final Unit<SolidAngle> SPHERE = ObsoleteUnits.addUnit(Units.STERADIAN.multiply(4.0).multiply(PI).asType(SolidAngle.class), "Sphere", "sphere");
    public static final Unit<Temperature> REAUMUR = ObsoleteUnits.addUnit(Units.CELSIUS.multiply(1.25), "R\u00e9aumur", "\u00b0R\u00e9");
    public static final Unit<Time> DAY_SIDEREAL = ObsoleteUnits.addUnit(Units.SECOND.multiply(86164.09), "Day Sidereal", "day_sidereal");
    public static final Unit<Time> YEAR_SIDEREAL = ObsoleteUnits.addUnit(Units.SECOND.multiply(3.155814954E7), "Year Sidereal", "year_sidereal");
    public static final Unit<Time> YEAR_JULIEN = ObsoleteUnits.addUnit(Units.SECOND.multiply(3.15576E7), "Year Julien", "year_julien");
    public static final Unit<Volume> SHIPPING_TON_US = ObsoleteUnits.addUnit(USCustomary.CUBIC_FOOT.multiply(40.0), "Shipping Ton (US)", "sh_ton_us");
    public static final Unit<Volume> SHIPPING_TON_UK = ObsoleteUnits.addUnit(USCustomary.CUBIC_FOOT.multiply(42.0), "Shipping Ton (UK)", "sh_ton_uk");

    private ObsoleteUnits() {
    }

    public static ObsoleteUnits getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return SYSTEM_NAME;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text, boolean isLabel) {
        if (isLabel && text != null) {
            SimpleUnitFormat.getInstance().label(unit, text);
        }
        if (name != null && unit instanceof AbstractUnit) {
            return (U)AbstractSystemOfUnits.Helper.addUnit((Set)ObsoleteUnits.INSTANCE.units, unit, (String)name);
        }
        ObsoleteUnits.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text) {
        return ObsoleteUnits.addUnit(unit, name, text, true);
    }
}

