/*
 * Decompiled with CFR 0.152.
 */
package manifold.util;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import manifold.util.JreUtil;
import manifold.util.ManExceptionUtil;
import manifold.util.MethodScore;
import manifold.util.MethodScorer;
import manifold.util.NecessaryEvilUtil;
import manifold.util.concurrent.ConcurrentHashSet;
import manifold.util.concurrent.ConcurrentWeakHashMap;
import manifold.util.concurrent.LocklessLazyVar;

public class ReflectUtil {
    private static final ConcurrentWeakHashMap<Class, ConcurrentMap<String, ConcurrentHashSet<Method>>> _methodsByName = new ConcurrentWeakHashMap();
    private static final ConcurrentWeakHashMap<Class, ConcurrentMap<String, Field>> _fieldsByName = new ConcurrentWeakHashMap();
    private static final ConcurrentWeakHashMap<Class, Set<Constructor>> _constructorsByClass = new ConcurrentWeakHashMap();
    private static final ConcurrentWeakHashMap<Method, ConcurrentMap<Class, Method>> _structuralCall = new ConcurrentWeakHashMap();
    private static final LocklessLazyVar<ClassContextSecurityManager> _sm = LocklessLazyVar.make(() -> new ClassContextSecurityManager());
    private static final String LAMBDA_METHOD = "lambda method";
    private static final Object UNHANDLED = new Object(){};
    private static final LocklessLazyVar<Long> _overrideOffset = LocklessLazyVar.make(() -> {
        try {
            Field overrideField = FakeAccessibleObject.class.getDeclaredField("override");
            return NecessaryEvilUtil.getUnsafe().objectFieldOffset(overrideField);
        }
        catch (Exception e) {
            throw ManExceptionUtil.unchecked(e);
        }
    });
    private static final LocklessLazyVar<Method> _getDeclaredMethods0 = LocklessLazyVar.make(() -> {
        if (JreUtil.isJava12orLater()) {
            try {
                Method getDeclaredMethods0 = Class.class.getDeclaredMethod("getDeclaredMethods0", Boolean.TYPE);
                ReflectUtil.setAccessible(getDeclaredMethods0);
                return getDeclaredMethods0;
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }
        throw new IllegalStateException("This field should only be used with JDK version 12 or later.");
    });
    private static final LocklessLazyVar<Method> _copyMethod = LocklessLazyVar.make(() -> {
        if (JreUtil.isJava12orLater()) {
            try {
                Method copy = Method.class.getDeclaredMethod("copy", new Class[0]);
                ReflectUtil.setAccessible(copy);
                return copy;
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }
        throw new IllegalStateException("This field should only be used with JDK version 12 or later.");
    });
    private static final LocklessLazyVar<Method> _getDeclaredFields0 = LocklessLazyVar.make(() -> {
        if (JreUtil.isJava12orLater()) {
            try {
                Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                ReflectUtil.setAccessible(getDeclaredFields0);
                return getDeclaredFields0;
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }
        throw new IllegalStateException("This field should only be used with JDK version 12 or later.");
    });
    private static final LocklessLazyVar<Method> _copyField = LocklessLazyVar.make(() -> {
        if (JreUtil.isJava12orLater()) {
            try {
                Method copy = Field.class.getDeclaredMethod("copy", new Class[0]);
                ReflectUtil.setAccessible(copy);
                return copy;
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }
        throw new IllegalStateException("This field should only be used with JDK version 12 or later.");
    });

    public static Class<?> type(String fqn) {
        return ReflectUtil.type(fqn, false);
    }

    public static Class<?> type(String fqn, boolean useCallChain) {
        return ReflectUtil.type(fqn, ReflectUtil.class.getClassLoader(), useCallChain);
    }

    public static Class<?> type(String fqn, ClassLoader cl) {
        return ReflectUtil.type(fqn, cl, false);
    }

    public static Class<?> type(String fqn, ClassLoader cl, boolean useCallChain) {
        Class<?> cls;
        int dims = 0;
        int iBracket = fqn.indexOf(91);
        String componentFqn = fqn;
        if (iBracket > 0) {
            dims = (fqn.length() - iBracket) / 2;
            componentFqn = fqn.substring(0, iBracket);
        }
        try {
            cls = ReflectUtil.classForPrimitiveName(componentFqn);
            if (cls == null) {
                cls = Class.forName(componentFqn, false, cl);
            }
        }
        catch (ClassNotFoundException e) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (cl != contextClassLoader && contextClassLoader != null) {
                return ReflectUtil.type(fqn, contextClassLoader, useCallChain);
            }
            Class<?> clazz = cls = useCallChain ? ReflectUtil.findInCallChain(fqn) : null;
        }
        if (cls != null && dims > 0) {
            cls = Array.newInstance(cls, new int[dims]).getClass();
        }
        return cls;
    }

    private static Class<?> classForPrimitiveName(String type) {
        switch (type) {
            case "void": {
                return Void.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
        }
        return null;
    }

    private static Class<?> findInCallChain(String fqn) {
        Class[] stackTraceClasses = Objects.requireNonNull(_sm.get()).getClassContext();
        if (stackTraceClasses == null) {
            return null;
        }
        HashSet<ClassLoader> attempted = new HashSet<ClassLoader>();
        attempted.add(ReflectUtil.class.getClassLoader());
        attempted.add(Thread.currentThread().getContextClassLoader());
        for (Class cls : stackTraceClasses) {
            ClassLoader cl = cls.getClassLoader();
            if (attempted.contains(cl)) continue;
            attempted.add(cl);
            return ReflectUtil.type(fqn, cl, false);
        }
        return null;
    }

    public static LiveMethodRef method(Object receiver, String name, Class ... params) {
        LiveMethodRef liveRef = WithNull.method(receiver, name, params);
        if (liveRef == null) {
            throw new RuntimeException("Method '" + name + "' not found");
        }
        return liveRef;
    }

    public static MethodRef method(String fqn, String name, Class ... params) {
        return ReflectUtil.method(ReflectUtil.type(fqn), name, params);
    }

    public static MethodRef method(Class<?> cls, String name, Class ... params) {
        return ReflectUtil._method(cls, name, params);
    }

    private static MethodRef _method(Class<?> cls, String name, Class ... params) {
        MethodRef match = ReflectUtil.matchFirstMethod(cls, name, params);
        if (match != null) {
            return match;
        }
        MethodRef mr = ReflectUtil.getMethodFromCache(cls, name, params);
        if (mr != null) {
            return mr;
        }
        try {
            Method method = ReflectUtil.getDeclaredMethod(cls, name, params);
            return ReflectUtil.addMethodToCache(cls, method);
        }
        catch (Exception e) {
            Class<?> superclass = cls.getSuperclass();
            if (superclass != null && (mr = ReflectUtil._method(superclass, name, params)) != null) {
                ReflectUtil.addMethodToCache(cls, mr._method);
                return mr;
            }
            for (Class<?> iface : cls.getInterfaces()) {
                mr = ReflectUtil._method(iface, name, params);
                if (mr == null) continue;
                ReflectUtil.addMethodToCache(cls, mr._method);
                return mr;
            }
            return null;
        }
    }

    private static Method[] getDeclaredMethods(Class<?> cls) {
        if (!JreUtil.isJava12orLater()) {
            return cls.getDeclaredMethods();
        }
        try {
            return (Method[])_getDeclaredMethods0.get().invoke(cls, false);
        }
        catch (Exception e) {
            throw ManExceptionUtil.unchecked(e);
        }
    }

    private static Method getDeclaredMethod(Class<?> cls, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        if (!JreUtil.isJava12orLater()) {
            return cls.getDeclaredMethod(name, parameterTypes);
        }
        try {
            Method[] methods = (Method[])_getDeclaredMethods0.get().invoke(cls, false);
            Method res = null;
            for (Method m : methods) {
                if (!m.getName().equals(name) || !ReflectUtil.sameParameters(parameterTypes, m.getParameterTypes()) || res != null && !res.getReturnType().isAssignableFrom(m.getReturnType())) continue;
                res = m;
            }
            if (res == null) {
                throw new NoSuchMethodException();
            }
            return (Method)_copyMethod.get().invoke(res, new Object[0]);
        }
        catch (Exception e) {
            throw ManExceptionUtil.unchecked(e);
        }
    }

    private static boolean sameParameters(Class<?>[] params1, Class<?>[] params2) {
        if (params1 == null) {
            return params2 == null || params2.length == 0;
        }
        if (params2 == null) {
            return params1.length == 0;
        }
        if (params1.length != params2.length) {
            return false;
        }
        for (int i = 0; i < params1.length; ++i) {
            if (params1[i] == params2[i]) continue;
            return false;
        }
        return true;
    }

    public static MethodRef methodFromName(Class<?> cls, String name) {
        MethodRef mr = ReflectUtil.getMethodFromCacheUsingNameOnly(cls, name);
        if (mr != null) {
            return mr;
        }
        for (Method method : ReflectUtil.getDeclaredMethods(cls)) {
            if (!method.getName().equals(name)) continue;
            return ReflectUtil.addMethodToCache(cls, method);
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null && (mr = ReflectUtil.methodFromName(superclass, name)) != null) {
            ReflectUtil.addMethodToCache(cls, mr._method);
            return mr;
        }
        for (Class<?> iface : cls.getInterfaces()) {
            mr = ReflectUtil.methodFromName(iface, name);
            if (mr == null) continue;
            ReflectUtil.addMethodToCache(cls, mr._method);
            return mr;
        }
        return null;
    }

    public static MethodRef lambdaMethod(Class<?> lambdaClass) {
        MethodRef mr = ReflectUtil.getMethodFromCacheUsingNameOnly(lambdaClass, LAMBDA_METHOD);
        if (mr != null) {
            return mr;
        }
        for (Class<?> iface : lambdaClass.getInterfaces()) {
            for (Method m : iface.getMethods()) {
                if ((m.getModifiers() & 0x401) != 1025) continue;
                return ReflectUtil.addMethodToCache(lambdaClass, m, LAMBDA_METHOD);
            }
        }
        return null;
    }

    public static Object invokeDefault(Object receiver, Method method, Object ... args) {
        try {
            ReflectUtil.fakeProxyStructuralArgs(method, args);
            Class<?> declaringInterface = method.getDeclaringClass();
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)ReflectUtil.constructor(MethodHandles.Lookup.class, Class.class).newInstance(declaringInterface);
            return lookup.in(declaringInterface).unreflectSpecial(method, declaringInterface).bindTo(receiver).invokeWithArguments(args);
        }
        catch (Throwable t) {
            throw ManExceptionUtil.unchecked(t);
        }
    }

    private static void fakeProxyStructuralArgs(Method method, Object[] args) {
        if (args != null && args.length > 0) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            block0: for (int i = 0; i < args.length; ++i) {
                Object arg = args[0];
                if (arg == null) continue;
                for (Annotation anno : parameterTypes[i].getAnnotations()) {
                    if (!anno.annotationType().getTypeName().equals("manifold.ext.rt.api.Structural")) continue;
                    args[0] = Proxy.newProxyInstance(parameterTypes[i].getClassLoader(), new Class[]{parameterTypes[i]}, (InvocationHandler)new FakeProxy(arg));
                    continue block0;
                }
            }
        }
    }

    private static MethodRef matchFirstMethod(Class<?> cls, String name, Class[] params) {
        if (name.indexOf(124) >= 0) {
            StringTokenizer tokenizer = new StringTokenizer(name, "|");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                MethodRef method = ReflectUtil.method(cls, token, params);
                if (method == null) continue;
                return method;
            }
        }
        return null;
    }

    public static LiveFieldRef field(Object receiver, String name) {
        LiveFieldRef liveRef = WithNull.field(receiver, name);
        if (liveRef == null) {
            throw new RuntimeException("Field '" + name + "' not found");
        }
        return liveRef;
    }

    public static FieldRef field(String fqn, String name) {
        return ReflectUtil.field(ReflectUtil.type(fqn), name);
    }

    public static FieldRef field(Class<?> cls, String name) {
        return ReflectUtil._field(cls, name);
    }

    private static FieldRef _field(Class<?> cls, String name) {
        FieldRef match = ReflectUtil.matchFirstField(cls, name);
        if (match != null) {
            return match;
        }
        FieldRef fr = ReflectUtil.getFieldFromCache(cls, name);
        if (fr != null) {
            return fr;
        }
        try {
            Field field = ReflectUtil.getDeclaredField(cls, name);
            return ReflectUtil.addFieldToCache(cls, field);
        }
        catch (Exception e) {
            Class<?> superclass = cls.getSuperclass();
            if (superclass != null && (fr = ReflectUtil._field(superclass, name)) != null) {
                ReflectUtil.addFieldToCache(cls, fr._field);
                return fr;
            }
            for (Class<?> iface : cls.getInterfaces()) {
                fr = ReflectUtil._field(iface, name);
                if (fr == null) continue;
                ReflectUtil.addFieldToCache(cls, fr._field);
                return fr;
            }
            return null;
        }
    }

    private static Field getDeclaredField(Class<?> cls, String name) throws NoSuchFieldException {
        if (!JreUtil.isJava12orLater()) {
            return cls.getDeclaredField(name);
        }
        try {
            Field[] fields = (Field[])_getDeclaredFields0.get().invoke(cls, false);
            Field res = null;
            for (Field field : fields) {
                if (!field.getName().equals(name)) continue;
                res = field;
                break;
            }
            if (res == null) {
                throw new NoSuchFieldException();
            }
            return (Field)_copyField.get().invoke(res, new Object[0]);
        }
        catch (Exception e) {
            throw ManExceptionUtil.unchecked(e);
        }
    }

    private static FieldRef matchFirstField(Class<?> cls, String name) {
        if (name.indexOf(124) >= 0) {
            StringTokenizer tokenizer = new StringTokenizer(name, "|");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                FieldRef field = ReflectUtil.field(cls, token);
                if (field == null) continue;
                return field;
            }
        }
        return null;
    }

    public static ConstructorRef constructor(String fqn, Class<?> ... params) {
        return ReflectUtil.constructor(ReflectUtil.type(fqn), params);
    }

    public static ConstructorRef constructor(Class<?> cls, Class<?> ... params) {
        ConstructorRef mr = ReflectUtil.getConstructorFromCache(cls, params);
        if (mr != null) {
            return mr;
        }
        try {
            Constructor<?> constructor = cls.getDeclaredConstructor(params);
            return ReflectUtil.addConstructorToCache(cls, constructor);
        }
        catch (Exception e) {
            Class<?> superclass = cls.getSuperclass();
            if (superclass != null && (mr = ReflectUtil.constructor(superclass, params)) != null) {
                return mr;
            }
            for (Class<?> iface : cls.getInterfaces()) {
                mr = ReflectUtil.constructor(iface, params);
                if (mr == null) continue;
                ReflectUtil.addConstructorToCache(cls, mr._constructor);
                return mr;
            }
            return null;
        }
    }

    public static void setAccessible(Field f) {
        try {
            f.setAccessible(true);
        }
        catch (Exception e) {
            ReflectUtil.setAccessible((Member)f);
        }
    }

    public static void setAccessible(Method m) {
        try {
            m.setAccessible(true);
        }
        catch (Exception e) {
            ReflectUtil.setAccessible((Member)m);
        }
    }

    public static void setAccessible(Constructor c) {
        try {
            c.setAccessible(true);
        }
        catch (Exception e) {
            ReflectUtil.setAccessible((Member)c);
        }
    }

    public static void setAccessible(Member m) {
        try {
            NecessaryEvilUtil.getUnsafe().putBooleanVolatile(m, _overrideOffset.get(), true);
        }
        catch (Exception e) {
            throw ManExceptionUtil.unchecked(e);
        }
    }

    private static MethodRef addMethodToCache(Class cls, Method m) {
        return ReflectUtil.addMethodToCache(cls, m, m.getName());
    }

    private static MethodRef addMethodToCache(Class cls, Method m, String name) {
        ReflectUtil.setAccessible(m);
        ReflectUtil.addRawMethodToCache(cls, m, name);
        return new MethodRef(m);
    }

    private static void addRawMethodToCache(Class cls, Method m, String name) {
        ConcurrentHashSet<Method> methods;
        ConcurrentMap<String, ConcurrentHashSet<Method>> methodsByName = _methodsByName.get(cls);
        if (methodsByName == null) {
            methodsByName = new ConcurrentHashMap<String, ConcurrentHashSet<Method>>();
            _methodsByName.put(cls, methodsByName);
        }
        if ((methods = (ConcurrentHashSet<Method>)methodsByName.get(name)) == null) {
            methods = new ConcurrentHashSet<Method>(2);
            methodsByName.put(name, methods);
        }
        methods.add(m);
    }

    private static MethodRef getMethodFromCache(Class cls, String name, Class ... params) {
        Method m = ReflectUtil.getRawMethodFromCache(cls, name, params);
        if (m != null) {
            return new MethodRef(m);
        }
        return null;
    }

    private static Method getRawMethodFromCache(Class cls, String name, Class ... params) {
        ConcurrentHashSet methods;
        ConcurrentMap<String, ConcurrentHashSet<Method>> methodsByName = _methodsByName.get(cls);
        if (methodsByName != null && (methods = (ConcurrentHashSet)methodsByName.get(name)) != null) {
            block0: for (Method m : methods) {
                int paramsLen;
                int n = paramsLen = params == null ? 0 : params.length;
                if (m.getParameterCount() != paramsLen) continue;
                if (paramsLen > 0) {
                    Class<?>[] mparams = m.getParameterTypes();
                    for (int i = 0; i < mparams.length; ++i) {
                        Class<?> mparam = mparams[i];
                        if (!mparam.equals(params[i])) continue block0;
                    }
                }
                return m;
            }
        }
        return null;
    }

    private static MethodRef getMethodFromCacheUsingNameOnly(Class cls, String name) {
        Method m = ReflectUtil.getRawMethodFromCacheUsingNameOnly(cls, name);
        if (m != null) {
            return new MethodRef(m);
        }
        return null;
    }

    private static Method getRawMethodFromCacheUsingNameOnly(Class cls, String name) {
        ConcurrentHashSet methods;
        ConcurrentMap<String, ConcurrentHashSet<Method>> methodsByName = _methodsByName.get(cls);
        if (methodsByName != null && (methods = (ConcurrentHashSet)methodsByName.get(name)) != null) {
            return (Method)methods.iterator().next();
        }
        return null;
    }

    private static ConstructorRef addConstructorToCache(Class cls, Constructor m) {
        ReflectUtil.setAccessible(m);
        ReflectUtil.addRawConstructorToCache(cls, m);
        return new ConstructorRef(m);
    }

    private static void addRawConstructorToCache(Class cls, Constructor m) {
        Set constructors = _constructorsByClass.computeIfAbsent(cls, k -> ConcurrentHashMap.newKeySet());
        constructors.add(m);
    }

    private static ConstructorRef getConstructorFromCache(Class cls, Class ... params) {
        Constructor ctor = ReflectUtil.getRawConstructorFromCache(cls, params);
        if (ctor != null) {
            return new ConstructorRef(ctor);
        }
        return null;
    }

    private static Constructor getRawConstructorFromCache(Class cls, Class ... params) {
        Set<Constructor> constructors = _constructorsByClass.get(cls);
        if (constructors != null) {
            block0: for (Constructor m : constructors) {
                int paramsLen;
                int n = paramsLen = params == null ? 0 : params.length;
                if (m.getParameterCount() != paramsLen) continue;
                Class<?>[] mparams = m.getParameterTypes();
                if (paramsLen > 0) {
                    for (int i = 0; i < mparams.length; ++i) {
                        Class<?> mparam = mparams[i];
                        if (!mparam.equals(params[i])) continue block0;
                    }
                }
                return m;
            }
        }
        return null;
    }

    private static boolean setFinal(Field field, Object value) {
        return ReflectUtil.setFinal(field, null, value);
    }

    private static boolean setFinal(Field field, Object ctx, Object value) {
        if (Modifier.isFinal(field.getModifiers())) {
            try {
                ReflectUtil.clearFieldAccessors(field);
                ReflectUtil.removeFinalModifier(field);
                field.set(ctx, value);
                return true;
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }
        return false;
    }

    private static void removeFinalModifier(Field field) throws Exception {
        Field modifiersField = ReflectUtil.getDeclaredField(Field.class, "modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
    }

    private static void clearFieldAccessors(Field field) throws Exception {
        Field fa = ReflectUtil.getDeclaredField(Field.class, "fieldAccessor");
        fa.setAccessible(true);
        fa.set(field, null);
        Field ofa = ReflectUtil.getDeclaredField(Field.class, "overrideFieldAccessor");
        ofa.setAccessible(true);
        ofa.set(field, null);
        Field rf = ReflectUtil.getDeclaredField(Field.class, "root");
        rf.setAccessible(true);
        Field root = (Field)rf.get(field);
        if (root != null) {
            ReflectUtil.clearFieldAccessors(root);
        }
    }

    private static FieldRef addFieldToCache(Class cls, Field f) {
        ReflectUtil.setAccessible(f);
        ReflectUtil.addRawFieldToCache(cls, f);
        return new FieldRef(f);
    }

    private static FieldRef getFieldFromCache(Class cls, String name) {
        Field field = ReflectUtil.getRawFieldFromCache(cls, name);
        if (field != null) {
            return new FieldRef(field);
        }
        return null;
    }

    private static void addRawFieldToCache(Class cls, Field f) {
        ConcurrentMap<String, Field> fieldsByName = _fieldsByName.get(cls);
        if (fieldsByName == null) {
            fieldsByName = new ConcurrentHashMap<String, Field>();
            _fieldsByName.put(cls, fieldsByName);
        }
        fieldsByName.put(f.getName(), f);
    }

    private static Field getRawFieldFromCache(Class cls, String name) {
        ConcurrentMap<String, Field> fieldsByName = _fieldsByName.get(cls);
        if (fieldsByName != null) {
            return (Field)fieldsByName.get(name);
        }
        return null;
    }

    public static void preloadClassIntoParentLoader(String fqn, URI content, ClassLoader wouldBeLoader, ClassLoader parentLoader) {
        if (null != ReflectUtil.method(parentLoader, "findLoadedClass", String.class).invoke(fqn)) {
            return;
        }
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(content));
            ReflectUtil.method(parentLoader, "defineClass", byte[].class, Integer.TYPE, Integer.TYPE).invoke(bytes, 0, bytes.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static MethodRef structuralMethod(Class target, Class structIface, String name, Class ... params) {
        MethodRef structMethod = ReflectUtil.method(structIface, name, params);
        if (structMethod != null) {
            Method bestMethod = ReflectUtil.findBestMethod(structMethod.getMethod(), target);
            return bestMethod == null ? null : new MethodRef(bestMethod);
        }
        return null;
    }

    public static LiveMethodRef structuralMethod(Object receiver, Class structIface, String name, Class ... params) {
        MethodRef structMethod = ReflectUtil.method(structIface, name, params);
        if (structMethod != null) {
            Method bestMethod = ReflectUtil.findBestMethod(structMethod.getMethod(), receiver.getClass());
            return bestMethod == null ? null : new LiveMethodRef(bestMethod, receiver);
        }
        return null;
    }

    public static Object structuralCall(Method structMethod, Object receiver, Object ... args) {
        return ReflectUtil.structuralCallByProxy(structMethod, null, receiver, args);
    }

    public static Object structuralCallByProxy(Method structMethod, Object proxy, Object receiver, Object ... args) {
        Method bestMethod = ReflectUtil.findBestMethod(structMethod, receiver.getClass());
        if (bestMethod == null) {
            if (proxy != null && structMethod.isDefault()) {
                return ReflectUtil.invokeDefault(proxy, structMethod, args);
            }
            Object result = ReflectUtil.handleByField(structMethod, proxy, receiver, args);
            if (result != UNHANDLED) {
                return result;
            }
            throw new RuntimeException("Receiver type '" + receiver.getClass().getTypeName() + "' does not implement a method structurally compatible with method: " + structMethod);
        }
        try {
            return bestMethod.invoke(receiver, args);
        }
        catch (Throwable t) {
            throw ManExceptionUtil.unchecked(t);
        }
    }

    private static Field findField(String name, Class rootType, Class<?> returnType, Variance variance) {
        String nameUpper = Character.toUpperCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : "");
        String nameLower = Character.toLowerCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : "");
        String nameUnder = '_' + nameLower;
        for (Field field : rootType.getFields()) {
            Class<?> fromType;
            String fieldName = field.getName();
            Class<?> toType = variance == Variance.Covariant ? returnType : field.getType();
            Class<?> clazz = fromType = variance == Variance.Covariant ? field.getType() : returnType;
            if (!toType.isAssignableFrom(fromType) && !ReflectUtil.arePrimitiveTypesAssignable(toType, fromType) || !fieldName.equals(nameUpper) && !fieldName.equals(nameLower) && !fieldName.equals(nameUnder)) continue;
            return field;
        }
        return null;
    }

    public static boolean arePrimitiveTypesAssignable(Class toType, Class fromType) {
        if (toType == null || fromType == null || !toType.isPrimitive() || !fromType.isPrimitive()) {
            return false;
        }
        if (toType == fromType) {
            return true;
        }
        if (toType == Double.TYPE) {
            return fromType == Float.TYPE || fromType == Integer.TYPE || fromType == Character.TYPE || fromType == Short.TYPE || fromType == Byte.TYPE;
        }
        if (toType == Float.TYPE) {
            return fromType == Character.TYPE || fromType == Short.TYPE || fromType == Byte.TYPE;
        }
        if (toType == Long.TYPE) {
            return fromType == Integer.TYPE || fromType == Character.TYPE || fromType == Short.TYPE || fromType == Byte.TYPE;
        }
        if (toType == Integer.TYPE) {
            return fromType == Short.TYPE || fromType == Character.TYPE || fromType == Byte.TYPE;
        }
        if (toType == Short.TYPE) {
            return fromType == Byte.TYPE;
        }
        return false;
    }

    private static Object handleByField(Method structMethod, Object proxy, Object receiver, Object[] args) {
        String propertyName = ReflectUtil.getPropertyNameFromGetter(structMethod);
        if (propertyName != null) {
            Field field = ReflectUtil.findField(propertyName, receiver.getClass(), structMethod.getReturnType(), Variance.Covariant);
            if (field != null) {
                try {
                    ReflectUtil.setAccessible(field);
                    return field.get(receiver);
                }
                catch (IllegalAccessException e) {
                    throw ManExceptionUtil.unchecked(e);
                }
            }
        } else {
            Field field;
            propertyName = ReflectUtil.getPropertyNameFromSetter(structMethod);
            if (propertyName != null && (field = ReflectUtil.findField(propertyName, receiver.getClass(), structMethod.getParameterTypes()[0], Variance.Contravariant)) != null) {
                try {
                    ReflectUtil.setAccessible(field);
                    field.set(receiver, args[0]);
                    return null;
                }
                catch (IllegalAccessException e) {
                    throw ManExceptionUtil.unchecked(e);
                }
            }
        }
        return UNHANDLED;
    }

    public static Method findBestMethod(Method structMethod, Class receiverClass) {
        ConcurrentMap map = _structuralCall.computeIfAbsent(structMethod, cls -> new ConcurrentWeakHashMap());
        return map.computeIfAbsent(receiverClass, rc -> {
            ArrayList<Method> methods = new ArrayList<Method>();
            for (Method m : rc.getMethods()) {
                if (!m.getName().equals(structMethod.getName())) continue;
                methods.add(m);
            }
            List<MethodScore> methodScores = MethodScorer.instance().scoreMethods(methods, Arrays.asList(structMethod.getParameterTypes()), structMethod.getReturnType());
            for (MethodScore score : methodScores) {
                if (score.isErrant()) continue;
                Method method = score.getMethod();
                ReflectUtil.setAccessible(method);
                return method;
            }
            return null;
        });
    }

    private static String getPropertyNameFromGetter(Method method) {
        Class<?>[] params = method.getParameterTypes();
        if (params.length != 0) {
            return null;
        }
        String name = method.getName();
        String propertyName = null;
        for (String prefix : Arrays.asList("get", "is")) {
            if (name.length() <= prefix.length() || !name.startsWith(prefix)) continue;
            if (prefix.equals("is") && !method.getReturnType().equals(Boolean.TYPE) && !method.getReturnType().equals(Boolean.class)) break;
            propertyName = name.substring(prefix.length());
            char firstChar = propertyName.charAt(0);
            if (firstChar == '_' && propertyName.length() > 1) {
                propertyName = propertyName.substring(1);
                continue;
            }
            if (!Character.isAlphabetic(firstChar) || Character.isUpperCase(firstChar)) continue;
            propertyName = null;
            break;
        }
        return propertyName;
    }

    private static String getPropertyNameFromSetter(Method method) {
        if (method.getReturnType() != Void.TYPE) {
            return null;
        }
        Class<?>[] params = method.getParameterTypes();
        if (params.length != 1) {
            return null;
        }
        String name = method.getName();
        String propertyName = null;
        if (name.length() > "set".length() && name.startsWith("set")) {
            propertyName = name.substring("set".length());
            char firstChar = propertyName.charAt(0);
            if (firstChar == '_' && propertyName.length() > 1) {
                propertyName = propertyName.substring(1);
            } else if (Character.isAlphabetic(firstChar) && !Character.isUpperCase(firstChar)) {
                propertyName = null;
            }
        }
        return propertyName;
    }

    static {
        NecessaryEvilUtil.disableJava9IllegalAccessWarning();
    }

    public static class FakeProxy
    implements InvocationHandler {
        private final Object _arg;

        public FakeProxy(Object arg) {
            this._arg = arg;
        }

        public Object getTarget() {
            return this._arg;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            throw new IllegalStateException("This proxy exists only to handle being cast, it should never be invoked.");
        }
    }

    static enum Variance {
        Covariant,
        Contravariant;

    }

    static class ClassContextSecurityManager
    extends SecurityManager {
        ClassContextSecurityManager() {
        }

        protected Class[] getClassContext() {
            return super.getClassContext();
        }
    }

    public static class WithNull {
        public static LiveMethodRef method(Object receiver, String name, Class ... params) {
            MethodRef ref = ReflectUtil.method(receiver.getClass(), name, params);
            if (ref == null) {
                return null;
            }
            return new LiveMethodRef(ref._method, receiver);
        }

        public static LiveFieldRef field(Object receiver, String name) {
            FieldRef ref = ReflectUtil.field(receiver.getClass(), name);
            if (ref == null) {
                return null;
            }
            return new LiveFieldRef(ref._field, receiver);
        }

        public static LiveMethodRef methodWithReturn(Object receiver, String name, Class<?> returnType, Class ... params) {
            LiveMethodRef ref = WithNull.method(receiver, name, params);
            if (ref != null && !returnType.isAssignableFrom(ref.getMethod().getReturnType())) {
                ref = null;
            }
            return ref;
        }
    }

    public static class ConstructorRef {
        private final Constructor<?> _constructor;

        private ConstructorRef(Constructor<?> constructor) {
            this._constructor = constructor;
        }

        public Object newInstance(Object ... args) {
            try {
                return this._constructor.newInstance(args);
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }

        public Constructor<?> getConstructor() {
            return this._constructor;
        }
    }

    public static class LiveFieldRef {
        private final Field _field;
        private final Object _receiver;

        private LiveFieldRef(Field f, Object receiver) {
            this._field = f;
            this._receiver = receiver;
        }

        public Field getField() {
            return this._field;
        }

        public Object getReceiver() {
            return this._receiver;
        }

        public Object get() {
            try {
                return this._field.get(this._receiver);
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }

        public void set(Object value) {
            try {
                this._field.set(this._receiver, value);
            }
            catch (Exception e) {
                if (ReflectUtil.setFinal(this._field, this._receiver, value)) {
                    return;
                }
                throw ManExceptionUtil.unchecked(e);
            }
        }
    }

    public static class FieldRef {
        private final Field _field;

        private FieldRef(Field f) {
            this._field = f;
        }

        public Object get(Object receiver) {
            try {
                return this._field.get(receiver);
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }

        public void set(Object receiver, Object value) {
            try {
                this._field.set(receiver, value);
            }
            catch (Exception e) {
                if (ReflectUtil.setFinal(this._field, receiver, value)) {
                    return;
                }
                throw ManExceptionUtil.unchecked(e);
            }
        }

        public Object getStatic() {
            try {
                return this._field.get(null);
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }

        public void setStatic(Object value) {
            try {
                this._field.set(null, value);
            }
            catch (Exception e) {
                if (ReflectUtil.setFinal(this._field, value)) {
                    return;
                }
                throw ManExceptionUtil.unchecked(e);
            }
        }
    }

    public static class LiveMethodRef {
        private final Method _method;
        private final Object _receiver;

        private LiveMethodRef(Method m, Object receiver) {
            this._method = m;
            this._receiver = receiver;
        }

        public Method getMethod() {
            return this._method;
        }

        public Object getReceiver() {
            return this._receiver;
        }

        public Object invoke(Object ... args) {
            try {
                return this._method.invoke(this._receiver, args);
            }
            catch (InvocationTargetException ite) {
                throw ManExceptionUtil.unchecked(ite.getCause());
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }

        public Object invokeSuper(Object ... args) {
            try {
                MethodHandle superMethod = MethodHandles.lookup().findSpecial(this._receiver.getClass().getSuperclass(), this._method.getName(), MethodType.methodType(this._method.getReturnType(), this._method.getParameterTypes()), this._receiver.getClass());
                return superMethod.bindTo(this._receiver).invokeExact(args);
            }
            catch (Throwable t) {
                throw ManExceptionUtil.unchecked(t);
            }
        }
    }

    public static class MethodRef {
        private final Method _method;

        private MethodRef(Method m) {
            this._method = m;
        }

        public Method getMethod() {
            return this._method;
        }

        public Object invoke(Object receiver, Object ... args) {
            try {
                return this._method.invoke(receiver, args);
            }
            catch (InvocationTargetException ite) {
                throw ManExceptionUtil.unchecked(ite.getCause());
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }

        public Object invokeStatic(Object ... args) {
            try {
                return this._method.invoke(null, args);
            }
            catch (InvocationTargetException ite) {
                throw ManExceptionUtil.unchecked(ite.getCause());
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }
    }

    static class FakeAccessibleObject {
        private static final String ACCESS_PERMISSION = "";
        boolean override;

        FakeAccessibleObject() {
        }
    }
}

