/*
 * Decompiled with CFR 0.152.
 */
package manifold.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import manifold.util.NecessaryEvilUtil;
import manifold.util.concurrent.ConcurrentHashSet;
import manifold.util.concurrent.ConcurrentWeakHashMap;

public class ReflectUtil {
    private static final ConcurrentWeakHashMap<Class, ConcurrentMap<String, ConcurrentHashSet<Method>>> _methodsByName = new ConcurrentWeakHashMap();
    private static final ConcurrentWeakHashMap<Class, ConcurrentMap<String, Field>> _fieldsByName = new ConcurrentWeakHashMap();

    public static Class<?> type(String fqn) {
        try {
            return Class.forName(fqn);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> type(String fqn, ClassLoader cl) {
        try {
            return Class.forName(fqn, false, cl);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static LiveMethodRef method(Object receiver, String name, Class ... params) {
        MethodRef ref = ReflectUtil.method(receiver.getClass(), name, params);
        if (ref == null) {
            throw new RuntimeException("Method '" + name + "' not found");
        }
        return new LiveMethodRef(ref._method, receiver);
    }

    public static MethodRef method(Class<?> cls, String name, Class ... params) {
        MethodRef mr = ReflectUtil.getMethodFromCache(cls, name, params);
        if (mr != null) {
            return mr;
        }
        try {
            Method method = cls.getDeclaredMethod(name, params);
            return ReflectUtil.addMethodToCache(cls, method);
        }
        catch (Exception e) {
            Class<?> superclass = cls.getSuperclass();
            if (superclass != null && (mr = ReflectUtil.method(superclass, name, params)) != null) {
                return mr;
            }
            for (Class<?> iface : cls.getInterfaces()) {
                mr = ReflectUtil.method(iface, name, params);
                if (mr == null) continue;
                ReflectUtil.addMethodToCache(cls, mr._method);
                return mr;
            }
            return null;
        }
    }

    public static LiveFieldRef field(Object receiver, String name) {
        FieldRef ref = ReflectUtil.field(receiver.getClass(), name);
        if (ref == null) {
            throw new RuntimeException("Field '" + name + "' not found");
        }
        return new LiveFieldRef(ref._field, receiver);
    }

    public static FieldRef field(Class<?> cls, String name) {
        FieldRef fr = ReflectUtil.getFieldFromCache(cls, name);
        if (fr != null) {
            return fr;
        }
        try {
            Field field = cls.getDeclaredField(name);
            return ReflectUtil.addFieldToCache(cls, field);
        }
        catch (Exception e) {
            Class<?> superclass = cls.getSuperclass();
            if (superclass != null && (fr = ReflectUtil.field(superclass, name)) != null) {
                ReflectUtil.addFieldToCache(cls, fr._field);
                return fr;
            }
            for (Class<?> iface : cls.getInterfaces()) {
                fr = ReflectUtil.field(iface, name);
                if (fr == null) continue;
                ReflectUtil.addFieldToCache(cls, fr._field);
                return fr;
            }
            return null;
        }
    }

    public static ConstructorRef constructor(String fqn, Class<?> ... params) {
        try {
            Class<?> cls = Class.forName(fqn);
            return new ConstructorRef(cls.getDeclaredConstructor(params));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setAccessible(Field f) {
        try {
            f.setAccessible(true);
        }
        catch (Exception e) {
            ReflectUtil.setAccessible((Member)f);
        }
    }

    public static void setAccessible(Method m) {
        try {
            m.setAccessible(true);
        }
        catch (Exception e) {
            ReflectUtil.setAccessible((Member)m);
        }
    }

    public static void setAccessible(Constructor c) {
        try {
            c.setAccessible(true);
        }
        catch (Exception e) {
            ReflectUtil.setAccessible((Member)c);
        }
    }

    public static void setAccessible(Member m) {
        Field overrideField = ReflectUtil.getOverrideField();
        try {
            NecessaryEvilUtil.UNSAFE.putObjectVolatile(m, NecessaryEvilUtil.UNSAFE.objectFieldOffset(overrideField), true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getOverrideField() {
        Field overrideField = ReflectUtil.getRawFieldFromCache(AccessibleObject.class, "override");
        if (overrideField == null) {
            try {
                overrideField = AccessibleObject.class.getDeclaredField("override");
                ReflectUtil.addRawFieldToCache(AccessibleObject.class, overrideField);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return overrideField;
    }

    private static MethodRef addMethodToCache(Class cls, Method m) {
        ReflectUtil.setAccessible(m);
        ReflectUtil.addRawMethodToCache(cls, m);
        return new MethodRef(m);
    }

    private static void addRawMethodToCache(Class cls, Method m) {
        ConcurrentHashSet<Method> methods;
        ConcurrentMap<String, ConcurrentHashSet<Method>> methodsByName = _methodsByName.get(cls);
        if (methodsByName == null) {
            methodsByName = new ConcurrentHashMap<String, ConcurrentHashSet<Method>>();
            _methodsByName.put(cls, methodsByName);
        }
        if ((methods = (ConcurrentHashSet<Method>)methodsByName.get(m.getName())) == null) {
            methods = new ConcurrentHashSet<Method>(2);
            methodsByName.put(m.getName(), methods);
        }
        methods.add(m);
    }

    private static MethodRef getMethodFromCache(Class cls, String name, Class ... params) {
        Method m = ReflectUtil.getRawMethodFromCache(cls, name, params);
        if (m != null) {
            return new MethodRef(m);
        }
        return null;
    }

    private static Method getRawMethodFromCache(Class cls, String name, Class ... params) {
        ConcurrentHashSet methods;
        ConcurrentMap<String, ConcurrentHashSet<Method>> methodsByName = _methodsByName.get(cls);
        if (methodsByName != null && (methods = (ConcurrentHashSet)methodsByName.get(name)) != null) {
            block0: for (Method m : methods) {
                int paramsLen;
                Class<?>[] mparams = m.getParameterTypes();
                if (mparams.length != (paramsLen = params == null ? 0 : params.length)) continue;
                for (int i = 0; i < mparams.length; ++i) {
                    Class<?> mparam = mparams[i];
                    if (!mparam.equals(params[i])) continue block0;
                }
                return m;
            }
        }
        return null;
    }

    private static FieldRef addFieldToCache(Class cls, Field f) {
        ReflectUtil.setAccessible(f);
        ReflectUtil.addRawFieldToCache(cls, f);
        return new FieldRef(f);
    }

    private static FieldRef getFieldFromCache(Class cls, String name) {
        Field field = ReflectUtil.getRawFieldFromCache(cls, name);
        if (field != null) {
            return new FieldRef(field);
        }
        return null;
    }

    private static void addRawFieldToCache(Class cls, Field f) {
        ConcurrentMap<String, Field> fieldsByName = _fieldsByName.get(cls);
        if (fieldsByName == null) {
            fieldsByName = new ConcurrentHashMap<String, Field>();
            _fieldsByName.put(cls, fieldsByName);
        }
        fieldsByName.put(f.getName(), f);
    }

    private static Field getRawFieldFromCache(Class cls, String name) {
        ConcurrentMap<String, Field> fieldsByName = _fieldsByName.get(cls);
        if (fieldsByName != null) {
            return (Field)fieldsByName.get(name);
        }
        return null;
    }

    public static class ConstructorRef {
        private final Constructor<?> _constructor;

        private ConstructorRef(Constructor<?> constructor) {
            this._constructor = constructor;
        }

        public Object newInstance(Object ... args) {
            try {
                return this._constructor.newInstance(args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class LiveFieldRef {
        private final Field _field;
        private final Object _receiver;

        private LiveFieldRef(Field f, Object receiver) {
            this._field = f;
            this._receiver = receiver;
        }

        public Object get() {
            try {
                return this._field.get(this._receiver);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void set(Object value) {
            try {
                this._field.set(this._receiver, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class FieldRef {
        private final Field _field;

        private FieldRef(Field f) {
            this._field = f;
        }

        public Object get(Object receiver) {
            try {
                return this._field.get(receiver);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void set(Object receiver, Object value) {
            try {
                this._field.set(receiver, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Object getStatic() {
            try {
                return this._field.get(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void setStatic(Object value) {
            try {
                this._field.set(null, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class LiveMethodRef {
        private Method _method;
        private Object _receiver;

        private LiveMethodRef(Method m, Object receiver) {
            this._method = m;
            this._receiver = receiver;
        }

        public Object invoke(Object ... args) {
            try {
                return this._method.invoke(this._receiver, args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class MethodRef {
        private final Method _method;

        private MethodRef(Method m) {
            this._method = m;
        }

        public Object invoke(Object receiver, Object ... args) {
            try {
                return this._method.invoke(receiver, args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Object invokeStatic(Object ... args) {
            try {
                return this._method.invoke(null, args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

