/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor;

import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.util.function.Consumer;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavacPlugin;
import manifold.preprocessor.TokenType;
import manifold.preprocessor.expression.Expression;
import manifold.preprocessor.expression.ExpressionParser;

public class Tokenizer {
    private CharSequence _buffer;
    private TokenType _tokenType;
    private int _bufferIndex;
    private int _bufferEndOffset;
    private int _tokenEndOffset;
    private Expression _expr;
    private final Consumer<Tokenizer> _consumer;

    public Tokenizer(CharSequence buffer, int startOffset, int endOffset, Consumer<Tokenizer> consumer) {
        this._buffer = buffer;
        this._bufferIndex = startOffset;
        this._bufferEndOffset = endOffset;
        this._tokenType = null;
        this._tokenEndOffset = startOffset;
        this._consumer = consumer;
    }

    public TokenType getTokenType() {
        return this._tokenType;
    }

    public int getTokenStart() {
        return this._bufferIndex;
    }

    public int getTokenEnd() {
        return this._tokenEndOffset;
    }

    public Expression getExpression() {
        return this._expr;
    }

    public void advance() {
        this._tokenType = null;
        if (this._tokenEndOffset == this._bufferEndOffset) {
            this._bufferIndex = this._bufferEndOffset;
            return;
        }
        this._bufferIndex = this._tokenEndOffset;
        char c = this.charAt(this._bufferIndex);
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                this._tokenType = TokenType.Whitespace;
                this._tokenEndOffset = this.skipWhitespace(this._bufferIndex + 1, true);
                break;
            }
            case '/': {
                if (this._bufferIndex + 1 >= this._bufferEndOffset) break;
                char nextChar = this.charAt(this._bufferIndex + 1);
                if (nextChar == '/') {
                    this._tokenType = TokenType.LineComment;
                    this._tokenEndOffset = this.getLineTerminator(this._bufferIndex + 2);
                    break;
                }
                if (nextChar == '*') {
                    this._tokenType = TokenType.BlockComment;
                    this._tokenEndOffset = this.getClosingComment(this._bufferIndex + 2);
                    break;
                }
                this.makeSourceCodeToken(this._bufferIndex + 1);
                break;
            }
            case '\"': {
                if (this._bufferIndex + 2 < this._bufferEndOffset && this.charAt(this._bufferIndex + 2) == '\"' && this.charAt(this._bufferIndex + 1) == '\"') {
                    this._tokenType = TokenType.TextBlock;
                    this._tokenEndOffset = this.getTextBlockEnd(this._bufferIndex + 2);
                    break;
                }
                this._tokenType = TokenType.StringLiteral;
                this._tokenEndOffset = this.getClosingQuote(this._bufferIndex + 1, c);
                break;
            }
            case '\'': {
                this._tokenType = TokenType.CharLiteral;
                this._tokenEndOffset = this.getClosingQuote(this._bufferIndex + 1, c);
                break;
            }
            case '#': {
                if (this.matchDirective(this._bufferIndex + 1)) break;
                this.addError("Invalid directive", this._bufferIndex);
                this.makeSourceCodeToken(this._bufferIndex + 1);
                break;
            }
            default: {
                this.makeSourceCodeToken(this._bufferIndex + 1);
            }
        }
        if (this._tokenEndOffset > this._bufferEndOffset) {
            this._tokenEndOffset = this._bufferEndOffset;
        }
        if (this._consumer != null) {
            this._consumer.accept(this);
        }
    }

    private boolean matchDirective(int offset) {
        if (this.match(TokenType.If.getDirective(), offset)) {
            offset += TokenType.If.getDirective().length();
            this._tokenType = TokenType.If;
            offset = this.skipWhitespace(offset, false);
            this._expr = new ExpressionParser(this._buffer, offset, this._bufferEndOffset).parse();
            this._tokenEndOffset = this._expr.getEndOffset();
        } else if (this.match(TokenType.Elif.getDirective(), offset)) {
            offset += TokenType.Elif.getDirective().length();
            this._tokenType = TokenType.Elif;
            offset = this.skipWhitespace(offset, false);
            this._expr = new ExpressionParser(this._buffer, offset, this._bufferEndOffset).parse();
            this._tokenEndOffset = this._expr.getEndOffset();
        } else if (this.match(TokenType.Else.getDirective(), offset)) {
            this._tokenType = TokenType.Else;
            this._tokenEndOffset = offset += TokenType.Else.getDirective().length();
        } else if (this.match(TokenType.Endif.getDirective(), offset)) {
            this._tokenType = TokenType.Endif;
            this._tokenEndOffset = offset += TokenType.Endif.getDirective().length();
        } else if (this.match(TokenType.Define.getDirective(), offset)) {
            offset += TokenType.Define.getDirective().length();
            this._tokenType = TokenType.Define;
            offset = this.skipWhitespace(offset, false);
            this._expr = new ExpressionParser(this._buffer, offset, this._bufferEndOffset).parse();
            this._tokenEndOffset = this._expr.getEndOffset();
        } else if (this.match(TokenType.Undef.getDirective(), offset)) {
            offset += TokenType.Undef.getDirective().length();
            this._tokenType = TokenType.Undef;
            offset = this.skipWhitespace(offset, false);
            this._expr = new ExpressionParser(this._buffer, offset, this._bufferEndOffset).parse();
            this._tokenEndOffset = this._expr.getEndOffset();
        } else if (this.match(TokenType.Error.getDirective(), offset)) {
            offset += TokenType.Error.getDirective().length();
            this._tokenType = TokenType.Error;
            offset = this.skipWhitespace(offset, false);
            this._expr = new ExpressionParser(this._buffer, offset, this._bufferEndOffset).parse();
            this._tokenEndOffset = this._expr.getEndOffset();
        } else if (this.match(TokenType.Warning.getDirective(), offset)) {
            offset += TokenType.Warning.getDirective().length();
            this._tokenType = TokenType.Warning;
            offset = this.skipWhitespace(offset, false);
            this._expr = new ExpressionParser(this._buffer, offset, this._bufferEndOffset).parse();
            this._tokenEndOffset = this._expr.getEndOffset();
        } else {
            return false;
        }
        return true;
    }

    private boolean match(String str, int offset) {
        int i;
        if (this._buffer.length() < offset + str.length()) {
            return false;
        }
        for (i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == this._buffer.charAt(offset + i)) continue;
            return false;
        }
        return (offset += i) >= this._bufferEndOffset || !Character.isJavaIdentifierPart(this._buffer.charAt(offset));
    }

    private char charAt(int i) {
        return this._buffer.charAt(i);
    }

    private void makeSourceCodeToken(int offset) {
        this._tokenType = TokenType.Source;
        this._tokenEndOffset = this.skipSourceCode(offset);
    }

    private int skipSourceCode(int offset) {
        if (offset >= this._bufferEndOffset) {
            return this._bufferEndOffset;
        }
        int pos = offset;
        char c = this._buffer.charAt(pos);
        while (!this.isCommentStart(pos) && c != '\n' && c != '\r' && c != '\f' && c != '\"' && c != '\'' && c != '#') {
            if (++pos == this._bufferEndOffset) {
                return pos;
            }
            c = this._buffer.charAt(pos);
        }
        return pos;
    }

    private boolean isCommentStart(int pos) {
        if (this._buffer.charAt(pos) == '/' && pos + 1 < this._bufferEndOffset) {
            char nextChar = this.charAt(pos + 1);
            return nextChar == '/' || nextChar == '*';
        }
        return false;
    }

    private int skipWhitespace(int offset, boolean multiLine) {
        if (offset >= this._bufferEndOffset) {
            return this._bufferEndOffset;
        }
        int pos = offset;
        char c = this.charAt(pos);
        while (c == ' ' || c == '\t' || multiLine && (c == '\n' || c == '\r' || c == '\f')) {
            if (++pos == this._bufferEndOffset) {
                return pos;
            }
            c = this.charAt(pos);
        }
        return pos;
    }

    private int getLineTerminator(int offset) {
        char c;
        int pos;
        for (pos = offset; pos < this._bufferEndOffset && (c = this.charAt(pos)) != '\r' && c != '\n'; ++pos) {
        }
        return pos;
    }

    private int getClosingComment(int offset) {
        char c;
        int pos;
        for (pos = offset; pos < this._bufferEndOffset - 1 && ((c = this.charAt(pos)) != '*' || this.charAt(pos + 1) != '/'); ++pos) {
        }
        return pos + 2;
    }

    private int getClosingQuote(int offset, char quoteChar) {
        int pos;
        block6: {
            if (offset >= this._bufferEndOffset) {
                return this._bufferEndOffset;
            }
            pos = offset;
            char c = this.charAt(pos);
            while (true) {
                if (c != quoteChar && c != '\n' && c != '\r' && c != '\\') {
                    if (++pos >= this._bufferEndOffset) {
                        return this._bufferEndOffset;
                    }
                    c = this.charAt(pos);
                    continue;
                }
                if (c != '\\') break;
                if (++pos >= this._bufferEndOffset) {
                    return this._bufferEndOffset;
                }
                c = this.charAt(pos);
                if (c == '\n' || c == '\r') continue;
                if (++pos >= this._bufferEndOffset) {
                    return this._bufferEndOffset;
                }
                c = this.charAt(pos);
            }
            if (c == quoteChar) break block6;
            --pos;
        }
        return pos + 1;
    }

    private int getTextBlockEnd(int offset) {
        int pos = offset;
        while ((pos = this.getClosingQuote(pos + 1, '\"')) < this._bufferEndOffset) {
            if (pos + 1 >= this._bufferEndOffset || this.charAt(pos + 1) != '\"' || this.charAt(pos) != '\"') continue;
            pos += 2;
            break;
        }
        return pos;
    }

    private void addError(String message, int pos) {
        if (JavacPlugin.instance() == null) {
            return;
        }
        IDynamicJdk.instance().logError(Log.instance(JavacPlugin.instance().getContext()), (JCDiagnostic.DiagnosticPosition)new JCDiagnostic.SimpleDiagnosticPosition(pos), "proc.messager", new Object[]{message});
    }
}

