/*
 * Copyright (c) 2019 - Manifold Systems LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package manifold.preprocessor;

public enum TokenType
{
  Whitespace(),
  LineComment(),
  BlockComment(),
  StringLiteral(),
  CharLiteral(),
  TextBlock(),
  If("if"),
  Elif("elif"),
  Else("else"),
  Endif("endif"),
  Define("define"),
  Undef("undef"),
  Error("error"),
  Warning("warning"),
  Source();

  private String _directive;

  TokenType()
  {
    this( null );
  }

  TokenType( String directive )
  {
    _directive = directive;
  }

  public boolean isDirective()
  {
    return _directive != null;
  }

  public String getDirective()
  {
    return _directive;
  }
}
