/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import manifold.preprocessor.definitions.Definitions;
import manifold.preprocessor.expression.Expression;

public class EqualityExpression
extends Expression {
    private final Expression _lhs;
    private final Expression _rhs;
    private final boolean _not;

    EqualityExpression(Expression lhs, Expression rhs, boolean not, int start, int end) {
        super(start, end);
        this._lhs = lhs;
        this._rhs = rhs;
        this._not = not;
    }

    @Override
    public List<Expression> getChildren() {
        ArrayList<Expression> children = new ArrayList<Expression>();
        children.add(this._lhs);
        children.add(this._rhs);
        return children;
    }

    @Override
    public boolean evaluate(Definitions definitions) {
        return this._not != (this._lhs.evaluate(definitions) == this._rhs.evaluate(definitions) && Objects.equals(this._lhs.getValue(definitions), this._rhs.getValue(definitions)));
    }

    public String toString() {
        return this._lhs + " == " + this._rhs;
    }
}

