/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor.expression;

import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavacPlugin;
import manifold.preprocessor.definitions.Definitions;
import manifold.preprocessor.expression.Expression;

public class RelationalExpression
extends Expression {
    private final Expression _lhs;
    private final Expression _rhs;
    private final Operator _op;

    RelationalExpression(Expression lhs, Expression rhs, String op, int start, int end) {
        super(start, end);
        this._lhs = lhs;
        this._rhs = rhs;
        this._op = Operator.from(op);
    }

    @Override
    public List<Expression> getChildren() {
        ArrayList<Expression> children = new ArrayList<Expression>();
        children.add(this._lhs);
        children.add(this._rhs);
        return children;
    }

    @Override
    public boolean evaluate(Definitions definitions) {
        BigDecimal lhsNumber = this.getNumberValue(this._lhs, definitions);
        BigDecimal rhsNumber = this.getNumberValue(this._rhs, definitions);
        if (lhsNumber == null || rhsNumber == null) {
            return false;
        }
        switch (this._op) {
            case GT: {
                return lhsNumber.compareTo(rhsNumber) > 0;
            }
            case GE: {
                return lhsNumber.compareTo(rhsNumber) >= 0;
            }
            case LT: {
                return lhsNumber.compareTo(rhsNumber) < 0;
            }
            case LE: {
                return lhsNumber.compareTo(rhsNumber) <= 0;
            }
        }
        throw new IllegalStateException();
    }

    public BigDecimal getNumberValue(Expression operand, Definitions definitions) {
        String value = operand.getValue(definitions);
        try {
            return new BigDecimal(value.trim());
        }
        catch (Exception e) {
            this.generateError("\"" + value + "\"");
            return null;
        }
    }

    private void generateError(String value) {
        if (JavacPlugin.instance() != null) {
            IDynamicJdk.instance().logError(Log.instance(JavacPlugin.instance().getContext()), (JCDiagnostic.DiagnosticPosition)new JCDiagnostic.SimpleDiagnosticPosition(this.getStartOffset()), "proc.messager", new Object[]{"Non-numeric value not allowed in relational expression: " + value});
        }
    }

    public String toString() {
        return this._lhs + " " + (Object)((Object)this._op) + " " + this._rhs;
    }

    static enum Operator {
        GT(">"),
        GE(">="),
        LT("<"),
        LE("<=");

        private final String _op;

        private Operator(String op) {
            this._op = op;
        }

        public String toString() {
            return this._op;
        }

        static Operator from(String op) {
            switch (op) {
                case ">": {
                    return GT;
                }
                case ">=": {
                    return GE;
                }
                case "<": {
                    return LT;
                }
                case "<=": {
                    return LE;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

