/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor.expression;

import manifold.preprocessor.expression.ExpressionTokenType;

class ExpressionTokenizer {
    private CharSequence _buffer;
    private ExpressionTokenType _tokenType;
    private int _bufferIndex;
    private int _bufferEndOffset;
    private int _tokenEndOffset;

    ExpressionTokenizer(CharSequence buffer, int startOffset, int endOffset) {
        this._buffer = buffer;
        this._bufferIndex = startOffset;
        this._bufferEndOffset = endOffset;
        this._tokenType = null;
        this._tokenEndOffset = startOffset;
    }

    ExpressionTokenType getTokenType() {
        return this._tokenType;
    }

    int getTokenStart() {
        return this._bufferIndex;
    }

    int getTokenEnd() {
        return this._tokenEndOffset;
    }

    CharSequence getTokenText() {
        if (this._tokenType != null) {
            return this._buffer.subSequence(this.getTokenStart(), this.getTokenEnd());
        }
        return null;
    }

    void advance() {
        this._tokenType = null;
        if (this._tokenEndOffset == this._bufferEndOffset) {
            this._bufferIndex = this._bufferEndOffset;
            return;
        }
        this._bufferIndex = this._tokenEndOffset;
        char c = this.charAt(this._bufferIndex);
        switch (c) {
            case '\t': 
            case ' ': {
                this._tokenType = ExpressionTokenType.Whitespace;
                this._tokenEndOffset = this.skipWhitespace(this._bufferIndex + 1);
                break;
            }
            case '\"': {
                this._tokenType = ExpressionTokenType.StringLiteral;
                this._tokenEndOffset = this.getClosingQuote(this._bufferIndex + 1);
                break;
            }
            case '(': {
                this._tokenType = ExpressionTokenType.OpenParen;
                this._tokenEndOffset = this._bufferIndex + 1;
                break;
            }
            case ')': {
                this._tokenType = ExpressionTokenType.CloseParen;
                this._tokenEndOffset = this._bufferIndex + 1;
                break;
            }
            case '|': {
                if (this._bufferIndex + 1 == this._bufferEndOffset || this.charAt(this._bufferIndex + 1) != '|') break;
                this._tokenType = ExpressionTokenType.Or;
                this._tokenEndOffset = this._bufferIndex + 2;
                break;
            }
            case '&': {
                if (this._bufferIndex + 1 == this._bufferEndOffset || this.charAt(this._bufferIndex + 1) != '&') break;
                this._tokenType = ExpressionTokenType.And;
                this._tokenEndOffset = this._bufferIndex + 2;
                break;
            }
            case '=': {
                if (this._bufferIndex + 1 == this._bufferEndOffset || this.charAt(this._bufferIndex + 1) != '=') break;
                this._tokenType = ExpressionTokenType.Equals;
                this._tokenEndOffset = this._bufferIndex + 2;
                break;
            }
            case '!': {
                if (this._bufferIndex + 1 != this._bufferEndOffset && this.charAt(this._bufferIndex + 1) == '=') {
                    this._tokenType = ExpressionTokenType.NotEquals;
                    this._tokenEndOffset = this._bufferIndex + 2;
                    break;
                }
                this._tokenType = ExpressionTokenType.Not;
                this._tokenEndOffset = this._bufferIndex + 1;
                break;
            }
            default: {
                if (!Character.isJavaIdentifierStart(c)) break;
                this._tokenType = ExpressionTokenType.Identifier;
                this._tokenEndOffset = this.getIdentifier(c);
            }
        }
        if (this._tokenEndOffset > this._bufferEndOffset) {
            this._tokenEndOffset = this._bufferEndOffset;
        }
    }

    private int getIdentifier(char c) {
        int offset;
        StringBuilder id = new StringBuilder().append(c);
        for (offset = this._bufferIndex + 1; offset < this._bufferEndOffset && (Character.isJavaIdentifierPart(c = this.charAt(offset)) || c == '.'); ++offset) {
            id.append(c);
        }
        return offset;
    }

    private char charAt(int i) {
        return this._buffer.charAt(i);
    }

    private int skipWhitespace(int offset) {
        if (offset >= this._bufferEndOffset) {
            return this._bufferEndOffset;
        }
        int pos = offset;
        char c = this.charAt(pos);
        while (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f') {
            if (++pos == this._bufferEndOffset) {
                return pos;
            }
            c = this.charAt(pos);
        }
        return pos;
    }

    private int getClosingQuote(int offset) {
        int pos;
        block6: {
            if (offset >= this._bufferEndOffset) {
                return this._bufferEndOffset;
            }
            pos = offset;
            char c = this.charAt(pos);
            while (true) {
                if (c != '\"' && c != '\n' && c != '\r' && c != '\\') {
                    if (++pos >= this._bufferEndOffset) {
                        return this._bufferEndOffset;
                    }
                    c = this.charAt(pos);
                    continue;
                }
                if (c != '\\') break;
                if (++pos >= this._bufferEndOffset) {
                    return this._bufferEndOffset;
                }
                c = this.charAt(pos);
                if (c == '\n' || c == '\r') continue;
                if (++pos >= this._bufferEndOffset) {
                    return this._bufferEndOffset;
                }
                c = this.charAt(pos);
            }
            if (c == '\"') break block6;
            --pos;
        }
        return pos + 1;
    }
}

