/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.codegen;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import manifold.api.fs.IFile;
import manifold.api.json.AbstractJsonTypeManifold;
import manifold.api.json.Json;
import manifold.api.json.codegen.IJsonParentType;
import manifold.api.json.codegen.IJsonType;
import manifold.api.json.codegen.JsonStructureType;
import manifold.api.json.codegen.schema.JsonSchemaType;
import manifold.api.json.codegen.schema.JsonUnionType;
import manifold.api.json.codegen.schema.LazyRefJsonType;
import manifold.api.json.codegen.schema.TypeAttributes;
import manifold.ext.RuntimeMethods;

public class JsonListType
extends JsonSchemaType {
    private final State _state = new State();

    public JsonListType(String label, IFile source, JsonSchemaType parent, TypeAttributes attr) {
        super(label, source, parent, attr);
        this._state._innerTypes = Collections.emptyMap();
    }

    @Override
    protected void resolveRefsImpl() {
        super.resolveRefsImpl();
        if (this._state._componentType instanceof JsonSchemaType) {
            ((JsonSchemaType)this._state._componentType).resolveRefs();
        } else if (this._state._componentType instanceof LazyRefJsonType) {
            this._state._componentType = ((LazyRefJsonType)this._state._componentType).resolve();
        }
        for (Map.Entry entry : new HashSet(this._state._innerTypes.entrySet())) {
            IJsonType type = (IJsonType)entry.getValue();
            if (type instanceof JsonSchemaType) {
                ((JsonSchemaType)type).resolveRefs();
                continue;
            }
            if (!(type instanceof LazyRefJsonType)) continue;
            this._state._innerTypes.put(entry.getKey(), (IJsonParentType)((LazyRefJsonType)type).resolve());
        }
    }

    @Override
    public void addChild(String name, IJsonParentType type) {
        if (this._state._innerTypes.isEmpty()) {
            this._state._innerTypes = new LinkedHashMap();
        }
        this._state._innerTypes.put(name, type);
    }

    @Override
    public IJsonType findChild(String name) {
        IJsonType innerType = (IJsonType)this._state._innerTypes.get(name);
        if (innerType == null) {
            List<IJsonType> definitions;
            if (this._state._componentType instanceof IJsonParentType) {
                innerType = ((IJsonParentType)this._state._componentType).findChild(name);
            }
            if (innerType == null && (definitions = this.getDefinitions()) != null) {
                for (IJsonType child : definitions) {
                    if (!child.getName().equals(name)) continue;
                    innerType = child;
                    break;
                }
            }
        }
        return innerType;
    }

    public IJsonType getComponentType() {
        return this._state._componentType;
    }

    public void setComponentType(IJsonType compType) {
        if (this._state._componentType != null && this._state._componentType != compType) {
            throw new IllegalStateException("Component type already set to: " + this._state._componentType.getIdentifier() + ", which is not the same as: " + compType.getIdentifier());
        }
        this._state._componentType = compType;
    }

    public Map<String, IJsonParentType> getInnerTypes() {
        return this._state._innerTypes;
    }

    @Override
    public JsonListType merge(IJsonType that) {
        if (!(that instanceof JsonListType)) {
            return null;
        }
        JsonListType other = (JsonListType)that;
        JsonListType mergedType = new JsonListType(this.getLabel(), this.getFile(), this.getParent(), this.getTypeAttributes().blendWith(that.getTypeAttributes()));
        if (!this.getComponentType().equalsStructurally(other.getComponentType())) {
            IJsonType componentType = Json.mergeTypes(this.getComponentType(), other.getComponentType());
            if (componentType != null) {
                mergedType.setComponentType(componentType);
            } else {
                return null;
            }
        }
        if (!this.mergeInnerTypes(other, mergedType, this._state._innerTypes)) {
            return null;
        }
        return mergedType;
    }

    @Override
    public void render(AbstractJsonTypeManifold tm, StringBuilder sb, int indent, boolean mutable) {
        this.setTm(tm);
        String name = this.getName();
        String identifier = this.addActualNameAnnotation(sb, indent, name, false);
        if (!(this.getParent() instanceof JsonStructureType && ((JsonStructureType)this.getParent()).addSourcePositionAnnotation(sb, indent, identifier) || this.getToken() == null)) {
            this.addSourcePositionAnnotation(sb, indent, identifier, this.getToken());
        }
        String typeName = this.getIdentifier();
        this.indent(sb, indent);
        sb.append("@Structural(factoryClass=" + typeName + ".ProxyFactory.class)\n");
        this.indent(sb, indent);
        String componentType = this.makeTypeParameter(this.getComponentType(), true, false);
        sb.append("public interface ").append(identifier).append(" extends IJsonList<" + componentType + "> {\n");
        this.renderFileField(sb, indent + 2);
        this.renderStaticMembers(sb, indent + 2);
        this.renderUnionAccessors(sb, indent + 2);
        this.renderInnerTypes(sb, indent, mutable);
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void renderUnionAccessors(StringBuilder sb, int indent) {
        IJsonType componentType = this.getComponentType();
        if (!(componentType instanceof JsonUnionType)) {
            return;
        }
        if (this.isCollapsedUnionEnum(componentType)) {
            return;
        }
        for (IJsonType constituentType : this.getConstituents(componentType, new LinkedHashSet<IJsonType>())) {
            sb.append('\n');
            String specificPropertyType = this.getConstituentQn(constituentType, componentType);
            if (constituentType instanceof JsonSchemaType) {
                this.addTypeReferenceAnnotation(sb, indent + 2, (JsonSchemaType)this.getConstituentQnComponent(constituentType));
            }
            this.indent(sb, indent + 2);
            String unionName = this.makeMemberIdentifier(constituentType);
            sb.append("default " + specificPropertyType + " getAs" + unionName + "(int index) {\n");
            this.indent(sb, indent + 4);
            if (constituentType instanceof JsonListType || specificPropertyType.indexOf(62) > 0) {
                sb.append("return (" + specificPropertyType + ")getList().get(index);\n");
            } else {
                String rawSpecificPropertyType = this.removeGenerics(specificPropertyType);
                sb.append("return (" + specificPropertyType + ")").append(RuntimeMethods.class.getSimpleName()).append(".coerce(getList().get(index), " + rawSpecificPropertyType + ".class);\n");
            }
            this.indent(sb, indent + 2);
            sb.append("}\n");
            specificPropertyType = this.getConstituentQn(constituentType, componentType, true);
            if (constituentType instanceof JsonSchemaType) {
                this.addTypeReferenceAnnotation(sb, indent + 2, (JsonSchemaType)this.getConstituentQnComponent(constituentType));
            }
            this.indent(sb, indent + 2);
            sb.append("default void setAs" + unionName + "(int index, " + specificPropertyType + " " + '$' + "value) {\n");
            this.indent(sb, indent + 4);
            sb.append("getList().set(index, ").append(RuntimeMethods.class.getSimpleName()).append(".coerceToBindingValue($value));\n");
            this.indent(sb, indent + 2);
            sb.append("}\n");
            if (constituentType instanceof JsonSchemaType) {
                this.addTypeReferenceAnnotation(sb, indent + 2, (JsonSchemaType)this.getConstituentQnComponent(constituentType));
            }
            this.indent(sb, indent + 2);
            sb.append("default void addAs" + unionName + "(int index, " + specificPropertyType + " " + '$' + "value) {\n");
            this.indent(sb, indent + 4);
            sb.append("getList().add(index, ").append(RuntimeMethods.class.getSimpleName()).append(".coerceToBindingValue($value));\n");
            this.indent(sb, indent + 2);
            sb.append("}\n");
        }
    }

    private Set<IJsonType> getConstituents(IJsonType type, Set<IJsonType> constituents) {
        if (type instanceof JsonUnionType) {
            constituents.addAll(((JsonUnionType)type).getConstituents());
        } else if (type instanceof JsonListType) {
            this.getConstituents(((JsonListType)type).getComponentType(), constituents);
        }
        return constituents;
    }

    private void renderStaticMembers(StringBuilder sb, int indent) {
        String typeName = this.getIdentifier();
        this.addCreateMethod(sb, indent, typeName);
        this.addLoadMethod(sb, indent, typeName);
        this.addRequestMethods(sb, indent, typeName);
        this.addFromSourceMethod(sb, indent);
    }

    private void addLoadMethod(StringBuilder sb, int indent, String typeName) {
        this.indent(sb, indent);
        sb.append("static ").append("Loader<" + typeName + ">").append(" load() {\n");
        this.indent(sb, indent);
        sb.append("  return new Loader<>();\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void addCreateMethod(StringBuilder sb, int indent, String typeName) {
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" create() {\n");
        this.indent(sb, indent);
        sb.append("  return (" + typeName + ")new ArrayList();\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void renderInnerTypes(StringBuilder sb, int indent, boolean mutable) {
        this.addProxy(sb, indent);
        this.addProxyFactory(sb, indent);
        this.renderJsonInnerTypes(sb, indent, mutable);
    }

    private void renderJsonInnerTypes(StringBuilder sb, int indent, boolean mutable) {
        for (IJsonParentType child : this._state._innerTypes.values()) {
            child.renderInner(this.getTm(), sb, indent + 2, mutable);
        }
        List<IJsonType> definitions = this.getDefinitions();
        if (definitions != null) {
            for (IJsonType child : definitions) {
                if (!(child instanceof IJsonParentType)) continue;
                ((IJsonParentType)child).renderInner(this.getTm(), sb, indent + 2, mutable);
            }
        }
    }

    private void addProxy(StringBuilder sb, int indent) {
        String typeName = this.getIdentifier();
        this.indent(sb, indent += 2);
        sb.append("class Proxy implements " + typeName + " {\n");
        this.indent(sb, indent);
        sb.append("  private final List _list;\n");
        this.indent(sb, indent);
        sb.append("  private Proxy(List list) {_list = list;}\n");
        this.indent(sb, indent);
        sb.append("  public List getList() {return _list;}\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void addProxyFactory(StringBuilder sb, int indent) {
        String typeName = this.getIdentifier();
        this.indent(sb, indent += 2);
        sb.append("class ProxyFactory implements IProxyFactory<List, " + this.getIdentifier() + "> {\n");
        this.indent(sb, indent);
        sb.append("  public " + this.getIdentifier() + " proxy(List list, Class<" + this.getIdentifier() + "> iface) {\n");
        this.indent(sb, indent);
        sb.append("    return new Proxy(list);\n");
        this.indent(sb, indent);
        sb.append("  }\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    @Override
    public boolean equalsStructurally(IJsonType o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonListType that = (JsonListType)o;
        if (this._state._componentType == null || !this._state._componentType.equalsStructurally(that._state._componentType)) {
            return false;
        }
        return this._state._innerTypes.size() == that._state._innerTypes.size() && this._state._innerTypes.keySet().stream().allMatch(key -> that._state._innerTypes.containsKey(key) && ((IJsonParentType)this._state._innerTypes.get(key)).equalsStructurally((IJsonType)that._state._innerTypes.get(key)));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.isSchemaType()) {
            return false;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonListType that = (JsonListType)o;
        if (this._state._componentType == null || !this._state._componentType.equals(that._state._componentType)) {
            return false;
        }
        return this._state._innerTypes.equals(that._state._innerTypes);
    }

    @Override
    public int hashCode() {
        int result = this._state._componentType == null ? 0 : this._state._componentType.hashCode();
        result = 31 * result + this._state._innerTypes.hashCode();
        return result;
    }

    private static final class State {
        private IJsonType _componentType;
        private Map<String, IJsonParentType> _innerTypes;

        private State() {
        }
    }
}

