/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptException;
import manifold.api.fs.IFile;
import manifold.api.host.IManifoldHost;
import manifold.api.json.AbstractJsonTypeManifold;
import manifold.api.json.codegen.DynamicType;
import manifold.api.json.codegen.IJsonParentType;
import manifold.api.json.codegen.IJsonType;
import manifold.api.json.codegen.JsonBasicType;
import manifold.api.json.codegen.JsonListType;
import manifold.api.json.codegen.JsonStructureType;
import manifold.api.json.codegen.schema.JsonSchemaTransformer;
import manifold.api.json.codegen.schema.JsonSchemaTransformerSession;
import manifold.api.json.codegen.schema.JsonSchemaType;
import manifold.api.json.codegen.schema.JsonUnionType;
import manifold.api.json.codegen.schema.TypeAttributes;
import manifold.api.json.parser.IJsonParser;
import manifold.api.json.parser.Token;
import manifold.api.util.ManEscapeUtil;
import manifold.api.util.Pair;
import manifold.util.concurrent.LocklessLazyVar;

public class Json {
    private static String _parser = System.getProperty("manifold.json.parser");
    private static final LocklessLazyVar<IJsonParser> PARSER = new LocklessLazyVar<IJsonParser>(){

        protected IJsonParser init() {
            String fqn = Json.getParserName();
            return fqn == null ? IJsonParser.getDefaultParser() : this.makeParser(fqn);
        }

        private IJsonParser makeParser(String fqn) {
            try {
                return (IJsonParser)Class.forName(fqn).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };

    public static String getParserName() {
        return _parser;
    }

    public static void setParserName(String fqn) {
        _parser = fqn;
        PARSER.clear();
    }

    public static String toJson(Map thisMap) {
        StringBuilder sb = new StringBuilder();
        Json.toJson(thisMap, sb, 0);
        return sb.toString();
    }

    public static void toJson(Map thisMap, StringBuilder sb, int indent) {
        int iKey = 0;
        if (Json.isNewLine(sb)) {
            Json.indent(sb, indent);
        }
        sb.append("{\n");
        if (thisMap.size() > 0) {
            for (Object key : thisMap.keySet()) {
                Json.indent(sb, indent + 2);
                sb.append('\"').append(key).append('\"').append(": ");
                Object value = thisMap.get(key);
                if (value instanceof Map) {
                    Json.toJson((Map)value, sb, indent + 2);
                } else if (value instanceof Iterable) {
                    Json.listToJson(sb, indent + 2, (Iterable)value);
                } else {
                    Json.appendValue(sb, value);
                }
                Json.appendCommaNewLine(sb, iKey < thisMap.size() - 1);
                ++iKey;
            }
        }
        Json.indent(sb, indent);
        sb.append("}");
    }

    protected static void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    public static StringBuilder appendValue(StringBuilder sb, Object comp) {
        if (comp instanceof String) {
            sb.append('\"');
            sb.append(ManEscapeUtil.escapeForJavaStringLiteral((String)((String)comp)));
            sb.append('\"');
        } else if (comp instanceof Integer || comp instanceof Long || comp instanceof Double || comp instanceof Float || comp instanceof Short || comp instanceof Character || comp instanceof Byte || comp instanceof Boolean) {
            sb.append(comp);
        } else if (comp == null) {
            sb.append("null");
        } else {
            throw new IllegalStateException("Unsupported expando type: " + comp.getClass());
        }
        return sb;
    }

    public static String toJson(Object value) {
        StringBuilder target = new StringBuilder();
        Json.toJson(target, 0, value);
        return target.toString();
    }

    public static void toJson(StringBuilder target, int margin, Object value) {
        if (value instanceof Pair) {
            value = ((Pair)value).getSecond();
        }
        if (value instanceof Map) {
            Json.toJson((Map)value, target, margin);
        } else if (value instanceof Iterable) {
            Json.listToJson(target, margin, (Iterable)value);
        } else {
            Json.appendValue(target, value);
        }
    }

    private static boolean isNewLine(StringBuilder sb) {
        return sb.length() > 0 && sb.charAt(sb.length() - 1) == '\n';
    }

    public static void listToJson(StringBuilder sb, int indent, Iterable value) {
        sb.append('[');
        int i = 0;
        Iterator iter = value.iterator();
        while (iter.hasNext()) {
            Object comp = iter.next();
            if (i == 0) {
                sb.append("\n");
            }
            if (comp instanceof Map) {
                Json.toJson((Map)comp, sb, indent + 2);
            } else if (comp instanceof Iterable) {
                Json.listToJson(sb, indent + 2, (Iterable)comp);
            } else {
                Json.indent(sb, indent + 2);
                Json.appendValue(sb, comp);
            }
            Json.appendCommaNewLine(sb, iter.hasNext());
            ++i;
        }
        Json.indent(sb, indent);
        sb.append("]");
    }

    public static String listToJson(Iterable list) {
        StringBuilder sb = new StringBuilder();
        Json.listToJson(sb, 0, list);
        return sb.toString();
    }

    private static void appendCommaNewLine(StringBuilder sb, boolean bComma) {
        if (bComma) {
            sb.append(',');
        }
        sb.append("\n");
    }

    public static Object fromJson(String json) {
        return Json.fromJson(json, false, false);
    }

    public static Object fromJson(String json, boolean withBigNumbers, boolean withTokens) {
        try {
            return ((IJsonParser)PARSER.get()).parseJson(json, withBigNumbers, withTokens);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public static String makeStructureTypes(IManifoldHost host, String nameForStructure, Bindings bindings, AbstractJsonTypeManifold tm, boolean mutable) {
        JsonStructureType type = (JsonStructureType)Json.transformJsonObject(host, nameForStructure, null, bindings);
        StringBuilder sb = new StringBuilder();
        type.render(tm, sb, 0, mutable);
        return sb.toString();
    }

    public static IJsonType transformJsonObject(IManifoldHost host, String name, JsonSchemaType parent, Object jsonObj) {
        return Json.transformJsonObject(host, name, null, parent, jsonObj);
    }

    public static IJsonType transformJsonObject(IManifoldHost host, String name, IFile source, JsonSchemaType parent, Object jsonObj) {
        IJsonType type = null;
        if (parent != null) {
            type = parent.findChild(name);
        }
        if (jsonObj instanceof Pair) {
            jsonObj = ((Pair)jsonObj).getSecond();
        }
        if (jsonObj == null) {
            return DynamicType.instance();
        }
        if (jsonObj instanceof Bindings) {
            if (JsonSchemaTransformer.isSchema((Bindings)jsonObj)) {
                type = JsonSchemaTransformer.transform(host, name, source, jsonObj);
            } else {
                if (!(type instanceof JsonStructureType)) {
                    type = new JsonStructureType(parent, source, name, new TypeAttributes());
                }
                for (Object k : ((Bindings)jsonObj).keySet()) {
                    IJsonType memberType;
                    String key = (String)k;
                    Object value = ((Bindings)jsonObj).get(key);
                    Token token = null;
                    if (value instanceof Pair) {
                        token = ((Token[])((Pair)value).getFirst())[0];
                    }
                    if ((memberType = Json.transformJsonObject(host, key, (JsonSchemaType)type, value)) == null) continue;
                    ((JsonStructureType)type).addMember(key, memberType, token);
                }
                if (parent != null) {
                    parent.addChild(name, (IJsonParentType)type);
                }
            }
        } else if (jsonObj instanceof List) {
            if (!(type instanceof JsonListType)) {
                type = new JsonListType(name, source, parent, new TypeAttributes());
            }
            IJsonType compType = ((JsonListType)type).getComponentType();
            if (!((List)jsonObj).isEmpty()) {
                String nameItem = name + "Item";
                int i = 0;
                boolean isDissimilar = Json.isDissimilar((List)jsonObj);
                for (Object elem : (List)jsonObj) {
                    IJsonType csr = Json.transformJsonObject(host, nameItem + (isDissimilar ? Integer.valueOf(i++) : ""), (JsonSchemaType)type, elem);
                    if (compType != null && csr != compType && compType != DynamicType.instance()) {
                        csr = Json.mergeTypes(compType, csr);
                    }
                    compType = csr;
                }
            } else if (compType == null) {
                compType = DynamicType.instance();
            }
            ((JsonListType)type).setComponentType(compType);
            if (parent != null) {
                parent.addChild(name, (IJsonParentType)type);
            }
        } else {
            type = JsonBasicType.get(jsonObj);
        }
        if (parent == null && type instanceof JsonSchemaType) {
            ((JsonSchemaType)type).resolveRefs();
            JsonSchemaTransformerSession.instance().maybeClear();
        }
        return type;
    }

    private static boolean isDissimilar(List jsonObj) {
        Class<?> type = null;
        for (Object o : jsonObj) {
            Class<?> csr;
            if (type == null) {
                type = o == null ? null : o.getClass();
                continue;
            }
            Class<?> clazz = csr = o == null ? null : o.getClass();
            if (csr != null && csr != type) {
                return true;
            }
            type = csr;
        }
        return false;
    }

    public static IJsonType mergeTypes(IJsonType type1, IJsonType type2) {
        IJsonType mergedType = Json.mergeTypesNoUnion(type1, type2);
        if (mergedType == null && type1.getParent() instanceof JsonListType) {
            JsonListType listType = (JsonListType)type1.getParent();
            JsonUnionType unionType = new JsonUnionType(listType, listType.getFile(), "UnionType", new TypeAttributes());
            unionType.merge(type1);
            unionType.merge(type2);
            mergedType = unionType;
        }
        if (mergedType != null) {
            return mergedType;
        }
        throw new RuntimeException("Incompatible types: " + type1.getIdentifier() + " vs: " + (type2 instanceof JsonListType ? "Array: " : "") + type2.getIdentifier());
    }

    public static IJsonType mergeTypesNoUnion(IJsonType type1, IJsonType type2) {
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        if (type1.equalsStructurally(type2)) {
            return type1;
        }
        if (type1 == DynamicType.instance()) {
            return type2;
        }
        if (type2 == DynamicType.instance()) {
            return type1;
        }
        IJsonType mergedType = type1.merge(type2);
        if (mergedType == null) {
            mergedType = type2.merge(type1);
        }
        return mergedType;
    }
}

