/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.codegen.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import manifold.api.json.codegen.schema.IJsonFormatTypeResolver;
import manifold.api.json.codegen.schema.JsonFormatType;
import manifold.ext.api.ICallHandler;

public class BigNumberFormatResolver
implements IJsonFormatTypeResolver {
    private static final JsonFormatType BIG_INTEGER = new JsonFormatType("big-integer", BigInteger.class);
    private static final JsonFormatType BIG_DECIMAL = new JsonFormatType("big-decimal", BigDecimal.class);
    private static final List<JsonFormatType> ALL = Arrays.asList(BIG_DECIMAL, BIG_INTEGER);

    @Override
    public Set<String> getFormats() {
        return ALL.stream().map(JsonFormatType::getName).collect(Collectors.toSet());
    }

    @Override
    public JsonFormatType resolveType(String format) {
        if (BIG_INTEGER.getFormat().equals(format)) {
            return BIG_INTEGER;
        }
        if (BIG_DECIMAL.getFormat().equals(format)) {
            return BIG_DECIMAL;
        }
        return null;
    }

    public Object coerce(Object value, Class<?> type) {
        if (type == BigInteger.class && value instanceof String) {
            return "0".equals(value) ? BigInteger.ZERO : new BigInteger((String)value);
        }
        if (type == BigDecimal.class && value instanceof String) {
            return "0".equals(value) ? BigDecimal.ZERO : new BigDecimal((String)value);
        }
        if ((value instanceof BigInteger || value instanceof BigDecimal) && type == String.class) {
            return value.toString();
        }
        return ICallHandler.UNHANDLED;
    }

    public Object toBindingValue(Object value) {
        if (value instanceof BigInteger || value instanceof BigDecimal) {
            return value.toString();
        }
        return ICallHandler.UNHANDLED;
    }
}

