/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.csv.parser;

public class CsvToken {
    private final Type _type;
    private final String _value;
    private final int _offset;
    private final int _line;
    private final int _tokenLength;
    private final int _separatorPos;
    private final char _separatorChar;

    public CsvToken(Type type, String value, int line, int offset, int length, int separatorPos, char separatorChar) {
        this._type = type;
        this._value = value;
        this._line = line;
        this._offset = offset;
        this._tokenLength = length;
        this._separatorPos = separatorPos;
        this._separatorChar = separatorChar;
        this.verifyQuotes();
        this.verifyLength();
    }

    private void verifyLength() {
        if (this.getTokenLength() < this._value.length()) {
            throw new IllegalStateException("Token length < value length");
        }
    }

    private void verifyQuotes() {
        if (this.getType() == Type.Quoted && (this._value.charAt(0) != '\"' || this._value.charAt(this._value.length() - 1) != '\"')) {
            throw new IllegalStateException("Quoted value missing quote: " + this._value);
        }
    }

    public Type getType() {
        return this._type;
    }

    public String getValue() {
        return this._value;
    }

    public String getData() {
        return this.getType() == Type.Quoted ? this.getValue().substring(1, this.getValue().length() - 1) : this.getValue();
    }

    public int getOffset() {
        return this._offset;
    }

    public int getTokenLength() {
        return this._tokenLength;
    }

    public int getLine() {
        return this._line;
    }

    public int getSeparatorPos() {
        return this._separatorPos;
    }

    public char getSeparatorChar() {
        return this._separatorChar;
    }

    public boolean isEmpty() {
        return this.getData().isEmpty();
    }

    public boolean isLastInRecord() {
        return this._separatorChar == '\n' || this._separatorChar == '\u0000';
    }

    public boolean isEof() {
        return this._separatorChar == '\u0000';
    }

    static enum Type {
        Quoted,
        NotQuoted;

    }
}

