/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.codegen.schema;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import manifold.api.json.codegen.schema.IJsonFormatTypeResolver;
import manifold.api.json.codegen.schema.JsonFormatType;
import manifold.ext.RuntimeMethods;
import manifold.ext.api.ICallHandler;
import manifold.util.concurrent.LocklessLazyVar;

public class DefaultFormatResolver
implements IJsonFormatTypeResolver {
    private final LocklessLazyVar<Map<String, JsonFormatType>> _formatToType = LocklessLazyVar.make(() -> {
        HashMap<String, JsonFormatType> formatToType = new HashMap<String, JsonFormatType>();
        formatToType.put("date-time", new JsonFormatType("date-time", LocalDateTime.class));
        formatToType.put("date", new JsonFormatType("date", LocalDate.class));
        formatToType.put("time", new JsonFormatType("time", LocalTime.class));
        formatToType.put("full-date", new JsonFormatType("full-date", LocalDateTime.class));
        formatToType.put("utc-millisec", new JsonFormatType("utc-millisec", Instant.class));
        formatToType.put("int64", new JsonFormatType("int64", Long.class));
        return formatToType;
    });

    @Override
    public Set<String> getFormats() {
        return ((Map)this._formatToType.get()).keySet();
    }

    @Override
    public JsonFormatType resolveType(String format) {
        return (JsonFormatType)((Map)this._formatToType.get()).get(format);
    }

    public Object coerce(Object value, Class<?> type) {
        if (type == LocalDateTime.class) {
            return LocalDateTime.parse(String.valueOf(value), DateTimeFormatter.ISO_DATE_TIME);
        }
        if (type == LocalDate.class) {
            return LocalDate.parse(String.valueOf(value), DateTimeFormatter.ISO_DATE);
        }
        if (type == LocalTime.class) {
            return LocalTime.parse(String.valueOf(value), DateTimeFormatter.ISO_TIME);
        }
        if (type == Instant.class) {
            if (!(value instanceof Number)) {
                value = Long.valueOf(String.valueOf(value));
            }
            long millis = ((Number)value).longValue();
            long secs = millis / 1000L;
            return Instant.ofEpochSecond(secs, (millis - secs * 1000L) * 1000000L);
        }
        if (type == Long.class || type == Long.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                return Long.valueOf(String.valueOf(value));
            }
        }
        if ((value instanceof LocalDateTime || value instanceof LocalDate || value instanceof LocalTime) && type == String.class) {
            return value.toString();
        }
        if (value instanceof Instant) {
            if (Number.class.isAssignableFrom(type)) {
                return RuntimeMethods.coerce((Object)((Instant)value).toEpochMilli(), type);
            }
            if (type == String.class) {
                return value.toString();
            }
        }
        if (type == String.class && value instanceof Long) {
            return String.valueOf(value);
        }
        return ICallHandler.UNHANDLED;
    }

    public Object toBindingValue(Object value) {
        if (value instanceof LocalDateTime || value instanceof LocalDate || value instanceof LocalTime) {
            return value.toString();
        }
        if (value instanceof Instant) {
            return ((Instant)value).toEpochMilli();
        }
        return ICallHandler.UNHANDLED;
    }
}

