/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.script.Bindings;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.fs.def.FileFragmentImpl;
import manifold.api.json.AbstractJsonTypeManifold;
import manifold.api.json.DynamicType;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonIssue;
import manifold.api.json.JsonListType;
import manifold.api.json.Token;
import manifold.api.json.schema.JsonEnumType;
import manifold.api.json.schema.JsonSchemaType;
import manifold.api.json.schema.JsonUnionType;
import manifold.api.json.schema.LazyRefJsonType;
import manifold.api.json.schema.TypeAttributes;
import manifold.ext.RuntimeMethods;
import manifold.internal.javac.IIssue;
import manifold.util.JsonUtil;
import manifold.util.ManEscapeUtil;
import manifold.util.Pair;

public class JsonStructureType
extends JsonSchemaType {
    private static final String FROM_SOURCE_METHOD = "fromSource";
    private final State _state = new State();
    private Map<String, IJsonType> _allMembers;
    private Set<String> _allRequired;

    public JsonStructureType(JsonSchemaType parent, IFile source, String name, TypeAttributes attr) {
        super(name, source, parent, attr);
        this._state._membersByName = new LinkedHashMap();
        this._state._memberLocations = new LinkedHashMap();
        this._state._innerTypes = Collections.emptyMap();
        this._state._unionMembers = Collections.emptyMap();
        this._state._superTypes = Collections.emptyList();
        this._state._requiredWithTokens = Collections.emptySet();
        this._state._required = Collections.emptySet();
    }

    @Override
    protected void resolveRefsImpl() {
        super.resolveRefsImpl();
        this.resolveSuperTypes();
        this.resolveMembers();
        this.resolveUnions();
        this.resolveInnerTypes();
        this.resolveAndVerifyRequiredProperties();
    }

    private void resolveSuperTypes() {
        ArrayList copy = new ArrayList(this._state._superTypes);
        for (int i = 0; i < copy.size(); ++i) {
            IJsonType type = (IJsonType)copy.get(i);
            if (type instanceof JsonSchemaType) {
                ((JsonSchemaType)type).resolveRefs();
                continue;
            }
            if (!(type instanceof LazyRefJsonType)) continue;
            type = ((LazyRefJsonType)type).resolve();
            this._state._superTypes.set(i, type);
        }
    }

    private void resolveMembers() {
        for (Map.Entry entry : new LinkedHashSet(this._state._membersByName.entrySet())) {
            IJsonType type = (IJsonType)entry.getValue();
            if (type instanceof JsonSchemaType) {
                ((JsonSchemaType)type).resolveRefs();
                continue;
            }
            if (!(type instanceof LazyRefJsonType)) continue;
            type = ((LazyRefJsonType)type).resolve();
            this._state._membersByName.put(entry.getKey(), type);
            this.addUnionMemberAccess((String)entry.getKey(), type);
        }
    }

    private void resolveInvertedUnionMember(String name, JsonStructureType type) {
        Set unionConstituents = type.getSuperTypes().stream().filter(e -> e instanceof JsonUnionType).flatMap(e -> ((JsonUnionType)e).getConstituents().stream()).collect(Collectors.toSet());
        if (unionConstituents.isEmpty()) {
            return;
        }
        JsonUnionType unionType = new JsonUnionType(type.getParent(), type.getFile(), type.getName(), type.getTypeAttributes().copy());
        unionType.setJsonSchema();
        type.getParent().addChild(unionType.getLabel(), unionType);
        type.getInnerTypes().forEach((n, inner) -> {
            if (!(inner instanceof JsonUnionType)) {
                unionType.addChild((String)n, (IJsonParentType)inner);
                if (inner instanceof JsonSchemaType) {
                    ((JsonSchemaType)inner).setParent(unionType);
                }
            }
        });
        for (IJsonType constituent : unionConstituents) {
            JsonStructureType newConstituent = new JsonStructureType(unionType, type.getFile(), constituent.getName(), constituent.getTypeAttributes().copy());
            newConstituent.addSuper(constituent);
            type.getSuperTypes().forEach(newConstituent::addSuper);
            type.getMembers().forEach((n, member) -> newConstituent.addMember((String)n, (IJsonType)member, type.getMemberLocations().get(n)));
            unionType.addConstituent(constituent.getName(), newConstituent);
        }
        this._state._membersByName.remove(name);
        Token token = (Token)this._state._memberLocations.remove(name);
        this.addMember(name, unionType, token);
    }

    private void resolveUnions() {
        for (Map.Entry entry : new LinkedHashSet(this._state._unionMembers.entrySet())) {
            LinkedHashSet<IJsonType> types = new LinkedHashSet<IJsonType>();
            for (IJsonType type : (Set)entry.getValue()) {
                if (type instanceof JsonSchemaType) {
                    ((JsonSchemaType)type).resolveRefs();
                } else if (type instanceof LazyRefJsonType) {
                    type = ((LazyRefJsonType)type).resolve();
                }
                types.add(type);
            }
            this._state._unionMembers.put(entry.getKey(), types);
        }
    }

    private void resolveInnerTypes() {
        for (Map.Entry entry : new LinkedHashSet(this._state._innerTypes.entrySet())) {
            IJsonType type = (IJsonType)entry.getValue();
            if (type instanceof JsonSchemaType) {
                ((JsonSchemaType)type).resolveRefs();
                continue;
            }
            if (!(type instanceof LazyRefJsonType)) continue;
            type = ((LazyRefJsonType)type).resolve();
            this._state._innerTypes.put(entry.getKey(), (IJsonParentType)type);
        }
    }

    private void resolveAndVerifyRequiredProperties() {
        if (this._state._requiredWithTokens != null) {
            for (Object req : this._state._requiredWithTokens) {
                Object requiredNames;
                if (req instanceof Pair) {
                    Token token = ((Token[])((Pair)req).getFirst())[0];
                    requiredNames = ((Pair)req).getSecond();
                    if (requiredNames instanceof Collection) {
                        this.verifyAllRequired((Collection)requiredNames, token);
                    }
                } else {
                    requiredNames = req;
                }
                if (!(requiredNames instanceof Collection)) continue;
                this.addRequired((Collection)requiredNames);
            }
            this._state._requiredWithTokens = Collections.emptySet();
        }
    }

    private boolean isSuperParentMe(IJsonType type) {
        return type.getParent() == this || type.getParent() != null && type.getParent().getName().equals("definitions") && type.getParent().getParent().getName().equals(this.getName());
    }

    public void addSuper(IJsonType superType) {
        if (this._state._superTypes.isEmpty()) {
            this._state._superTypes = new ArrayList();
        }
        this._state._superTypes.add(superType);
    }

    private List<IJsonType> getSuperTypes() {
        return this._state._superTypes;
    }

    @Override
    public void addChild(String name, IJsonParentType type) {
        if (this._state._innerTypes.isEmpty()) {
            this._state._innerTypes = new LinkedHashMap();
        }
        this._state._innerTypes.put(name, type);
    }

    @Override
    public IJsonType findChild(String name) {
        List<IJsonType> definitions;
        IJsonParentType innerType = (IJsonParentType)this._state._innerTypes.get(name);
        if (innerType == null && (definitions = this.getDefinitions()) != null) {
            for (IJsonType child : definitions) {
                if (!child.getIdentifier().equals(name)) continue;
                innerType = (IJsonParentType)child;
                break;
            }
        }
        if (innerType == null) {
            for (Set constituents : this._state._unionMembers.values()) {
                for (IJsonType c : constituents) {
                    if (c.getIdentifier().equals(name)) {
                        innerType = (IJsonParentType)c;
                        continue;
                    }
                    while (c instanceof JsonListType) {
                        c = ((JsonListType)c).getComponentType();
                    }
                    if (!c.getIdentifier().equals(name)) continue;
                    innerType = (IJsonParentType)c;
                }
            }
        }
        return innerType;
    }

    public Map<String, IJsonType> getMembers() {
        return this._state._membersByName;
    }

    private Map<String, IJsonType> getAllMembers() {
        if (this._allMembers != null) {
            return this._allMembers;
        }
        LinkedHashMap<String, IJsonType> allMembers = new LinkedHashMap<String, IJsonType>(this._state._membersByName);
        for (IJsonType extended : this.getSuperTypes()) {
            if (!(extended instanceof JsonStructureType)) continue;
            allMembers.putAll(((JsonStructureType)extended).getMembers());
        }
        this._allMembers = allMembers;
        return this._allMembers;
    }

    protected Map<String, Token> getMemberLocations() {
        return this._state._memberLocations;
    }

    public Map<String, IJsonParentType> getInnerTypes() {
        return this._state._innerTypes;
    }

    public void addMember(String name, IJsonType type, Token token) {
        block6: {
            IJsonType existingType = (IJsonType)this._state._membersByName.get(name);
            if (existingType != null && existingType != type) {
                if (type == DynamicType.instance()) {
                    return;
                }
                if (existingType != DynamicType.instance()) {
                    try {
                        type = Json.mergeTypes(existingType, type);
                        if (type == null) {
                            throw new RuntimeException("Types disagree for '" + name + "' from array data: " + existingType.getName() + " vs: " + existingType.getName());
                        }
                    }
                    catch (Exception e) {
                        String message = e.getMessage();
                        this.addIssue(new JsonIssue(IIssue.Kind.Error, token, message));
                        type = DynamicType.instance();
                        if (message != null && !message.isEmpty()) break block6;
                        e.printStackTrace();
                    }
                }
            }
        }
        this._state._membersByName.put(name, type);
        this._state._memberLocations.put(name, token);
        this.addUnionMemberAccess(name, type);
    }

    private void addUnionMemberAccess(String name, IJsonType type) {
        if (type instanceof JsonUnionType) {
            for (IJsonType iJsonType : ((JsonUnionType)type).getConstituents()) {
                if (this._state._unionMembers.isEmpty()) {
                    this._state._unionMembers = new LinkedHashMap();
                }
                Set union = this._state._unionMembers.computeIfAbsent(name, k -> new LinkedHashSet());
                union.add(iJsonType);
            }
        } else if (type instanceof JsonListType) {
            this.addUnionMemberAccess(name, ((JsonListType)type).getComponentType());
        }
    }

    private IJsonType findMemberType(String name) {
        return (IJsonType)this._state._membersByName.get(name);
    }

    @Override
    public IJsonType merge(IJsonType that) {
        if (!(that instanceof JsonStructureType) || that instanceof JsonEnumType) {
            return null;
        }
        JsonStructureType other = (JsonStructureType)that;
        if (!this.getName().equals(other.getName())) {
            return null;
        }
        TypeAttributes mergedTypeAttributes = this.getTypeAttributes().blendWith(other.getTypeAttributes());
        JsonStructureType mergedType = new JsonStructureType(this.getParent(), this.getFile(), this.getName(), mergedTypeAttributes);
        for (Map.Entry e : this._state._membersByName.entrySet()) {
            String memberName = (String)e.getKey();
            IJsonType memberType = other.findMemberType(memberName);
            memberType = memberType != null ? Json.mergeTypes((IJsonType)e.getValue(), memberType) : (IJsonType)e.getValue();
            if (memberType != null) {
                mergedType.addMember(memberName, memberType, (Token)this._state._memberLocations.get(memberName));
                continue;
            }
            return null;
        }
        if (!this.mergeInnerTypes(other, mergedType, this._state._innerTypes)) {
            return null;
        }
        return mergedType;
    }

    @Override
    public void render(AbstractJsonTypeManifold tm, StringBuilder sb, int indent, boolean mutable) {
        this.setTm(tm);
        JsonEnumType enumType = this.getAllOfEnumType();
        if (enumType != null) {
            enumType.render(tm, sb, indent, mutable);
            return;
        }
        if (this.getParent() != null) {
            sb.append('\n');
        }
        String name = this.getName();
        String identifier = this.addActualNameAnnotation(sb, indent, name, false);
        if (!(this.getParent() instanceof JsonStructureType && ((JsonStructureType)this.getParent()).addSourcePositionAnnotation(sb, indent, identifier) || this.getToken() == null)) {
            this.addSourcePositionAnnotation(sb, indent, identifier, this.getToken());
        }
        String typeName = this.getIdentifier();
        this.indent(sb, indent);
        sb.append("@Structural(factoryClass=" + typeName + ".ProxyFactory.class)\n");
        if (this.getIFile() instanceof IFileFragment) {
            this.indent(sb, indent);
            sb.append("@FragmentValue(methodName=\"fromSource\", type=\"" + typeName + "\")\n");
        }
        this.indent(sb, indent);
        sb.append("public interface ").append(identifier).append(this.addSuperTypes(sb, identifier)).append(" {\n");
        this.renderFileField(sb, indent + 2);
        this.renderStaticMembers(sb, indent + 2);
        this.renderProperties(sb, indent, mutable);
        this.addAdditionalPropertiesMethods(sb, indent, mutable);
        this.renderInnerTypes(sb, indent, mutable);
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void renderInnerTypes(StringBuilder sb, int indent, boolean mutable) {
        this.addProxy(sb, indent);
        this.addProxyFactory(sb, indent);
        this.addBuilder(sb, indent);
        this.addCopier(sb, indent);
        for (IJsonParentType child : this._state._innerTypes.values()) {
            child.render(this.getTm(), sb, indent + 2, mutable);
        }
        List<IJsonType> definitions = this.getDefinitions();
        if (definitions != null) {
            for (IJsonType child : definitions) {
                if (!(child instanceof IJsonParentType)) continue;
                ((IJsonParentType)child).render(this.getTm(), sb, indent + 2, mutable);
            }
        }
    }

    private void renderProperties(StringBuilder sb, int indent, boolean mutable) {
        this.renderProperties(sb, indent, mutable, new HashSet<String>());
    }

    private void renderProperties(StringBuilder sb, int indent, boolean mutable, Set<String> rendered) {
        for (String key : this._state._membersByName.keySet()) {
            boolean isReadOnly;
            boolean isWriteOnly;
            if (rendered.contains(key)) continue;
            rendered.add(key);
            sb.append('\n');
            IJsonType type = (IJsonType)this._state._membersByName.get(key);
            boolean bl = isWriteOnly = type.getTypeAttributes().getWriteOnly() != null && type.getTypeAttributes().getWriteOnly() != false;
            if (!isWriteOnly) {
                this.addGetter(sb, indent, type, key);
            }
            boolean bl2 = isReadOnly = type.getTypeAttributes().getReadOnly() != null && type.getTypeAttributes().getReadOnly() != false;
            if (mutable && !isReadOnly) {
                String propertyType = this.getPropertyType(type, false, true);
                this.addSetter(sb, indent, key, propertyType);
            }
            this.renderUnionAccessors(sb, indent, mutable, key, type);
        }
        for (IJsonType superType : this.getSuperTypes()) {
            if (!this.isSuperParentMe(superType) || superType instanceof JsonEnumType) continue;
            ((JsonStructureType)superType).setTm(this.getTm());
            ((JsonStructureType)superType).renderProperties(sb, indent, mutable, rendered);
        }
    }

    private void addGetter(StringBuilder sb, int indent, IJsonType type, String key) {
        this.addSourcePositionAnnotation(sb, indent + 2, key);
        String identifier = this.addActualNameAnnotation(sb, indent + 2, key, true);
        this.indent(sb, indent + 2);
        String propertyType = this.getPropertyType(type);
        sb.append("default " + propertyType + " get" + identifier + "() {\n");
        this.indent(sb, indent + 4);
        String componentType = this.getPropertyType(this.getComponentType(type));
        sb.append("return (" + propertyType + ")").append(RuntimeMethods.class.getSimpleName()).append(".coerce(getBindings().get(\"" + key + "\"), " + componentType + ".class);\n");
        this.indent(sb, indent + 2);
        sb.append("}\n");
    }

    private IJsonType getComponentType(IJsonType type) {
        if (type instanceof JsonListType) {
            return this.getComponentType(((JsonListType)type).getComponentType());
        }
        return type;
    }

    private void addSetter(StringBuilder sb, int indent, String key, String propertyType) {
        this.addSourcePositionAnnotation(sb, indent + 2, key);
        String identifier = this.addActualNameAnnotation(sb, indent + 2, key, true);
        this.indent(sb, indent + 2);
        sb.append("default void set" + identifier + "(").append(propertyType).append(" $value) {\n");
        this.indent(sb, indent + 4);
        sb.append("getBindings().put(\"" + key + "\", ").append(RuntimeMethods.class.getSimpleName()).append(".coerceToBindingValue($value));\n");
        this.indent(sb, indent + 2);
        sb.append("}\n");
    }

    private void addAdditionalPropertiesMethods(StringBuilder sb, int indent, boolean mutable) {
        boolean isPatternProperties;
        Object addProps = this.getTypeAttributes().getAdditionalProperties();
        boolean isAdditionalProperties = addProps == null || !(addProps instanceof Boolean) || (Boolean)addProps != false;
        boolean bl = isPatternProperties = this.getTypeAttributes().getPatternProperties() != null && !this.getTypeAttributes().getPatternProperties().isEmpty();
        if (!isAdditionalProperties && !isPatternProperties) {
            return;
        }
        this.indent(sb, indent + 2);
        sb.append("default Object get(String $name) {\n");
        this.indent(sb, indent + 4);
        sb.append("return getBindings().get($name);\n");
        this.indent(sb, indent + 2);
        sb.append("}\n");
        if (mutable) {
            this.indent(sb, indent + 2);
            sb.append("default Object put(String $name, Object $value) {\n");
            this.indent(sb, indent + 4);
            sb.append("return getBindings().put($name, ").append(RuntimeMethods.class.getSimpleName()).append(".coerceToBindingValue($value));\n");
            this.indent(sb, indent + 2);
            sb.append("}\n");
        }
    }

    private void renderUnionAccessors(StringBuilder sb, int indent, boolean mutable, String key, IJsonType type) {
        if (this.isCollapsedUnionEnum(type)) {
            return;
        }
        Set union = (Set)this._state._unionMembers.get(key);
        if (union != null) {
            for (IJsonType constituentType : union) {
                sb.append('\n');
                String specificPropertyType = this.getConstituentQn(constituentType, type);
                this.addSourcePositionAnnotation(sb, indent + 2, key);
                if (constituentType instanceof JsonSchemaType) {
                    this.addTypeReferenceAnnotation(sb, indent + 2, (JsonSchemaType)this.getConstituentQnComponent(constituentType));
                }
                String identifier = this.addActualNameAnnotation(sb, indent + 2, key, true);
                this.indent(sb, indent + 2);
                String unionName = this.makeMemberIdentifier(constituentType);
                sb.append("default " + specificPropertyType + " get" + identifier).append("As" + unionName + "() {\n");
                this.indent(sb, indent + 4);
                if (constituentType instanceof JsonListType || specificPropertyType.indexOf(62) > 0) {
                    sb.append("return (" + specificPropertyType + ")getBindings().get(\"" + key + "\");\n");
                } else {
                    String rawSpecificPropertyType = this.removeGenerics(specificPropertyType);
                    sb.append("return (" + specificPropertyType + ")").append(RuntimeMethods.class.getSimpleName()).append(".coerce(getBindings().get(\"" + key + "\"), " + rawSpecificPropertyType + ".class);\n");
                }
                this.indent(sb, indent + 2);
                sb.append("}\n");
                if (!mutable) continue;
                specificPropertyType = this.getConstituentQn(constituentType, type, true);
                this.addSourcePositionAnnotation(sb, indent + 2, key);
                if (constituentType instanceof JsonSchemaType) {
                    this.addTypeReferenceAnnotation(sb, indent + 2, (JsonSchemaType)this.getConstituentQnComponent(constituentType));
                }
                this.addActualNameAnnotation(sb, indent + 2, key, true);
                this.indent(sb, indent + 2);
                sb.append("default void set" + identifier).append("As" + unionName + "(" + specificPropertyType + " " + '$' + "value) {\n");
                this.indent(sb, indent + 4);
                sb.append("getBindings().put(\"" + key + "\", ").append(RuntimeMethods.class.getSimpleName()).append(".coerceToBindingValue($value));\n");
                this.indent(sb, indent + 2);
                sb.append("}\n");
            }
        }
    }

    private JsonEnumType getAllOfEnumType() {
        if (!this.getMembers().isEmpty()) {
            return null;
        }
        if (this.getSuperTypes().stream().allMatch(e -> e instanceof JsonEnumType)) {
            return this.makeEnumType(this.getSuperTypes());
        }
        return null;
    }

    protected JsonEnumType makeEnumType(Collection<? extends IJsonType> types) {
        JsonEnumType result = null;
        JsonEnumType prev = null;
        for (IJsonType iJsonType : types) {
            prev = result = new JsonEnumType(prev == null ? (JsonEnumType)iJsonType : prev, prev == null ? null : (JsonEnumType)iJsonType, this.getParent(), this.getName());
        }
        return result;
    }

    private String addSuperTypes(StringBuilder sb, String ifaceName) {
        sb.append(" extends IJsonBindingsBacked");
        List<IJsonType> superTypes = this.getSuperTypes();
        if (superTypes.isEmpty()) {
            return "";
        }
        for (IJsonType superType : superTypes) {
            if (this.isSuperParentMe(superType) || !(superType instanceof JsonStructureType) || superType instanceof JsonUnionType) continue;
            sb.append(", ");
            sb.append(this.getPropertyType(superType));
        }
        return "";
    }

    public boolean addSourcePositionAnnotation(StringBuilder sb, int indent, String name) {
        Token token = (Token)this._state._memberLocations.get(name);
        if (token == null) {
            return false;
        }
        return this.addSourcePositionAnnotation(sb, indent, name, token);
    }

    private void renderStaticMembers(StringBuilder sb, int indent) {
        String typeName = this.getIdentifier();
        this.addCreateMethod(sb, indent, typeName);
        this.addBuilderMethod(sb, indent);
        this.addCopierMethod(sb, indent);
        this.addCopyMethod(sb, indent);
        this.addLoadMethod(sb, indent, typeName);
        this.addRequestMethod(sb, indent, typeName);
        this.addInstanceMethod(sb, indent);
    }

    private void addInstanceMethod(StringBuilder sb, int indent) {
        String methodName;
        IFile file = this.getIFile();
        if (this.isSchemaType() || !this.isParentRoot()) {
            return;
        }
        String typeName = this.getIdentifier();
        this.indent(sb, indent);
        sb.append("static " + typeName + " " + FROM_SOURCE_METHOD + "() {\n");
        this.indent(sb, indent);
        switch (file.getExtension()) {
            case "json": {
                methodName = "fromJson";
                break;
            }
            case "yaml": 
            case "yml": {
                methodName = "fromYaml";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (file instanceof FileFragmentImpl) {
            sb.append("  return load().").append(methodName).append("(\"").append(this.getContentForLiteral((FileFragmentImpl)file)).append("\");\n");
        } else {
            String resourceFile = '/' + this.getFqn(this).replace('.', '/') + '.' + file.getExtension();
            sb.append("  return load().").append(methodName).append("Reader").append("(new java.io.InputStreamReader(" + typeName + ".class.getResourceAsStream(\"" + resourceFile + "\")));\n");
        }
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private String getContentForLiteral(FileFragmentImpl file) {
        String content = file.getContent();
        return ManEscapeUtil.escapeForJavaStringLiteral((String)content);
    }

    private void addBuilderMethod(StringBuilder sb, int indent) {
        this.indent(sb, indent);
        sb.append("static Builder builder(");
        Set<String> allRequired = this.getAllRequired();
        Map<String, IJsonType> allMembers = this.getAllMembers();
        this.addRequiredParams(sb, allRequired, allMembers);
        sb.append(") {\n");
        this.indent(sb, indent += 2);
        sb.append("return new Builder(");
        int count = 0;
        for (String param : allRequired) {
            IJsonType paramType = allMembers.get(param);
            if (paramType.getTypeAttributes().getDefaultValue() != null) continue;
            if (count++ > 0) {
                sb.append(", ");
            }
            String paramName = this.makeIdentifier(param, false);
            sb.append("" + paramName);
        }
        sb.append(");\n");
        this.indent(sb, indent -= 2);
        sb.append("}\n");
    }

    private void addCopierMethod(StringBuilder sb, int indent) {
        String typeName = this.getIdentifier();
        this.indent(sb, indent);
        sb.append("static Copier copier(" + typeName + " from) {return new Copier(from);}\n");
    }

    private void addProxy(StringBuilder sb, int indent) {
        String typeName = this.getIdentifier();
        this.indent(sb, indent += 2);
        sb.append("class Proxy implements " + typeName + " {\n");
        this.indent(sb, indent);
        sb.append("  private final Bindings _bindings;\n");
        this.indent(sb, indent);
        sb.append("  private Proxy(Bindings bindings) {_bindings = bindings;}\n");
        this.indent(sb, indent);
        sb.append("  public Bindings getBindings() {return _bindings;}\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void addProxyFactory(StringBuilder sb, int indent) {
        String typeName = this.getIdentifier();
        this.indent(sb, indent += 2);
        sb.append("class ProxyFactory implements IProxyFactory<Map, " + this.getIdentifier() + "> {\n");
        this.indent(sb, indent);
        sb.append("  public " + this.getIdentifier() + " proxy(Map bindings, Class<" + this.getIdentifier() + "> iface) {\n");
        this.indent(sb, indent);
        sb.append("    if(!(bindings instanceof Bindings)) {bindings = new DataBindings(bindings);}\n");
        this.indent(sb, indent);
        sb.append("    return new Proxy((Bindings)bindings);\n");
        this.indent(sb, indent);
        sb.append("  }\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void addBuilder(StringBuilder sb, int indent) {
        this.indent(sb, indent += 2);
        sb.append("class Builder {\n");
        this.indent(sb, indent += 2);
        sb.append("private final Bindings _bindings;\n");
        this.indent(sb, indent);
        this.addBuilderConstructor(sb, indent);
        this.addWithMethods(this.getNotRequired(), "Builder", sb, indent);
        this.addBuildMethod(sb, indent);
        this.indent(sb, indent - 2);
        sb.append("}\n");
    }

    private void addBuilderConstructor(StringBuilder sb, int indent) {
        sb.append("private Builder(");
        Set<String> allRequired = this.getAllRequired();
        Map<String, IJsonType> allMembers = this.getAllMembers();
        this.addRequiredParams(sb, allRequired, allMembers);
        sb.append(") {\n");
        this.indent(sb, indent += 2);
        sb.append("_bindings = create(");
        int count = 0;
        for (String param : allRequired) {
            IJsonType paramType = allMembers.get(param);
            if (paramType.getTypeAttributes().getDefaultValue() != null) continue;
            if (count++ > 0) {
                sb.append(", ");
            }
            String paramName = this.makeIdentifier(param, false);
            sb.append("" + paramName);
        }
        sb.append(").getBindings();\n");
        this.indent(sb, indent -= 2);
        sb.append("}\n");
    }

    private void addBuildMethod(StringBuilder sb, int indent) {
        String typeName = this.getIdentifier();
        this.indent(sb, indent);
        sb.append("public " + typeName + " build() {\n");
        this.indent(sb, indent + 2);
        sb.append("return (" + typeName + ")_bindings;\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void addCopier(StringBuilder sb, int indent) {
        this.indent(sb, indent);
        sb.append("class Copier {\n");
        this.indent(sb, indent);
        sb.append("  private final Bindings _bindings;\n");
        this.indent(sb, indent);
        this.addCopierConstructor(sb, indent);
        this.addWithMethods(this.getNotRequired(), "Copier", sb, indent);
        this.addCopierCopyMethod(sb, indent);
        this.indent(sb, indent - 2);
        sb.append("}\n");
    }

    private void addCopierCopyMethod(StringBuilder sb, int indent) {
        String typeName = this.getIdentifier();
        this.indent(sb, indent);
        sb.append("public " + typeName + " copy() {return (" + typeName + ")_bindings;}\n");
    }

    private void addCopierConstructor(StringBuilder sb, int indent) {
        String typeName = this.getIdentifier();
        this.indent(sb, indent);
        sb.append("private Copier(" + typeName + " from) {_bindings = from.copy().getBindings();}\n");
    }

    private void addCopyMethod(StringBuilder sb, int indent) {
        String typeName = this.getIdentifier();
        this.indent(sb, indent);
        sb.append("default " + typeName + " copy() {return (" + typeName + ")getBindings().deepCopy();}\n");
    }

    private void addWithMethods(Map<String, IJsonType> fields, String builderType, StringBuilder sb, int indent) {
        for (Map.Entry<String, IJsonType> entry : fields.entrySet()) {
            String propertyType = this.getPropertyType(entry.getValue(), false, true);
            String key = entry.getKey();
            String suffix = this.makeIdentifier(key, true);
            this.addSourcePositionAnnotation(sb, indent + 2, key);
            String identifier = this.addActualNameAnnotation(sb, indent + 2, key, false);
            this.indent(sb, indent);
            sb.append("public " + builderType + " with" + suffix + "(" + propertyType + " " + identifier + ") {\n");
            this.indent(sb, indent);
            sb.append("  _bindings.put(\"" + key + "\", ").append(RuntimeMethods.class.getSimpleName()).append(".coerceToBindingValue(" + identifier + "));\n");
            this.indent(sb, indent);
            sb.append("  return this;\n");
            this.indent(sb, indent);
            sb.append("}\n");
            this.renderUnionAccessors_With(builderType, sb, indent, key, entry.getValue());
        }
    }

    private void renderUnionAccessors_With(String builderType, StringBuilder sb, int indent, String key, IJsonType type) {
        if (this.isCollapsedUnionEnum(type)) {
            return;
        }
        Set union = (Set)this._state._unionMembers.get(key);
        if (union != null) {
            for (IJsonType constituentType : union) {
                sb.append('\n');
                String specificPropertyType = this.getConstituentQn(constituentType, type);
                String unionName = this.makeMemberIdentifier(constituentType);
                this.addSourcePositionAnnotation(sb, indent + 2, key);
                if (constituentType instanceof JsonSchemaType) {
                    this.addTypeReferenceAnnotation(sb, indent + 2, (JsonSchemaType)this.getConstituentQnComponent(constituentType));
                }
                String identifier = this.addActualNameAnnotation(sb, indent + 2, key, true);
                this.indent(sb, indent + 2);
                sb.append("public " + builderType + " with").append(identifier).append("As").append(unionName).append("(").append(specificPropertyType).append(" $value) {\n");
                this.indent(sb, indent + 2);
                sb.append("  _bindings.put(\"" + key + "\", ").append(RuntimeMethods.class.getSimpleName()).append(".coerceToBindingValue($value));\n");
                sb.append("  return this;\n");
                this.indent(sb, indent + 2);
                sb.append("}\n");
            }
        }
    }

    private Map<String, IJsonType> getNotRequired() {
        LinkedHashMap<String, IJsonType> result = new LinkedHashMap<String, IJsonType>();
        Set<String> allRequired = this.getAllRequired();
        this.getAllMembers().forEach((key, value) -> {
            if (!allRequired.contains(key)) {
                result.put((String)key, (IJsonType)value);
            }
        });
        return result;
    }

    private void addCreateMethod(StringBuilder sb, int indent, String typeName) {
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" create(");
        Set<String> allRequired = this.getAllRequired();
        Map<String, IJsonType> allMembers = this.getAllMembers();
        this.addRequiredParams(sb, allRequired, allMembers);
        sb.append(") {\n");
        this.indent(sb, indent + 2);
        sb.append("DataBindings bindings_ = new DataBindings();\n");
        for (String string : allRequired) {
            IJsonType paramType = allMembers.get(string);
            if (paramType == null || paramType.getTypeAttributes().getDefaultValue() != null) continue;
            this.indent(sb, indent + 2);
            String passedInParam = this.makeIdentifier(string, false);
            sb.append("bindings_.put(\"" + string + "\", ").append(RuntimeMethods.class.getSimpleName()).append(".coerceToBindingValue(" + passedInParam + "));\n");
        }
        for (Map.Entry entry : allMembers.entrySet()) {
            Object defaultValue = ((IJsonType)entry.getValue()).getTypeAttributes().getDefaultValue();
            if (defaultValue == null) continue;
            this.indent(sb, indent + 2);
            sb.append("bindings_.put(\"" + (String)entry.getKey() + "\", ");
            if (defaultValue instanceof Bindings || defaultValue instanceof List) {
                this.indent(sb, indent + 2);
                sb.append("Json.fromJson(\"");
                StringBuilder defValJson = new StringBuilder();
                JsonUtil.toJson((StringBuilder)defValJson, (int)0, (Object)defaultValue);
                sb.append(ManEscapeUtil.escapeForJava((String)defValJson.toString()));
                sb.append("\")");
            } else {
                JsonUtil.toJson((StringBuilder)sb, (int)0, (Object)defaultValue);
            }
            sb.append(");\n");
        }
        this.indent(sb, indent + 2);
        sb.append("return (" + typeName + ")bindings_;\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void addRequiredParams(StringBuilder sb, Set<String> allRequired, Map<String, IJsonType> allMembers) {
        int count = 0;
        for (String param : allRequired) {
            IJsonType paramType = allMembers.get(param);
            if (paramType.getTypeAttributes().getDefaultValue() != null) continue;
            if (count++ > 0) {
                sb.append(", ");
            }
            String paramTypeName = this.getPropertyType(paramType, false, true);
            String paramName = this.makeIdentifier(param, false);
            sb.append(paramTypeName + " " + paramName);
        }
    }

    private void addLoadMethod(StringBuilder sb, int indent, String typeName) {
        this.indent(sb, indent);
        sb.append("static ").append("Loader<" + typeName + ">").append(" load() {\n");
        this.indent(sb, indent);
        sb.append("  return new Loader<>();\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void addRequestMethod(StringBuilder sb, int indent, String typeName) {
        this.indent(sb, indent);
        sb.append("static ").append("Requester<" + typeName + ">").append(" request(String urlBase) {\n");
        this.indent(sb, indent);
        sb.append("  return new Requester<>(urlBase);\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    @Override
    public boolean equalsStructurally(IJsonType o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonStructureType that = (JsonStructureType)o;
        int[] i = new int[]{0};
        if (this._state._superTypes.size() != that._state._superTypes.size() || !this._state._superTypes.stream().allMatch(t -> {
            int n = i[0];
            i[0] = n + 1;
            return ((IJsonType)that._state._superTypes.get(n)).equalsStructurally((IJsonType)t);
        })) {
            return false;
        }
        if (this._state._membersByName.size() != that._state._membersByName.size() || !this._state._membersByName.keySet().stream().allMatch(key -> that._state._membersByName.containsKey(key) && ((IJsonType)this._state._membersByName.get(key)).equalsStructurally((IJsonType)that._state._membersByName.get(key)))) {
            return false;
        }
        if (this._state._unionMembers.size() != that._state._unionMembers.size() || !this._state._unionMembers.keySet().stream().allMatch(key -> that._state._unionMembers.containsKey(key) && this.typeSetsSame((Set)this._state._unionMembers.get(key), (Set)that._state._unionMembers.get(key)))) {
            return false;
        }
        return this._state._innerTypes.size() == that._state._innerTypes.size() && this._state._innerTypes.keySet().stream().allMatch(key -> that._state._innerTypes.containsKey(key) && ((IJsonParentType)this._state._innerTypes.get(key)).equalsStructurally((IJsonType)that._state._innerTypes.get(key)));
    }

    private boolean typeSetsSame(Set<IJsonType> t1, Set<IJsonType> t2) {
        if (t1.size() != t2.size()) {
            return false;
        }
        Iterator<IJsonType> iter1 = t1.iterator();
        Iterator<IJsonType> iter2 = t2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            if (iter1.next().equalsStructurally(iter2.next())) continue;
            return false;
        }
        return !iter1.hasNext() && !iter2.hasNext();
    }

    public boolean isRequired(String name) {
        if (this._state._required.contains(name)) {
            return true;
        }
        for (IJsonType extended : this.getSuperTypes()) {
            if (!(extended instanceof JsonStructureType) || !((JsonStructureType)extended).isRequired(name)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getAllRequired() {
        if (this._allRequired != null) {
            return this._allRequired;
        }
        LinkedHashSet<String> allRequired = new LinkedHashSet<String>();
        for (IJsonType extended : this.getSuperTypes()) {
            if (!(extended instanceof JsonStructureType)) continue;
            allRequired.addAll(((JsonStructureType)extended)._state._required);
        }
        allRequired.addAll(this._state._required);
        this._allRequired = allRequired;
        return this._allRequired;
    }

    private void verifyAllRequired(Collection<String> allRequired, Token token) {
        Iterator<String> iterator = allRequired.iterator();
        while (iterator.hasNext()) {
            String req = iterator.next();
            IJsonType paramType = this.getAllMembers().get(req);
            if (paramType != null) continue;
            iterator.remove();
            this.addIssue(new JsonIssue(IIssue.Kind.Error, token, "Cannot resolve required property: '" + req + "' on type: " + this.getName()));
        }
    }

    public void addRequiredWithTokens(Object withTokens) {
        if (withTokens != null) {
            if (this._state._requiredWithTokens.isEmpty()) {
                this._state._requiredWithTokens = new LinkedHashSet();
            }
            this._state._requiredWithTokens.add(withTokens);
        }
    }

    private void addRequired(Collection<String> required) {
        if (this._state._required.isEmpty()) {
            this._state._required = new LinkedHashSet();
        }
        this._state._required.addAll(required);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.isSchemaType()) {
            return this == o;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonStructureType type = (JsonStructureType)o;
        if (!this._state._superTypes.equals(type._state._superTypes)) {
            return false;
        }
        if (!this._state._membersByName.equals(type._state._membersByName)) {
            return false;
        }
        if (!this._state._unionMembers.equals(type._state._unionMembers)) {
            return false;
        }
        return this._state._innerTypes.equals(type._state._innerTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this._state._superTypes.hashCode();
        result = 31 * result + this._state._membersByName.keySet().hashCode();
        result = 31 * result + this._state._unionMembers.keySet().hashCode();
        return result;
    }

    public String toString() {
        return this.getFqn();
    }

    private static final class State {
        private List<IJsonType> _superTypes;
        private Map<String, IJsonType> _membersByName;
        private Map<String, Set<IJsonType>> _unionMembers;
        private Map<String, Token> _memberLocations;
        private Map<String, IJsonParentType> _innerTypes;
        private Set<String> _required;
        private Set<Object> _requiredWithTokens;

        private State() {
        }
    }
}

