/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import manifold.api.fs.IFile;
import manifold.api.json.IJsonType;
import manifold.api.json.schema.JsonSchemaTransformer;
import manifold.util.Pair;

public class JsonSchemaTransformerSession {
    private static final ThreadLocal<JsonSchemaTransformerSession> INSTANCE = new ThreadLocal();
    private Map<IFile, Pair<IJsonType, JsonSchemaTransformer>> _baseTypeByUrl = new HashMap<IFile, Pair<IJsonType, JsonSchemaTransformer>>();
    private Stack<JsonSchemaTransformer> _transformers = new Stack();

    public static JsonSchemaTransformerSession instance() {
        JsonSchemaTransformerSession instance = INSTANCE.get();
        if (instance == null) {
            instance = new JsonSchemaTransformerSession();
            INSTANCE.set(instance);
        }
        return instance;
    }

    private JsonSchemaTransformerSession() {
    }

    void pushTransformer(JsonSchemaTransformer transformer) {
        this._transformers.push(transformer);
    }

    void popTransformer(JsonSchemaTransformer transformer) {
        if (this._transformers.peek() != transformer) {
            throw new IllegalStateException("Unbalanced transformer pop");
        }
        this._transformers.pop();
    }

    Pair<IJsonType, JsonSchemaTransformer> getCachedBaseType(IFile url) {
        return this._baseTypeByUrl.get(url);
    }

    void cacheBaseType(IFile url, Pair<IJsonType, JsonSchemaTransformer> pair) {
        this._baseTypeByUrl.put(url, pair);
    }

    public void maybeClear() {
        if (this._transformers.size() == 0) {
            this._baseTypeByUrl.clear();
        }
    }
}

