/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.script.ScriptException;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.host.IManifoldHost;
import manifold.api.json.DataBindings;
import manifold.api.json.Json;
import manifold.api.json.JsonIssueContainer;
import manifold.api.json.codegen.ErrantType;
import manifold.api.json.codegen.IJsonParentType;
import manifold.api.json.codegen.IJsonType;
import manifold.api.json.codegen.JsonStructureType;
import manifold.api.json.codegen.schema.IllegalSchemaTypeName;
import manifold.api.json.codegen.schema.TypeAttributes;
import manifold.api.type.AbstractSingleFileModel;
import manifold.api.type.ResourceFileTypeManifold;
import manifold.api.util.JavacDiagnostic;
import manifold.internal.javac.IIssue;
import manifold.internal.javac.SourceJavaFileObject;

public class JsonModel
extends AbstractSingleFileModel {
    private IJsonParentType _type;
    private JsonIssueContainer _issues;

    public JsonModel(IManifoldHost host, String fqn, Set<IFile> files) {
        super(host, fqn, files);
        this.init();
    }

    private void init() {
        Object jsonValue;
        this._issues = null;
        try {
            jsonValue = this.load();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof ScriptException) {
                this._issues = new JsonIssueContainer((ScriptException)cause, this.getFile());
            }
            jsonValue = new DataBindings();
        }
        try {
            IJsonType type = Json.transformJsonObject(this.getHost(), this.getFile().getBaseName(), this.getFile(), null, jsonValue);
            this._type = type instanceof IJsonParentType ? (IJsonParentType)type : new JsonStructureType(null, this.getFile(), this.getFile().getBaseName(), new TypeAttributes());
        }
        catch (IllegalSchemaTypeName e) {
            this._type = new ErrantType(this.getFile(), e.getTypeName());
            if (this._issues == null) {
                this._issues = new JsonIssueContainer(this.getFile());
            }
            this._issues.addIssues(e);
        }
    }

    protected Object load() {
        return Json.fromJson(ResourceFileTypeManifold.getContent((IFile)this.getFile()), false, true);
    }

    public IJsonParentType getType() {
        return this._type;
    }

    public void updateFile(IFile file) {
        super.updateFile(file);
        this.init();
    }

    void report(DiagnosticListener<JavaFileObject> errorHandler) {
        if (errorHandler == null) {
            return;
        }
        List<IIssue> issues = this.getIssues();
        if (issues.isEmpty()) {
            return;
        }
        SourceJavaFileObject file = new SourceJavaFileObject(this.getFile().toURI());
        for (IIssue issue : issues) {
            Diagnostic.Kind kind = issue.getKind() == IIssue.Kind.Error ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
            errorHandler.report((Diagnostic<JavaFileObject>)new JavacDiagnostic((JavaFileObject)file, kind, (long)issue.getStartOffset(), (long)issue.getLine(), (long)issue.getColumn(), issue.getMessage()));
        }
    }

    private List<IIssue> getIssues() {
        ArrayList<IIssue> allIssues = new ArrayList<IIssue>();
        if (this._issues != null) {
            allIssues.addAll(this._issues.getIssues());
        }
        if (this._type != null) {
            allIssues.addAll(this._type.getIssues());
        }
        return allIssues;
    }
}

