/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.JsonBasicType;
import manifold.api.json.schema.TypeAttributes;

public class JsonFormatType
implements IJsonType {
    private final String _format;
    private final Class<?> _javaType;
    private final TypeAttributes _typeAttributes;

    JsonFormatType(String format, Class<?> javaType) {
        this(format, javaType, new TypeAttributes());
    }

    private JsonFormatType(String format, Class<?> javaType, TypeAttributes typeAttributes) {
        this._format = format;
        this._javaType = javaType;
        this._typeAttributes = typeAttributes;
    }

    public Class<?> getJavaType() {
        return this._javaType;
    }

    public String getFormat() {
        return this._format;
    }

    @Override
    public String getName() {
        return this._format;
    }

    @Override
    public IJsonParentType getParent() {
        return null;
    }

    @Override
    public TypeAttributes getTypeAttributes() {
        return this._typeAttributes;
    }

    @Override
    public IJsonType copyWithAttributes(TypeAttributes attributes) {
        if (this.getTypeAttributes().equals(attributes)) {
            return this;
        }
        return new JsonFormatType(this._format, this._javaType, this.getTypeAttributes().overrideWith(attributes));
    }

    @Override
    public JsonFormatType merge(IJsonType type) {
        if (type instanceof JsonBasicType || type instanceof JsonFormatType) {
            return this;
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        return this.getJavaType().getTypeName();
    }
}

