/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.util.List;
import java.util.function.Supplier;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.schema.JsonSchemaType;
import manifold.api.json.schema.TypeAttributes;

public class LazyRefJsonType
implements IJsonType {
    private final Supplier<IJsonType> _supplier;
    private TypeAttributes _typeAttributes;

    LazyRefJsonType(Supplier<IJsonType> supplier) {
        this._supplier = supplier;
        this._typeAttributes = new TypeAttributes();
    }

    public IJsonType resolve() {
        IJsonType type = this._supplier.get();
        while (type instanceof LazyRefJsonType) {
            type = ((LazyRefJsonType)type).resolve();
        }
        if (type instanceof JsonSchemaType) {
            ((JsonSchemaType)type).resolveRefs();
        }
        type = type.copyWithAttributes(this._typeAttributes.copy());
        return type;
    }

    @Override
    public TypeAttributes getTypeAttributes() {
        return this._typeAttributes;
    }

    @Override
    public LazyRefJsonType copyWithAttributes(TypeAttributes attributes) {
        if (this._typeAttributes.equals(attributes)) {
            return this;
        }
        LazyRefJsonType copy = new LazyRefJsonType(this._supplier);
        copy._typeAttributes = copy._typeAttributes.overrideWith(attributes);
        return copy;
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getIdentifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IJsonParentType getParent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IJsonType> getDefinitions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDefinitions(List<IJsonType> definitions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equalsStructurally(IJsonType type2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IJsonType merge(IJsonType type) {
        throw new UnsupportedOperationException();
    }
}

