/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.io.File;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import manifold.api.json.Json;
import manifold.api.json.Yaml;
import manifold.api.util.StreamUtil;
import manifold.json.extensions.java.net.URL.ManUrlExt;

public class Loader<E> {
    public E fromJson(String jsonText) {
        return (E)Json.fromJson(jsonText);
    }

    public E fromJsonUrl(String urlBase, String ... urlSuffix) {
        try {
            StringBuilder url = new StringBuilder(urlBase);
            if (urlSuffix != null) {
                Arrays.stream(urlSuffix).forEach(url::append);
            }
            return (E)ManUrlExt.getJsonContent(new URL(url.toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E fromJsonUrl(URL url) {
        return (E)ManUrlExt.getJsonContent(url);
    }

    public E fromJsonFile(File file) {
        try {
            return this.fromJsonUrl(file.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E fromJsonReader(Reader reader) {
        try {
            return (E)Json.fromJson(StreamUtil.getContent((Reader)reader));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E fromYaml(String yamlText) {
        return (E)Yaml.fromYaml(yamlText);
    }

    public E fromYamlUrl(String urlBase, String ... urlSuffix) {
        try {
            StringBuilder url = new StringBuilder(urlBase);
            if (urlSuffix != null) {
                Arrays.stream(urlSuffix).forEach(url::append);
            }
            return (E)ManUrlExt.getYamlContent(new URL(url.toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E fromYamlUrl(URL url) {
        return (E)ManUrlExt.getYamlContent(url);
    }

    public E fromYamlFile(File file) {
        try {
            return this.fromYamlUrl(file.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public E fromYamlReader(Reader reader) {
        try {
            return (E)Yaml.fromYaml(StreamUtil.getContent((Reader)reader));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

