/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.util.List;
import javax.script.Bindings;
import manifold.api.json.DynamicType;
import manifold.api.json.IJsonType;
import manifold.api.json.JsonListType;
import manifold.api.json.JsonSchemaType;
import manifold.api.json.schema.JsonSchemaTransformer;
import manifold.internal.runtime.Bootstrap;
import manifold.util.Pair;

class ArrayTransformer {
    private static final String JSCH_ITEMS = "items";
    private final JsonSchemaTransformer _schemaTx;
    private final String _name;
    private final JsonListType _type;
    private final Bindings _jsonObj;

    static JsonListType transform(JsonSchemaTransformer schemaTx, String name, JsonSchemaType parent, Bindings jsonObj) {
        ArrayTransformer arrayTx = new ArrayTransformer(schemaTx, name, parent, jsonObj);
        return arrayTx.transform();
    }

    private ArrayTransformer(JsonSchemaTransformer schemaTx, String name, JsonSchemaType parent, Bindings jsonObj) {
        this._schemaTx = schemaTx;
        this._name = name;
        this._jsonObj = jsonObj;
        this._type = new JsonListType(name, parent);
    }

    JsonListType getType() {
        return this._type;
    }

    private JsonListType transform() {
        JsonSchemaType parent = this._type.getParent();
        if (parent != null) {
            parent.addChild(this._type.getLabel(), this._type);
        }
        this._schemaTx.cache(this._type);
        this.assignComponentType();
        return this._type;
    }

    private void assignComponentType() {
        IJsonType componentType = null;
        Object value = this._jsonObj.get(JSCH_ITEMS);
        Object items = value instanceof Pair ? ((Pair)value).getSecond() : value;
        if (items instanceof List) {
            for (Object elem : (List)items) {
                IJsonType csr = this._schemaTx.transformType(this._type, this._name, (Bindings)elem);
                if (componentType == null) {
                    componentType = csr;
                    continue;
                }
                if (csr.equals(componentType)) continue;
                componentType = DynamicType.instance();
                break;
            }
        } else {
            componentType = this._schemaTx.transformType(this._type, this._name, (Bindings)items);
        }
        this._type.setComponentType(componentType);
    }

    static {
        Bootstrap.init();
    }
}

