/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import manifold.api.json.IJsonList;
import manifold.json.extensions.java.net.URL.ManUrlExt;

public class Requester<T> {
    private final String _urlBase;

    public Requester(String urlBase) {
        this._urlBase = urlBase;
    }

    public T getOne() {
        return this.getOne("", null);
    }

    public T getOne(String urlSuffix) {
        return this.getOne(urlSuffix, null);
    }

    public T getOne(Object arguments) {
        return this.getOne("", arguments);
    }

    public T getOne(String urlSuffix, Object arguments) {
        return this.getOne(urlSuffix, arguments, Format.Json);
    }

    public T getOne(String urlSuffix, Object arguments, Format format) {
        return (T)this.request(urlSuffix, Http.GET, format, arguments);
    }

    public IJsonList<T> getMany() {
        return this.getMany("", null);
    }

    public IJsonList<T> getMany(String urlSuffix) {
        return this.getMany(urlSuffix, null);
    }

    public IJsonList<T> getMany(Object arguments) {
        return this.getMany("", arguments);
    }

    public IJsonList<T> getMany(String urlSuffix, Object arguments) {
        return this.getMany(urlSuffix, arguments, Format.Json);
    }

    public IJsonList<T> getMany(String urlSuffix, Object arguments, Format format) {
        return this.request(urlSuffix, Http.GET, format, arguments);
    }

    public <R> R postOne(T payload) {
        return this.postOne("", payload);
    }

    public <R> R postOne(String urlSuffix, T payload) {
        return this.postOne(urlSuffix, payload, Format.Json);
    }

    public <R> R postOne(String urlSuffix, T payload, Format format) {
        return this.request(urlSuffix, Http.POST, format, payload);
    }

    public <R> R postMany(List<T> payload) {
        return this.postMany("", payload);
    }

    public <R> R postMany(String urlSuffix, List<T> payload) {
        return this.postMany(urlSuffix, payload, Format.Json);
    }

    public <R> R postMany(String urlSuffix, List<T> payload, Format format) {
        return this.request(urlSuffix, Http.POST, format, payload);
    }

    public <R> R putOne(T payload) {
        return this.putOne("", payload);
    }

    public <R> R putOne(String urlSuffix, T payload) {
        return this.putOne(urlSuffix, payload, Format.Json);
    }

    public <R> R putOne(String urlSuffix, T payload, Format format) {
        return this.request(urlSuffix, Http.PUT, format, payload);
    }

    public <R> R putMany(List<T> payload) {
        return this.putMany("", payload);
    }

    public <R> R putMany(String urlSuffix, List<T> payload) {
        return this.putMany(urlSuffix, payload, Format.Json);
    }

    public <R> R putMany(String urlSuffix, List<T> payload, Format format) {
        return this.request(urlSuffix, Http.PUT, format, payload);
    }

    public <R> R patchOne(T payload) {
        return this.patchOne("", payload);
    }

    public <R> R patchOne(String urlSuffix, T payload) {
        return this.patchOne(urlSuffix, payload, Format.Json);
    }

    public <R> R patchOne(String urlSuffix, T payload, Format format) {
        return this.request(urlSuffix, Http.PATCH, format, payload);
    }

    public <R> R patchMany(List<T> payload) {
        return this.patchMany("", payload);
    }

    public <R> R patchMany(String urlSuffix, List<T> payload) {
        return this.patchMany(urlSuffix, payload, Format.Json);
    }

    public <R> R patchMany(String urlSuffix, List<T> payload, Format format) {
        return this.request(urlSuffix, Http.PATCH, format, payload);
    }

    public <R> R delete(Object arguments) {
        return this.delete("", arguments);
    }

    public <R> R delete(String urlSuffix) {
        return this.delete(urlSuffix, null);
    }

    public <R> R delete(String urlSuffix, Object arguments) {
        return this.delete(urlSuffix, arguments, Format.Json);
    }

    public <R> R delete(String urlSuffix, Object arguments, Format format) {
        return this.request(urlSuffix, Http.DELETE, format, arguments);
    }

    private <R> R request(String urlSuffix, Http method, Format format, Object jsonValue) {
        switch (format) {
            case Json: {
                return Request.send((url, p, m) -> ManUrlExt.sendJsonRequest(url, m, jsonValue), method, jsonValue, this._urlBase, urlSuffix);
            }
            case Yaml: {
                return Request.send((url, p, m) -> ManUrlExt.sendYamlRequest(url, m, jsonValue), method, jsonValue, this._urlBase, urlSuffix);
            }
            case Plain: {
                return Request.send((url, p, m) -> ManUrlExt.sendPlainTextRequest(url, m, jsonValue), method, jsonValue, this._urlBase, urlSuffix);
            }
        }
        throw new IllegalArgumentException("format: " + (Object)((Object)format));
    }

    private static enum Http {
        GET,
        POST,
        PUT,
        PATCH,
        DELETE;

    }

    @FunctionalInterface
    private static interface Request {
        public Object send(URL var1, Object var2, String var3);

        public static <R> R send(Request sender, Http method, Object jsonValue, String urlBase, String urlSuffix) {
            if (urlSuffix != null) {
                urlBase = urlBase + urlSuffix;
            }
            try {
                return (R)sender.send(new URL(urlBase), jsonValue, method.name());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static enum Format {
        Json,
        Yaml,
        Plain;

    }
}

